/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.BSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.BUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.NSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.NUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.S3ClientCache;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.datamodeling.SSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.SUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.DateUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.http.annotation.GuardedBy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoDBReflector {
    private final Map<Class<?>, Collection<Method>> getterCache = new HashMap();
    private final Map<Class<?>, Method> primaryHashKeyGetterCache = new HashMap();
    private final Map<Class<?>, Method> primaryRangeKeyGetterCache = new HashMap();
    private final TableIndexInfoCache indexRangeKeyNameToLocalSecondaryIndexNamesCache = new TableIndexInfoCache();
    private final TableIndexInfoCache indexRangeKeyNameToGlobalSecondaryIndexNamesCache = new TableIndexInfoCache();
    private final TableIndexInfoCache indexHashKeyNameToGlobalSecondaryIndexNamesCache = new TableIndexInfoCache();
    private final Map<Method, Method> setterCache = new HashMap<Method, Method>();
    @GuardedBy(value="readWriteLockAttrName")
    private final Map<Method, String> attributeNameCache = new HashMap<Method, String>();
    private final Map<Method, ArgumentUnmarshaller> argumentUnmarshallerCache = new HashMap<Method, ArgumentUnmarshaller>();
    private final Map<Method, ArgumentMarshaller> argumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, ArgumentMarshaller> versionArgumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, ArgumentMarshaller> keyArgumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, Boolean> versionAttributeGetterCache = new HashMap<Method, Boolean>();
    private final Map<Method, Boolean> autoGeneratedKeyGetterCache = new HashMap<Method, Boolean>();
    private final ReentrantReadWriteLock readWriteLockAttrName = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLockAttrName = this.readWriteLockAttrName.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLockAttrName = this.readWriteLockAttrName.writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Method> getRelevantGetters(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = this.getterCache;
        synchronized (map) {
            if (!this.getterCache.containsKey(clazz)) {
                LinkedList<Method> relevantGetters = new LinkedList<Method>();
                for (Method m : clazz.getMethods()) {
                    if (!this.isRelevantGetter(m)) continue;
                    relevantGetters.add(m);
                }
                this.getterCache.put(clazz, relevantGetters);
            }
            return this.getterCache.get(clazz);
        }
    }

    private boolean isRelevantGetter(Method m) {
        return (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterTypes().length == 0 && m.getDeclaringClass().getAnnotation(DynamoDBTable.class) != null && !m.isAnnotationPresent(DynamoDBIgnore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryRangeKeyGetter(Class<T> clazz) {
        Map<Class<?>, Method> map = this.primaryRangeKeyGetterCache;
        synchronized (map) {
            if (!this.primaryRangeKeyGetterCache.containsKey(clazz)) {
                Method rangeKeyMethod = null;
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
                    rangeKeyMethod = method;
                    break;
                }
                this.primaryRangeKeyGetterCache.put(clazz, rangeKeyMethod);
            }
            return this.primaryRangeKeyGetterCache.get(clazz);
        }
    }

    <T> Collection<Method> getPrimaryKeyGetters(Class<T> clazz) {
        LinkedList<Method> keyGetters = new LinkedList<Method>();
        for (Method getter : this.getRelevantGetters(clazz)) {
            if (!getter.isAnnotationPresent(DynamoDBHashKey.class) && !getter.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
            keyGetters.add(getter);
        }
        return keyGetters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getPrimaryHashKeyGetter(Class<T> clazz) {
        Method hashKeyMethod;
        Map<Class<?>, Method> map = this.primaryHashKeyGetterCache;
        synchronized (map) {
            if (!this.primaryHashKeyGetterCache.containsKey(clazz)) {
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(DynamoDBHashKey.class)) continue;
                    this.primaryHashKeyGetterCache.put(clazz, method);
                    break;
                }
            }
            hashKeyMethod = this.primaryHashKeyGetterCache.get(clazz);
        }
        if (hashKeyMethod == null) {
            throw new DynamoDBMappingException("Public, zero-parameter hash key property must be annotated with " + DynamoDBHashKey.class);
        }
        return hashKeyMethod;
    }

    <T> DynamoDBTable getTable(Class<T> clazz) {
        DynamoDBTable table = clazz.getAnnotation(DynamoDBTable.class);
        if (table == null) {
            throw new DynamoDBMappingException("Class " + clazz + " must be annotated with " + DynamoDBTable.class);
        }
        return table;
    }

    private boolean isCustomMarshaller(Method getter) {
        return getter.isAnnotationPresent(DynamoDBMarshalling.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> ArgumentUnmarshaller getArgumentUnmarshaller(final T toReturn, final Method getter, Method setter, S3ClientCache s3cc) {
        Map<Method, ArgumentUnmarshaller> map = this.argumentUnmarshallerCache;
        synchronized (map) {
            ArgumentUnmarshaller unmarshaller = this.argumentUnmarshallerCache.get(getter);
            if (unmarshaller != null) {
                return unmarshaller;
            }
            Class<?>[] parameterTypes = setter.getParameterTypes();
            Class<?> paramType = parameterTypes[0];
            if (parameterTypes.length != 1) {
                throw new DynamoDBMappingException("Expected exactly one agument to " + setter);
            }
            unmarshaller = this.isCustomMarshaller(getter) ? new SUnmarshaller(){

                public Object unmarshall(AttributeValue value) {
                    return DynamoDBReflector.this.getCustomMarshalledValue(toReturn, getter, value);
                }
            } : this.computeArgumentUnmarshaller(toReturn, getter, setter, paramType, s3cc);
            this.argumentUnmarshallerCache.put(getter, unmarshaller);
            return unmarshaller;
        }
    }

    private <T> ArgumentUnmarshaller computeArgumentUnmarshaller(T toReturn, Method getter, Method setter, Class<?> paramType, S3ClientCache s3cc) {
        ArgumentUnmarshaller unmarshaller = null;
        boolean isCollection = Set.class.isAssignableFrom(paramType);
        if (isCollection) {
            Type genericType = setter.getGenericParameterTypes()[0];
            if (genericType instanceof ParameterizedType) {
                paramType = ((ParameterizedType)genericType).getActualTypeArguments()[0].toString().equals("byte[]") ? byte[].class : (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
            }
        } else if (Collection.class.isAssignableFrom(paramType)) {
            throw new DynamoDBMappingException("Only java.util.Set collection types are permitted for " + DynamoDBAttribute.class);
        }
        unmarshaller = Double.TYPE.isAssignableFrom(paramType) || Double.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Double> argument = new HashSet<Double>();
                for (String s : value.getNS()) {
                    argument.add(Double.parseDouble(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Double.parseDouble(value.getN());
            }
        }) : (BigDecimal.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<BigDecimal> argument = new HashSet<BigDecimal>();
                for (String s : value.getNS()) {
                    argument.add(new BigDecimal(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return new BigDecimal(value.getN());
            }
        }) : (BigInteger.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<BigInteger> argument = new HashSet<BigInteger>();
                for (String s : value.getNS()) {
                    argument.add(new BigInteger(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return new BigInteger(value.getN());
            }
        }) : (Integer.TYPE.isAssignableFrom(paramType) || Integer.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Integer> argument = new HashSet<Integer>();
                for (String s : value.getNS()) {
                    argument.add(Integer.parseInt(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Integer.parseInt(value.getN());
            }
        }) : (Float.TYPE.isAssignableFrom(paramType) || Float.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Float> argument = new HashSet<Float>();
                for (String s : value.getNS()) {
                    argument.add(Float.valueOf(Float.parseFloat(s)));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Float.valueOf(Float.parseFloat(value.getN()));
            }
        }) : (Byte.TYPE.isAssignableFrom(paramType) || Byte.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Byte> argument = new HashSet<Byte>();
                for (String s : value.getNS()) {
                    argument.add(Byte.parseByte(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Byte.parseByte(value.getN());
            }
        }) : (Long.TYPE.isAssignableFrom(paramType) || Long.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Long> argument = new HashSet<Long>();
                for (String s : value.getNS()) {
                    argument.add(Long.parseLong(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Long.parseLong(value.getN());
            }
        }) : (Short.TYPE.isAssignableFrom(paramType) || Short.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Short> argument = new HashSet<Short>();
                for (String s : value.getNS()) {
                    argument.add(Short.parseShort(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return Short.parseShort(value.getN());
            }
        }) : (Boolean.TYPE.isAssignableFrom(paramType) || Boolean.class.isAssignableFrom(paramType) ? (isCollection ? new NSUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                HashSet<Boolean> argument = new HashSet<Boolean>();
                for (String s : value.getNS()) {
                    argument.add(DynamoDBReflector.this.parseBoolean(s));
                }
                return argument;
            }
        } : new NUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return DynamoDBReflector.this.parseBoolean(value.getN());
            }
        }) : (Date.class.isAssignableFrom(paramType) ? (isCollection ? new SSUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                HashSet<Date> argument = new HashSet<Date>();
                for (String s : value.getSS()) {
                    argument.add(new DateUtils().parseIso8601Date(s));
                }
                return argument;
            }
        } : new SUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                return new DateUtils().parseIso8601Date(value.getS());
            }
        }) : (Calendar.class.isAssignableFrom(paramType) ? (isCollection ? new SSUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                HashSet<Calendar> argument = new HashSet<Calendar>();
                for (String s : value.getSS()) {
                    Calendar cal = GregorianCalendar.getInstance();
                    cal.setTime(new DateUtils().parseIso8601Date(s));
                    argument.add(cal);
                }
                return argument;
            }
        } : new SUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                Calendar cal = GregorianCalendar.getInstance();
                cal.setTime(new DateUtils().parseIso8601Date(value.getS()));
                return cal;
            }
        }) : (ByteBuffer.class.isAssignableFrom(paramType) ? (isCollection ? new BSUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                HashSet<ByteBuffer> argument = new HashSet<ByteBuffer>();
                for (ByteBuffer b : value.getBS()) {
                    argument.add(b);
                }
                return argument;
            }
        } : new BUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                return value.getB();
            }
        }) : (byte[].class.isAssignableFrom(paramType) ? (isCollection ? new BSUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                HashSet<byte[]> argument = new HashSet<byte[]>();
                for (ByteBuffer b : value.getBS()) {
                    byte[] bytes = null;
                    if (b.hasArray()) {
                        bytes = b.array();
                    } else {
                        bytes = new byte[b.limit()];
                        b.get(bytes, 0, bytes.length);
                    }
                    argument.add(bytes);
                }
                return argument;
            }
        } : new BUnmarshaller(){

            public Object unmarshall(AttributeValue value) throws ParseException {
                ByteBuffer byteBuffer = value.getB();
                byte[] bytes = null;
                if (byteBuffer.hasArray()) {
                    bytes = byteBuffer.array();
                } else {
                    bytes = new byte[byteBuffer.limit()];
                    byteBuffer.get(bytes, 0, bytes.length);
                }
                return bytes;
            }
        }) : this.defaultArgumentUnmarshaller(paramType, isCollection, s3cc)))))))))))));
        return unmarshaller;
    }

    private ArgumentUnmarshaller defaultArgumentUnmarshaller(Class<?> paramType, boolean isCollection, final S3ClientCache s3cc) {
        if (S3Link.class.isAssignableFrom(paramType)) {
            if (isCollection) {
                throw new DynamoDBMappingException("Collection types are not permitted for " + S3Link.class);
            }
            return new SUnmarshaller(){

                public Object unmarshall(AttributeValue value) {
                    if (s3cc == null) {
                        throw new IllegalStateException("Mapper must be constructed with S3 AWS Credentials to load S3Link");
                    }
                    String json = value.getS();
                    return S3Link.fromJson(s3cc, json);
                }
            };
        }
        if (!String.class.isAssignableFrom(paramType)) {
            throw new DynamoDBMappingException("Expected a String, but was " + paramType);
        }
        if (isCollection) {
            return new SSUnmarshaller(){

                public Object unmarshall(AttributeValue value) {
                    HashSet<String> argument = new HashSet<String>();
                    for (String s : value.getSS()) {
                        argument.add(s);
                    }
                    return argument;
                }
            };
        }
        return new SUnmarshaller(){

            public Object unmarshall(AttributeValue value) {
                return value.getS();
            }
        };
    }

    private <T> T getCustomMarshalledValue(T toReturn, Method getter, AttributeValue value) {
        DynamoDBMarshaller<? extends Object> marshaller;
        DynamoDBMarshalling annotation = getter.getAnnotation(DynamoDBMarshalling.class);
        Class<? extends DynamoDBMarshaller<? extends Object>> marshallerClass = annotation.marshallerClass();
        try {
            marshaller = marshallerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Couldn't instantiate marshaller of class " + marshallerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't instantiate marshaller of class " + marshallerClass, e);
        }
        return (T)marshaller.unmarshall(getter.getReturnType(), value.getS());
    }

    private AttributeValue getCustomerMarshallerAttributeValue(Method getter, Object getterReturnResult) {
        DynamoDBMarshaller<? extends Object> marshaller;
        DynamoDBMarshalling annotation = getter.getAnnotation(DynamoDBMarshalling.class);
        Class<? extends DynamoDBMarshaller<? extends Object>> marshallerClass = annotation.marshallerClass();
        try {
            marshaller = marshallerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaller for class " + marshallerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaller for class " + marshallerClass, e);
        }
        String stringValue = marshaller.marshall(getterReturnResult);
        if (stringValue == null) {
            return null;
        }
        return new AttributeValue().withS(stringValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getArgumentMarshaller(final Method getter) {
        Map<Method, ArgumentMarshaller> map = this.argumentMarshallerCache;
        synchronized (map) {
            ArgumentMarshaller marshaller = this.argumentMarshallerCache.get(getter);
            if (marshaller != null) {
                return marshaller;
            }
            marshaller = this.isCustomMarshaller(getter) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return DynamoDBReflector.this.getCustomerMarshallerAttributeValue(getter, obj);
                }
            } : this.computeArgumentMarshaller(getter);
            this.argumentMarshallerCache.put(getter, marshaller);
            return marshaller;
        }
    }

    private ArgumentMarshaller computeArgumentMarshaller(Method getter) {
        ArgumentMarshaller marshaller;
        Class<?> returnType = getter.getReturnType();
        if (Set.class.isAssignableFrom(returnType)) {
            Type genericType = getter.getGenericReturnType();
            if (genericType instanceof ParameterizedType) {
                returnType = ((ParameterizedType)genericType).getActualTypeArguments()[0].toString().equals("byte[]") ? byte[].class : (Class<?>)((ParameterizedType)genericType).getActualTypeArguments()[0];
            }
            marshaller = Date.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    LinkedList<String> timestamps = new LinkedList<String>();
                    for (Object o : (Set)obj) {
                        timestamps.add(new DateUtils().formatIso8601Date((Date)o));
                    }
                    return new AttributeValue().withSS(timestamps);
                }
            } : (Calendar.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    LinkedList<String> timestamps = new LinkedList<String>();
                    for (Object o : (Set)obj) {
                        timestamps.add(new DateUtils().formatIso8601Date(((Calendar)o).getTime()));
                    }
                    return new AttributeValue().withSS(timestamps);
                }
            } : (Boolean.TYPE.isAssignableFrom(returnType) || Boolean.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    ArrayList<String> booleanAttributes = new ArrayList<String>();
                    for (Object b : (Set)obj) {
                        if (b == null || !((Boolean)b).booleanValue()) {
                            booleanAttributes.add("0");
                            continue;
                        }
                        booleanAttributes.add("1");
                    }
                    return new AttributeValue().withNS(booleanAttributes);
                }
            } : (returnType.isPrimitive() || Number.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    ArrayList<String> attributes = new ArrayList<String>();
                    for (Object o : (Set)obj) {
                        attributes.add(String.valueOf(o));
                    }
                    return new AttributeValue().withNS(attributes);
                }
            } : (ByteBuffer.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    ArrayList<ByteBuffer> attributes = new ArrayList<ByteBuffer>();
                    for (Object o : (Set)obj) {
                        attributes.add((ByteBuffer)o);
                    }
                    return new AttributeValue().withBS(attributes);
                }
            } : (byte[].class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    ArrayList<ByteBuffer> attributes = new ArrayList<ByteBuffer>();
                    for (Object o : (Set)obj) {
                        attributes.add(ByteBuffer.wrap((byte[])o));
                    }
                    return new AttributeValue().withBS(attributes);
                }
            } : this.defaultCollectionArgumentMarshaller(returnType))))));
        } else {
            if (Collection.class.isAssignableFrom(returnType)) {
                throw new DynamoDBMappingException("Non-set collections aren't supported: " + getter.getDeclaringClass() + "." + getter.getName());
            }
            marshaller = Date.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return new AttributeValue().withS(new DateUtils().formatIso8601Date((Date)obj));
                }
            } : (Calendar.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return new AttributeValue().withS(new DateUtils().formatIso8601Date(((Calendar)obj).getTime()));
                }
            } : (Boolean.TYPE.isAssignableFrom(returnType) || Boolean.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    if (obj == null || !((Boolean)obj).booleanValue()) {
                        return new AttributeValue().withN("0");
                    }
                    return new AttributeValue().withN("1");
                }
            } : (returnType.isPrimitive() || Number.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return new AttributeValue().withN(String.valueOf(obj));
                }
            } : (returnType == String.class ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    if (((String)obj).length() == 0) {
                        return null;
                    }
                    return new AttributeValue().withS(String.valueOf(obj));
                }
            } : (returnType == ByteBuffer.class ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return new AttributeValue().withB((ByteBuffer)obj);
                }
            } : (returnType == byte[].class ? new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    return new AttributeValue().withB(ByteBuffer.wrap((byte[])obj));
                }
            } : this.defaultArgumentMarshaller(returnType, getter)))))));
        }
        return marshaller;
    }

    private ArgumentMarshaller defaultCollectionArgumentMarshaller(Class<?> returnElementType) {
        if (S3Link.class.isAssignableFrom(returnElementType)) {
            throw new DynamoDBMappingException("Collection types not permitted for " + S3Link.class);
        }
        return new ArgumentMarshaller(){

            public AttributeValue marshall(Object obj) {
                ArrayList<String> attributes = new ArrayList<String>();
                for (Object o : (Set)obj) {
                    attributes.add(String.valueOf(o));
                }
                return new AttributeValue().withSS(attributes);
            }
        };
    }

    private ArgumentMarshaller defaultArgumentMarshaller(Class<?> returnType, Method getter) {
        if (returnType == S3Link.class) {
            return new ArgumentMarshaller(){

                public AttributeValue marshall(Object obj) {
                    S3Link s3link = (S3Link)obj;
                    if (s3link.getBucketName() == null || s3link.getKey() == null) {
                        return null;
                    }
                    String json = s3link.toJson();
                    return new AttributeValue().withS(json);
                }
            };
        }
        throw new DynamoDBMappingException("Unsupported type: " + returnType + " for " + getter);
    }

    private boolean parseBoolean(String s) {
        if ("1".equals(s)) {
            return true;
        }
        if ("0".equals(s)) {
            return false;
        }
        throw new IllegalArgumentException("Expected 1 or 0 for boolean value, was " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAttributeName(Method getter) {
        String attributeName;
        this.readLockAttrName.lock();
        try {
            attributeName = this.attributeNameCache.get(getter);
        }
        finally {
            this.readLockAttrName.unlock();
        }
        if (attributeName != null) {
            return attributeName;
        }
        DynamoDBHashKey hashKeyAnnotation = getter.getAnnotation(DynamoDBHashKey.class);
        if (hashKeyAnnotation != null && (attributeName = hashKeyAnnotation.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBIndexHashKey indexHashKey = getter.getAnnotation(DynamoDBIndexHashKey.class);
        if (indexHashKey != null && (attributeName = indexHashKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBRangeKey rangeKey = getter.getAnnotation(DynamoDBRangeKey.class);
        if (rangeKey != null && (attributeName = rangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBIndexRangeKey indexRangeKey = getter.getAnnotation(DynamoDBIndexRangeKey.class);
        if (indexRangeKey != null && (attributeName = indexRangeKey.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBAttribute attribute = getter.getAnnotation(DynamoDBAttribute.class);
        if (attribute != null && (attributeName = attribute.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        DynamoDBVersionAttribute version = getter.getAnnotation(DynamoDBVersionAttribute.class);
        if (version != null && (attributeName = version.attributeName()) != null && attributeName.length() > 0) {
            return this.cacheAttributeName(getter, attributeName);
        }
        String getterName = getter.getName();
        if (getterName.startsWith("get")) {
            attributeName = getterName.substring("get".length());
        } else if (getterName.startsWith("is")) {
            attributeName = getterName.substring("is".length());
        } else {
            throw new DynamoDBMappingException("Getter must begin with 'get' or 'is'");
        }
        attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
        return this.cacheAttributeName(getter, attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String cacheAttributeName(Method getter, String attributeName) {
        this.writeLockAttrName.lock();
        try {
            this.attributeNameCache.put(getter, attributeName);
        }
        finally {
            this.writeLockAttrName.unlock();
        }
        return attributeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method getSetter(Method getter) {
        Map<Method, Method> map = this.setterCache;
        synchronized (map) {
            if (!this.setterCache.containsKey(getter)) {
                String attributeName = null;
                if (getter.getName().startsWith("get")) {
                    attributeName = getter.getName().substring("get".length());
                } else if (getter.getName().startsWith("is")) {
                    attributeName = getter.getName().substring("is".length());
                } else {
                    throw new RuntimeException("Getter method must start with 'is' or 'get'");
                }
                String setterName = "set" + attributeName;
                Method setter = null;
                try {
                    setter = getter.getDeclaringClass().getMethod(setterName, getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DynamoDBMappingException("Expected a public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                catch (SecurityException e) {
                    throw new DynamoDBMappingException("No access to public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                this.setterCache.put(getter, setter);
            }
            return this.setterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getVersionedArgumentMarshaller(final Method getter, Object getterReturnResult) {
        Map<Method, ArgumentMarshaller> map = this.versionArgumentMarshallerCache;
        synchronized (map) {
            if (!this.versionArgumentMarshallerCache.containsKey(getter)) {
                ArgumentMarshaller marshaller = null;
                Class<?> returnType = getter.getReturnType();
                if (BigInteger.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = BigInteger.ZERO;
                            }
                            BigInteger newValue = ((BigInteger)obj).add(BigInteger.ONE);
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Integer.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Integer(0);
                            }
                            Integer newValue = (Integer)obj + 1;
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Byte.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Byte(0);
                            }
                            Byte newValue = (byte)(((Byte)obj + 1) % 127);
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Long.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Long(0L);
                            }
                            Long newValue = (Long)obj + 1L;
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else {
                    throw new DynamoDBMappingException("Unsupported parameter type for " + DynamoDBVersionAttribute.class + ": " + returnType + ". Must be a whole-number type.");
                }
                this.versionArgumentMarshallerCache.put(getter, marshaller);
            }
            return this.versionArgumentMarshallerCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getAutoGeneratedKeyArgumentMarshaller(final Method getter) {
        Map<Method, ArgumentMarshaller> map = this.keyArgumentMarshallerCache;
        synchronized (map) {
            if (!this.keyArgumentMarshallerCache.containsKey(getter)) {
                ArgumentMarshaller marshaller = null;
                Class<?> returnType = getter.getReturnType();
                if (!String.class.isAssignableFrom(returnType)) {
                    throw new DynamoDBMappingException("Unsupported type for " + getter + ": " + returnType + ".  Only Strings are supported when auto-generating keys.");
                }
                marshaller = new ArgumentMarshaller(){

                    public AttributeValue marshall(Object obj) {
                        String newValue = UUID.randomUUID().toString();
                        return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                    }
                };
                this.keyArgumentMarshallerCache.put(getter, marshaller);
            }
            return this.keyArgumentMarshallerCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionAttributeGetter(Method getter) {
        Map<Method, Boolean> map = this.versionAttributeGetterCache;
        synchronized (map) {
            if (!this.versionAttributeGetterCache.containsKey(getter)) {
                this.versionAttributeGetterCache.put(getter, getter.getName().startsWith("get") && getter.getParameterTypes().length == 0 && getter.isAnnotationPresent(DynamoDBVersionAttribute.class));
            }
            return this.versionAttributeGetterCache.get(getter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssignableKey(Method getter) {
        Map<Method, Boolean> map = this.autoGeneratedKeyGetterCache;
        synchronized (map) {
            if (!this.autoGeneratedKeyGetterCache.containsKey(getter)) {
                this.autoGeneratedKeyGetterCache.put(getter, getter.isAnnotationPresent(DynamoDBAutoGeneratedKey.class) && (getter.isAnnotationPresent(DynamoDBHashKey.class) || getter.isAnnotationPresent(DynamoDBRangeKey.class)));
            }
            return this.autoGeneratedKeyGetterCache.get(getter);
        }
    }

    String getPrimaryHashKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getPrimaryHashKeyGetter(clazz));
    }

    String getPrimaryRangeKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getPrimaryRangeKeyGetter(clazz));
    }

    boolean hasPrimaryRangeKey(Class<?> clazz) {
        return this.getPrimaryRangeKeyGetter(clazz) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getLocalSecondaryIndexNamesByIndexKeyName(Class<?> clazz, String indexRangeKeyName) {
        TableIndexInfoCache tableIndexInfoCache = this.indexRangeKeyNameToLocalSecondaryIndexNamesCache;
        synchronized (tableIndexInfoCache) {
            if (!this.indexRangeKeyNameToLocalSecondaryIndexNamesCache.isCached(clazz)) {
                HashMap<String, List<String>> indexRangeKeyNameToLocalSecondaryIndexNamesMap = new HashMap<String, List<String>>();
                for (Method method : this.getRelevantGetters(clazz)) {
                    String attributeName = this.getAttributeName(method);
                    LinkedList<String> indexNames = new LinkedList<String>();
                    if (method.getParameterTypes().length == 0 && method.isAnnotationPresent(DynamoDBIndexRangeKey.class)) {
                        boolean multipleLSINames;
                        DynamoDBIndexRangeKey indexRangeKeyAnnotation = method.getAnnotation(DynamoDBIndexRangeKey.class);
                        String localSecondaryIndexName = indexRangeKeyAnnotation.localSecondaryIndexName();
                        String[] localSecondaryIndexNames = indexRangeKeyAnnotation.localSecondaryIndexNames();
                        boolean singleLSIName = localSecondaryIndexName != null && localSecondaryIndexName.length() != 0;
                        boolean bl = multipleLSINames = localSecondaryIndexNames != null && localSecondaryIndexNames.length != 0;
                        if (singleLSIName && multipleLSINames) {
                            throw new DynamoDBMappingException("@DynamoDBIndexRangeKey annotation on getter " + method + " contains both localSecondaryIndexName and localSecondaryIndexNames.");
                        }
                        if (singleLSIName) {
                            indexNames.add(localSecondaryIndexName);
                        } else if (multipleLSINames) {
                            indexNames.addAll(Arrays.asList(localSecondaryIndexNames));
                        }
                    }
                    if (!indexNames.isEmpty()) {
                        indexRangeKeyNameToLocalSecondaryIndexNamesMap.put(attributeName, indexNames);
                        continue;
                    }
                    indexRangeKeyNameToLocalSecondaryIndexNamesMap.put(attributeName, null);
                }
                this.indexRangeKeyNameToLocalSecondaryIndexNamesCache.cache(clazz, indexRangeKeyNameToLocalSecondaryIndexNamesMap);
            }
            return this.indexRangeKeyNameToLocalSecondaryIndexNamesCache.getIndexNamesByIndexKeyAttributeName(clazz, indexRangeKeyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getGlobalSecondaryIndexNamesByIndexKeyName(Class<?> clazz, String indexKeyName, boolean isIndexHashKey) {
        TableIndexInfoCache indexKeyNameToGlobalSecondaryIndexNamesCache;
        Class annotationInterface = isIndexHashKey ? DynamoDBIndexHashKey.class : DynamoDBIndexRangeKey.class;
        TableIndexInfoCache tableIndexInfoCache = indexKeyNameToGlobalSecondaryIndexNamesCache = isIndexHashKey ? this.indexHashKeyNameToGlobalSecondaryIndexNamesCache : this.indexRangeKeyNameToGlobalSecondaryIndexNamesCache;
        synchronized (tableIndexInfoCache) {
            if (!indexKeyNameToGlobalSecondaryIndexNamesCache.isCached(clazz)) {
                HashMap<String, List<String>> indexKeyNameToGlobalSecondaryIndexNamesMap = new HashMap<String, List<String>>();
                for (Method method : this.getRelevantGetters(clazz)) {
                    String attributeName = this.getAttributeName(method);
                    LinkedList<String> indexNames = new LinkedList<String>();
                    if (method.getParameterTypes().length == 0 && method.isAnnotationPresent(annotationInterface)) {
                        boolean multipleGSINames;
                        String[] globalSecondaryIndexNames;
                        String globalSecondaryIndexName;
                        DynamoDBIndexHashKey indexHashKeyAnnotation = method.getAnnotation(annotationInterface);
                        if (isIndexHashKey) {
                            globalSecondaryIndexName = indexHashKeyAnnotation.globalSecondaryIndexName();
                            globalSecondaryIndexNames = indexHashKeyAnnotation.globalSecondaryIndexNames();
                        } else {
                            globalSecondaryIndexName = ((DynamoDBIndexRangeKey)((Object)indexHashKeyAnnotation)).globalSecondaryIndexName();
                            globalSecondaryIndexNames = ((DynamoDBIndexRangeKey)((Object)indexHashKeyAnnotation)).globalSecondaryIndexNames();
                        }
                        boolean singleGSIName = globalSecondaryIndexName != null && globalSecondaryIndexName.length() != 0;
                        boolean bl = multipleGSINames = globalSecondaryIndexNames != null && globalSecondaryIndexNames.length != 0;
                        if (singleGSIName && multipleGSINames) {
                            throw new DynamoDBMappingException(annotationInterface.getSimpleName() + " annotation on getter " + method + " contains both globalSecondaryIndexName and globalSecondaryIndexNames.");
                        }
                        if (!singleGSIName && !multipleGSINames && isIndexHashKey) {
                            throw new DynamoDBMappingException("@DynamoDBIndexHashKey annotation on getter " + method + " doesn't contain any index name.");
                        }
                        if (singleGSIName) {
                            indexNames.add(globalSecondaryIndexName);
                        } else if (multipleGSINames) {
                            indexNames.addAll(Arrays.asList(globalSecondaryIndexNames));
                        }
                    }
                    if (!indexNames.isEmpty()) {
                        indexKeyNameToGlobalSecondaryIndexNamesMap.put(attributeName, indexNames);
                        continue;
                    }
                    indexKeyNameToGlobalSecondaryIndexNamesMap.put(attributeName, null);
                }
                indexKeyNameToGlobalSecondaryIndexNamesCache.cache(clazz, indexKeyNameToGlobalSecondaryIndexNamesMap);
            }
            return indexKeyNameToGlobalSecondaryIndexNamesCache.getIndexNamesByIndexKeyAttributeName(clazz, indexKeyName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllLocalSecondaryIndexNames(Class<?> clazz) {
        TableIndexInfoCache tableIndexInfoCache = this.indexRangeKeyNameToLocalSecondaryIndexNamesCache;
        synchronized (tableIndexInfoCache) {
            if (!this.indexRangeKeyNameToLocalSecondaryIndexNamesCache.isCached(clazz)) {
                this.getLocalSecondaryIndexNamesByIndexKeyName(clazz, null);
            }
        }
        return this.indexRangeKeyNameToLocalSecondaryIndexNamesCache.getAllIndexNames(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getAllGlobalSecondaryIndexNames(Class<?> clazz) {
        TableIndexInfoCache tableIndexInfoCache = this.indexHashKeyNameToGlobalSecondaryIndexNamesCache;
        synchronized (tableIndexInfoCache) {
            if (!this.indexHashKeyNameToGlobalSecondaryIndexNamesCache.isCached(clazz)) {
                this.getGlobalSecondaryIndexNamesByIndexKeyName(clazz, null, true);
            }
        }
        return this.indexHashKeyNameToGlobalSecondaryIndexNamesCache.getAllIndexNames(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TableIndexInfoCache {
        private Map<Class<?>, Map<String, List<String>>> indexKeyNameToIndexNameCache = new HashMap();
        private Map<Class<?>, Set<String>> allIndexNamesCache = new HashMap();

        private TableIndexInfoCache() {
        }

        public boolean isCached(Class<?> clazz) {
            return this.indexKeyNameToIndexNameCache.containsKey(clazz);
        }

        public List<String> getIndexNamesByIndexKeyAttributeName(Class<?> clazz, String indexKeyName) {
            return this.indexKeyNameToIndexNameCache.get(clazz).get(indexKeyName);
        }

        public Set<String> getAllIndexNames(Class<?> clazz) {
            return this.allIndexNamesCache.get(clazz);
        }

        public void cache(Class<?> clazz, Map<String, List<String>> indexKeyNameToIndexNamesMap) {
            this.indexKeyNameToIndexNameCache.put(clazz, indexKeyNameToIndexNamesMap);
            HashSet<String> allIndexNames = new HashSet<String>();
            for (List<String> indexNames : indexKeyNameToIndexNamesMap.values()) {
                if (indexNames == null) continue;
                allIndexNames.addAll(indexNames);
            }
            this.allIndexNamesCache.put(clazz, allIndexNames);
        }
    }
}

