/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationResult;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.DeleteEnvironmentConfigurationRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationOptionsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentResourcesResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksRequest;
import com.amazonaws.services.elasticbeanstalk.model.ListAvailableSolutionStacksResult;
import com.amazonaws.services.elasticbeanstalk.model.RebuildEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RestartAppServerRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoResult;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateConfigurationTemplateResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CheckDNSAvailabilityResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.CreateStorageLocationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DeleteEnvironmentConfigurationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationVersionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeApplicationsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationOptionsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentResourcesResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEnvironmentsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ListAvailableSolutionStacksResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RebuildEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RequestEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RestartAppServerRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.RetrieveEnvironmentInfoResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.S3SubscriptionRequiredExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SourceBundleDeletionExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.SwapEnvironmentCNAMEsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TerminateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationVersionsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyApplicationsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyBucketsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyConfigurationTemplatesExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.TooManyEnvironmentsExceptionUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateApplicationVersionResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateConfigurationTemplateResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.UpdateEnvironmentResultStaxUnmarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsRequestMarshaller;
import com.amazonaws.services.elasticbeanstalk.model.transform.ValidateConfigurationSettingsResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticBeanstalkClient
extends AmazonWebServiceClient
implements AWSElasticBeanstalk {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AWSElasticBeanstalkClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AWSElasticBeanstalkClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new TooManyEnvironmentsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new S3SubscriptionRequiredExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationVersionsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyApplicationsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SourceBundleDeletionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyConfigurationTemplatesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyBucketsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticbeanstalk.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticbeanstalk/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/elasticbeanstalk/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CheckDNSAvailabilityResult checkDNSAvailability(CheckDNSAvailabilityRequest checkDNSAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(checkDNSAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CheckDNSAvailabilityRequest> request = null;
        Response<CheckDNSAvailabilityResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CheckDNSAvailabilityRequestMarshaller().marshall(checkDNSAvailabilityRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CheckDNSAvailabilityResultStaxUnmarshaller(), executionContext);
            CheckDNSAvailabilityResult checkDNSAvailabilityResult = response.getAwsResponse();
            return checkDNSAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationOptionsResult describeConfigurationOptions(DescribeConfigurationOptionsRequest describeConfigurationOptionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationOptionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeConfigurationOptionsRequest> request = null;
        Response<DescribeConfigurationOptionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeConfigurationOptionsRequestMarshaller().marshall(describeConfigurationOptionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeConfigurationOptionsResultStaxUnmarshaller(), executionContext);
            DescribeConfigurationOptionsResult describeConfigurationOptionsResult = response.getAwsResponse();
            return describeConfigurationOptionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteConfigurationTemplate(DeleteConfigurationTemplateRequest deleteConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteConfigurationTemplateRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteConfigurationTemplateRequestMarshaller().marshall(deleteConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEnvironmentResult createEnvironment(CreateEnvironmentRequest createEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateEnvironmentRequest> request = null;
        Response<CreateEnvironmentResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateEnvironmentRequestMarshaller().marshall(createEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateEnvironmentResultStaxUnmarshaller(), executionContext);
            CreateEnvironmentResult createEnvironmentResult = response.getAwsResponse();
            return createEnvironmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStorageLocationResult createStorageLocation(CreateStorageLocationRequest createStorageLocationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStorageLocationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateStorageLocationRequest> request = null;
        Response<CreateStorageLocationResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateStorageLocationRequestMarshaller().marshall(createStorageLocationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateStorageLocationResultStaxUnmarshaller(), executionContext);
            CreateStorageLocationResult createStorageLocationResult = response.getAwsResponse();
            return createStorageLocationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestEnvironmentInfo(RequestEnvironmentInfoRequest requestEnvironmentInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(requestEnvironmentInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RequestEnvironmentInfoRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RequestEnvironmentInfoRequestMarshaller().marshall(requestEnvironmentInfoRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationVersionResult createApplicationVersion(CreateApplicationVersionRequest createApplicationVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateApplicationVersionRequest> request = null;
        Response<CreateApplicationVersionResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateApplicationVersionRequestMarshaller().marshall(createApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateApplicationVersionResultStaxUnmarshaller(), executionContext);
            CreateApplicationVersionResult createApplicationVersionResult = response.getAwsResponse();
            return createApplicationVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplicationVersion(DeleteApplicationVersionRequest deleteApplicationVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteApplicationVersionRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteApplicationVersionRequestMarshaller().marshall(deleteApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions(DescribeApplicationVersionsRequest describeApplicationVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeApplicationVersionsRequest> request = null;
        Response<DescribeApplicationVersionsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeApplicationVersionsRequestMarshaller().marshall(describeApplicationVersionsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeApplicationVersionsResultStaxUnmarshaller(), executionContext);
            DescribeApplicationVersionsResult describeApplicationVersionsResult = response.getAwsResponse();
            return describeApplicationVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteApplicationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteApplicationRequestMarshaller().marshall(deleteApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationVersionResult updateApplicationVersion(UpdateApplicationVersionRequest updateApplicationVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateApplicationVersionRequest> request = null;
        Response<UpdateApplicationVersionResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateApplicationVersionRequestMarshaller().marshall(updateApplicationVersionRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateApplicationVersionResultStaxUnmarshaller(), executionContext);
            UpdateApplicationVersionResult updateApplicationVersionResult = response.getAwsResponse();
            return updateApplicationVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResult createApplication(CreateApplicationRequest createApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateApplicationRequest> request = null;
        Response<CreateApplicationResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateApplicationRequestMarshaller().marshall(createApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateApplicationResultStaxUnmarshaller(), executionContext);
            CreateApplicationResult createApplicationResult = response.getAwsResponse();
            return createApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapEnvironmentCNAMEs(SwapEnvironmentCNAMEsRequest swapEnvironmentCNAMEsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(swapEnvironmentCNAMEsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SwapEnvironmentCNAMEsRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SwapEnvironmentCNAMEsRequestMarshaller().marshall(swapEnvironmentCNAMEsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfigurationTemplateResult updateConfigurationTemplate(UpdateConfigurationTemplateRequest updateConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateConfigurationTemplateRequest> request = null;
        Response<UpdateConfigurationTemplateResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateConfigurationTemplateRequestMarshaller().marshall(updateConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateConfigurationTemplateResultStaxUnmarshaller(), executionContext);
            UpdateConfigurationTemplateResult updateConfigurationTemplateResult = response.getAwsResponse();
            return updateConfigurationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RetrieveEnvironmentInfoResult retrieveEnvironmentInfo(RetrieveEnvironmentInfoRequest retrieveEnvironmentInfoRequest) {
        ExecutionContext executionContext = this.createExecutionContext(retrieveEnvironmentInfoRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RetrieveEnvironmentInfoRequest> request = null;
        Response<RetrieveEnvironmentInfoResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RetrieveEnvironmentInfoRequestMarshaller().marshall(retrieveEnvironmentInfoRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new RetrieveEnvironmentInfoResultStaxUnmarshaller(), executionContext);
            RetrieveEnvironmentInfoResult retrieveEnvironmentInfoResult = response.getAwsResponse();
            return retrieveEnvironmentInfoResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks(ListAvailableSolutionStacksRequest listAvailableSolutionStacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listAvailableSolutionStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListAvailableSolutionStacksRequest> request = null;
        Response<ListAvailableSolutionStacksResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListAvailableSolutionStacksRequestMarshaller().marshall(listAvailableSolutionStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListAvailableSolutionStacksResultStaxUnmarshaller(), executionContext);
            ListAvailableSolutionStacksResult listAvailableSolutionStacksResult = response.getAwsResponse();
            return listAvailableSolutionStacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResult updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateApplicationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateApplicationRequest> request = null;
        Response<UpdateApplicationResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateApplicationRequestMarshaller().marshall(updateApplicationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateApplicationResultStaxUnmarshaller(), executionContext);
            UpdateApplicationResult updateApplicationResult = response.getAwsResponse();
            return updateApplicationResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEnvironmentsResult describeEnvironments(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEnvironmentsRequest> request = null;
        Response<DescribeEnvironmentsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEnvironmentsRequestMarshaller().marshall(describeEnvironmentsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeEnvironmentsResultStaxUnmarshaller(), executionContext);
            DescribeEnvironmentsResult describeEnvironmentsResult = response.getAwsResponse();
            return describeEnvironmentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEnvironmentResourcesResult describeEnvironmentResources(DescribeEnvironmentResourcesRequest describeEnvironmentResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEnvironmentResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEnvironmentResourcesRequest> request = null;
        Response<DescribeEnvironmentResourcesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEnvironmentResourcesRequestMarshaller().marshall(describeEnvironmentResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeEnvironmentResourcesResultStaxUnmarshaller(), executionContext);
            DescribeEnvironmentResourcesResult describeEnvironmentResourcesResult = response.getAwsResponse();
            return describeEnvironmentResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TerminateEnvironmentResult terminateEnvironment(TerminateEnvironmentRequest terminateEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(terminateEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<TerminateEnvironmentRequest> request = null;
        Response<TerminateEnvironmentResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new TerminateEnvironmentRequestMarshaller().marshall(terminateEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new TerminateEnvironmentResultStaxUnmarshaller(), executionContext);
            TerminateEnvironmentResult terminateEnvironmentResult = response.getAwsResponse();
            return terminateEnvironmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateConfigurationSettingsResult validateConfigurationSettings(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(validateConfigurationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ValidateConfigurationSettingsRequest> request = null;
        Response<ValidateConfigurationSettingsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ValidateConfigurationSettingsRequestMarshaller().marshall(validateConfigurationSettingsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ValidateConfigurationSettingsResultStaxUnmarshaller(), executionContext);
            ValidateConfigurationSettingsResult validateConfigurationSettingsResult = response.getAwsResponse();
            return validateConfigurationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartAppServer(RestartAppServerRequest restartAppServerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(restartAppServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RestartAppServerRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RestartAppServerRequestMarshaller().marshall(restartAppServerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEnvironmentConfiguration(DeleteEnvironmentConfigurationRequest deleteEnvironmentConfigurationRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEnvironmentConfigurationRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteEnvironmentConfigurationRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteEnvironmentConfigurationRequestMarshaller().marshall(deleteEnvironmentConfigurationRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateEnvironmentResult updateEnvironment(UpdateEnvironmentRequest updateEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateEnvironmentRequest> request = null;
        Response<UpdateEnvironmentResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateEnvironmentRequestMarshaller().marshall(updateEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateEnvironmentResultStaxUnmarshaller(), executionContext);
            UpdateEnvironmentResult updateEnvironmentResult = response.getAwsResponse();
            return updateEnvironmentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfigurationTemplateResult createConfigurationTemplate(CreateConfigurationTemplateRequest createConfigurationTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createConfigurationTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateConfigurationTemplateRequest> request = null;
        Response<CreateConfigurationTemplateResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateConfigurationTemplateRequestMarshaller().marshall(createConfigurationTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateConfigurationTemplateResultStaxUnmarshaller(), executionContext);
            CreateConfigurationTemplateResult createConfigurationTemplateResult = response.getAwsResponse();
            return createConfigurationTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeConfigurationSettingsResult describeConfigurationSettings(DescribeConfigurationSettingsRequest describeConfigurationSettingsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeConfigurationSettingsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeConfigurationSettingsRequest> request = null;
        Response<DescribeConfigurationSettingsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeConfigurationSettingsRequestMarshaller().marshall(describeConfigurationSettingsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeConfigurationSettingsResultStaxUnmarshaller(), executionContext);
            DescribeConfigurationSettingsResult describeConfigurationSettingsResult = response.getAwsResponse();
            return describeConfigurationSettingsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationsResult describeApplications(DescribeApplicationsRequest describeApplicationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeApplicationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeApplicationsRequest> request = null;
        Response<DescribeApplicationsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeApplicationsRequestMarshaller().marshall(describeApplicationsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeApplicationsResultStaxUnmarshaller(), executionContext);
            DescribeApplicationsResult describeApplicationsResult = response.getAwsResponse();
            return describeApplicationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildEnvironment(RebuildEnvironmentRequest rebuildEnvironmentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(rebuildEnvironmentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RebuildEnvironmentRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RebuildEnvironmentRequestMarshaller().marshall(rebuildEnvironmentRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeEventsRequest> request = null;
        Response<DescribeEventsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeEventsResultStaxUnmarshaller(), executionContext);
            DescribeEventsResult describeEventsResult = response.getAwsResponse();
            return describeEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateStorageLocationResult createStorageLocation() throws AmazonServiceException, AmazonClientException {
        return this.createStorageLocation(new CreateStorageLocationRequest());
    }

    @Override
    public DescribeApplicationVersionsResult describeApplicationVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeApplicationVersions(new DescribeApplicationVersionsRequest());
    }

    @Override
    public void swapEnvironmentCNAMEs() throws AmazonServiceException, AmazonClientException {
        this.swapEnvironmentCNAMEs(new SwapEnvironmentCNAMEsRequest());
    }

    @Override
    public ListAvailableSolutionStacksResult listAvailableSolutionStacks() throws AmazonServiceException, AmazonClientException {
        return this.listAvailableSolutionStacks(new ListAvailableSolutionStacksRequest());
    }

    @Override
    public DescribeEnvironmentsResult describeEnvironments() throws AmazonServiceException, AmazonClientException {
        return this.describeEnvironments(new DescribeEnvironmentsRequest());
    }

    @Override
    public DescribeApplicationsResult describeApplications() throws AmazonServiceException, AmazonClientException {
        return this.describeApplications(new DescribeApplicationsRequest());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.getSigner());
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

