/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datapipeline;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.datapipeline.DataPipeline;
import com.amazonaws.services.datapipeline.model.ActivatePipelineRequest;
import com.amazonaws.services.datapipeline.model.ActivatePipelineResult;
import com.amazonaws.services.datapipeline.model.CreatePipelineRequest;
import com.amazonaws.services.datapipeline.model.CreatePipelineResult;
import com.amazonaws.services.datapipeline.model.DeletePipelineRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsRequest;
import com.amazonaws.services.datapipeline.model.DescribeObjectsResult;
import com.amazonaws.services.datapipeline.model.DescribePipelinesRequest;
import com.amazonaws.services.datapipeline.model.DescribePipelinesResult;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionRequest;
import com.amazonaws.services.datapipeline.model.EvaluateExpressionResult;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.GetPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.ListPipelinesRequest;
import com.amazonaws.services.datapipeline.model.ListPipelinesResult;
import com.amazonaws.services.datapipeline.model.PollForTaskRequest;
import com.amazonaws.services.datapipeline.model.PollForTaskResult;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.PutPipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.QueryObjectsRequest;
import com.amazonaws.services.datapipeline.model.QueryObjectsResult;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskProgressResult;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatRequest;
import com.amazonaws.services.datapipeline.model.ReportTaskRunnerHeartbeatResult;
import com.amazonaws.services.datapipeline.model.SetStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusRequest;
import com.amazonaws.services.datapipeline.model.SetTaskStatusResult;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionRequest;
import com.amazonaws.services.datapipeline.model.ValidatePipelineDefinitionResult;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ActivatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribeObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.DescribePipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.EvaluateExpressionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.GetPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.InternalServiceErrorExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.InvalidRequestExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineDeletedExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PipelineNotFoundExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PollForTaskResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.PutPipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.QueryObjectsResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskProgressResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ReportTaskRunnerHeartbeatResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetStatusRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.SetTaskStatusResultJsonUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.TaskNotFoundExceptionUnmarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionRequestMarshaller;
import com.amazonaws.services.datapipeline.model.transform.ValidatePipelineDefinitionResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPipelineClient
extends AmazonWebServiceClient
implements DataPipeline {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(DataPipeline.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;

    public DataPipelineClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public DataPipelineClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public DataPipelineClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public DataPipelineClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public DataPipelineClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new PipelineNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceErrorExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TaskNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PipelineDeletedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("datapipeline.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/datapipeline/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/datapipeline/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivatePipelineResult activatePipeline(ActivatePipelineRequest activatePipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivatePipelineRequestMarshaller().marshall(activatePipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ActivatePipelineResultJsonUnmarshaller unmarshaller = new ActivatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<ActivatePipelineResult> responseHandler = new JsonResponseHandler<ActivatePipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ActivatePipelineResult activatePipelineResult = (ActivatePipelineResult)response.getAwsResponse();
            return activatePipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPipelinesResultJsonUnmarshaller unmarshaller = new ListPipelinesResultJsonUnmarshaller();
            JsonResponseHandler<ListPipelinesResult> responseHandler = new JsonResponseHandler<ListPipelinesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ListPipelinesResult listPipelinesResult = (ListPipelinesResult)response.getAwsResponse();
            return listPipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskProgressResult reportTaskProgress(ReportTaskProgressRequest reportTaskProgressRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reportTaskProgressRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReportTaskProgressRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReportTaskProgressRequestMarshaller().marshall(reportTaskProgressRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReportTaskProgressResultJsonUnmarshaller unmarshaller = new ReportTaskProgressResultJsonUnmarshaller();
            JsonResponseHandler<ReportTaskProgressResult> responseHandler = new JsonResponseHandler<ReportTaskProgressResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReportTaskProgressResult reportTaskProgressResult = (ReportTaskProgressResult)response.getAwsResponse();
            return reportTaskProgressResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatePipelineDefinitionResult validatePipelineDefinition(ValidatePipelineDefinitionRequest validatePipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(validatePipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ValidatePipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ValidatePipelineDefinitionRequestMarshaller().marshall(validatePipelineDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ValidatePipelineDefinitionResultJsonUnmarshaller unmarshaller = new ValidatePipelineDefinitionResultJsonUnmarshaller();
            JsonResponseHandler<ValidatePipelineDefinitionResult> responseHandler = new JsonResponseHandler<ValidatePipelineDefinitionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ValidatePipelineDefinitionResult validatePipelineDefinitionResult = (ValidatePipelineDefinitionResult)response.getAwsResponse();
            return validatePipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollForTaskResult pollForTask(PollForTaskRequest pollForTaskRequest) {
        ExecutionContext executionContext = this.createExecutionContext(pollForTaskRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PollForTaskRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PollForTaskRequestMarshaller().marshall(pollForTaskRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PollForTaskResultJsonUnmarshaller unmarshaller = new PollForTaskResultJsonUnmarshaller();
            JsonResponseHandler<PollForTaskResult> responseHandler = new JsonResponseHandler<PollForTaskResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            PollForTaskResult pollForTaskResult = (PollForTaskResult)response.getAwsResponse();
            return pollForTaskResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryObjectsResult queryObjects(QueryObjectsRequest queryObjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(queryObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<QueryObjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new QueryObjectsRequestMarshaller().marshall(queryObjectsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            QueryObjectsResultJsonUnmarshaller unmarshaller = new QueryObjectsResultJsonUnmarshaller();
            JsonResponseHandler<QueryObjectsResult> responseHandler = new JsonResponseHandler<QueryObjectsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            QueryObjectsResult queryObjectsResult = (QueryObjectsResult)response.getAwsResponse();
            return queryObjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStatus(SetStatusRequest setStatusRequest) {
        Request<SetStatusRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(setStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new SetStatusRequestMarshaller().marshall(setStatusRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        Request<DeletePipelineRequest> request;
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        try {
            request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
        }
        JsonResponseHandler responseHandler = new JsonResponseHandler(null);
        this.invoke(request, responseHandler, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPipelineDefinitionResult getPipelineDefinition(GetPipelineDefinitionRequest getPipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetPipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetPipelineDefinitionRequestMarshaller().marshall(getPipelineDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetPipelineDefinitionResultJsonUnmarshaller unmarshaller = new GetPipelineDefinitionResultJsonUnmarshaller();
            JsonResponseHandler<GetPipelineDefinitionResult> responseHandler = new JsonResponseHandler<GetPipelineDefinitionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            GetPipelineDefinitionResult getPipelineDefinitionResult = (GetPipelineDefinitionResult)response.getAwsResponse();
            return getPipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetTaskStatusResult setTaskStatus(SetTaskStatusRequest setTaskStatusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setTaskStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetTaskStatusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetTaskStatusRequestMarshaller().marshall(setTaskStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            SetTaskStatusResultJsonUnmarshaller unmarshaller = new SetTaskStatusResultJsonUnmarshaller();
            JsonResponseHandler<SetTaskStatusResult> responseHandler = new JsonResponseHandler<SetTaskStatusResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            SetTaskStatusResult setTaskStatusResult = (SetTaskStatusResult)response.getAwsResponse();
            return setTaskStatusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EvaluateExpressionResult evaluateExpression(EvaluateExpressionRequest evaluateExpressionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(evaluateExpressionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EvaluateExpressionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EvaluateExpressionRequestMarshaller().marshall(evaluateExpressionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            EvaluateExpressionResultJsonUnmarshaller unmarshaller = new EvaluateExpressionResultJsonUnmarshaller();
            JsonResponseHandler<EvaluateExpressionResult> responseHandler = new JsonResponseHandler<EvaluateExpressionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            EvaluateExpressionResult evaluateExpressionResult = (EvaluateExpressionResult)response.getAwsResponse();
            return evaluateExpressionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePipelinesResult describePipelines(DescribePipelinesRequest describePipelinesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePipelinesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePipelinesRequestMarshaller().marshall(describePipelinesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribePipelinesResultJsonUnmarshaller unmarshaller = new DescribePipelinesResultJsonUnmarshaller();
            JsonResponseHandler<DescribePipelinesResult> responseHandler = new JsonResponseHandler<DescribePipelinesResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribePipelinesResult describePipelinesResult = (DescribePipelinesResult)response.getAwsResponse();
            return describePipelinesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePipelineResultJsonUnmarshaller unmarshaller = new CreatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<CreatePipelineResult> responseHandler = new JsonResponseHandler<CreatePipelineResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            CreatePipelineResult createPipelineResult = (CreatePipelineResult)response.getAwsResponse();
            return createPipelineResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeObjectsResult describeObjects(DescribeObjectsRequest describeObjectsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeObjectsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeObjectsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeObjectsRequestMarshaller().marshall(describeObjectsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeObjectsResultJsonUnmarshaller unmarshaller = new DescribeObjectsResultJsonUnmarshaller();
            JsonResponseHandler<DescribeObjectsResult> responseHandler = new JsonResponseHandler<DescribeObjectsResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            DescribeObjectsResult describeObjectsResult = (DescribeObjectsResult)response.getAwsResponse();
            return describeObjectsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportTaskRunnerHeartbeatResult reportTaskRunnerHeartbeat(ReportTaskRunnerHeartbeatRequest reportTaskRunnerHeartbeatRequest) {
        ExecutionContext executionContext = this.createExecutionContext(reportTaskRunnerHeartbeatRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReportTaskRunnerHeartbeatRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReportTaskRunnerHeartbeatRequestMarshaller().marshall(reportTaskRunnerHeartbeatRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReportTaskRunnerHeartbeatResultJsonUnmarshaller unmarshaller = new ReportTaskRunnerHeartbeatResultJsonUnmarshaller();
            JsonResponseHandler<ReportTaskRunnerHeartbeatResult> responseHandler = new JsonResponseHandler<ReportTaskRunnerHeartbeatResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            ReportTaskRunnerHeartbeatResult reportTaskRunnerHeartbeatResult = (ReportTaskRunnerHeartbeatResult)response.getAwsResponse();
            return reportTaskRunnerHeartbeatResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPipelineDefinitionResult putPipelineDefinition(PutPipelineDefinitionRequest putPipelineDefinitionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPipelineDefinitionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPipelineDefinitionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPipelineDefinitionRequestMarshaller().marshall(putPipelineDefinitionRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            PutPipelineDefinitionResultJsonUnmarshaller unmarshaller = new PutPipelineDefinitionResultJsonUnmarshaller();
            JsonResponseHandler<PutPipelineDefinitionResult> responseHandler = new JsonResponseHandler<PutPipelineDefinitionResult>(unmarshaller);
            response = this.invoke(request, responseHandler, executionContext);
            PutPipelineDefinitionResult putPipelineDefinitionResult = (PutPipelineDefinitionResult)response.getAwsResponse();
            return putPipelineDefinitionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPipelinesResult listPipelines() throws AmazonServiceException, AmazonClientException {
        return this.listPipelines(new ListPipelinesRequest());
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    @Override
    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.getSigner());
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Response result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return result;
    }
}

