/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.GetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.GetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import com.amazonaws.services.cloudformation.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.CancelUpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DeleteStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetStackPolicyRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetStackPolicyResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.InsufficientCapabilitiesExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.SetStackPolicyRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFormationClient
extends AmazonWebServiceClient
implements AmazonCloudFormation {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();

    public AmazonCloudFormationClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudFormationClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientCapabilitiesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudformation.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudformation/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/cloudformation/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateTemplateResult validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(validateTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ValidateTemplateRequest> request = null;
        Response<ValidateTemplateResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ValidateTemplateRequestMarshaller().marshall(validateTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ValidateTemplateResultStaxUnmarshaller(), executionContext);
            ValidateTemplateResult validateTemplateResult = response.getAwsResponse();
            return validateTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStacksResult describeStacks(DescribeStacksRequest describeStacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStacksRequest> request = null;
        Response<DescribeStacksResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStacksRequestMarshaller().marshall(describeStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeStacksResultStaxUnmarshaller(), executionContext);
            DescribeStacksResult describeStacksResult = response.getAwsResponse();
            return describeStacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest getTemplateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetTemplateRequest> request = null;
        Response<GetTemplateResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetTemplateRequestMarshaller().marshall(getTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetTemplateResultStaxUnmarshaller(), executionContext);
            GetTemplateResult getTemplateResult = response.getAwsResponse();
            return getTemplateResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStackPolicyResult getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getStackPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetStackPolicyRequest> request = null;
        Response<GetStackPolicyResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetStackPolicyRequestMarshaller().marshall(getStackPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new GetStackPolicyResultStaxUnmarshaller(), executionContext);
            GetStackPolicyResult getStackPolicyResult = response.getAwsResponse();
            return getStackPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStacksResult listStacks(ListStacksRequest listStacksRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListStacksRequest> request = null;
        Response<ListStacksResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListStacksRequestMarshaller().marshall(listStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListStacksResultStaxUnmarshaller(), executionContext);
            ListStacksResult listStacksResult = response.getAwsResponse();
            return listStacksResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStackResult createStack(CreateStackRequest createStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateStackRequest> request = null;
        Response<CreateStackResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateStackRequestMarshaller().marshall(createStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new CreateStackResultStaxUnmarshaller(), executionContext);
            CreateStackResult createStackResult = response.getAwsResponse();
            return createStackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setStackPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetStackPolicyRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetStackPolicyRequestMarshaller().marshall(setStackPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EstimateTemplateCostResult estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) {
        ExecutionContext executionContext = this.createExecutionContext(estimateTemplateCostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<EstimateTemplateCostRequest> request = null;
        Response<EstimateTemplateCostResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new EstimateTemplateCostRequestMarshaller().marshall(estimateTemplateCostRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new EstimateTemplateCostResultStaxUnmarshaller(), executionContext);
            EstimateTemplateCostResult estimateTemplateCostResult = response.getAwsResponse();
            return estimateTemplateCostResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackEventsResult describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStackEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackEventsRequest> request = null;
        Response<DescribeStackEventsResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackEventsRequestMarshaller().marshall(describeStackEventsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeStackEventsResultStaxUnmarshaller(), executionContext);
            DescribeStackEventsResult describeStackEventsResult = response.getAwsResponse();
            return describeStackEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackResourceResult describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStackResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackResourceRequest> request = null;
        Response<DescribeStackResourceResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackResourceRequestMarshaller().marshall(describeStackResourceRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeStackResourceResultStaxUnmarshaller(), executionContext);
            DescribeStackResourceResult describeStackResourceResult = response.getAwsResponse();
            return describeStackResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelUpdateStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CancelUpdateStackRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CancelUpdateStackRequestMarshaller().marshall(cancelUpdateStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStackResult updateStack(UpdateStackRequest updateStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateStackRequest> request = null;
        Response<UpdateStackResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateStackRequestMarshaller().marshall(updateStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new UpdateStackResultStaxUnmarshaller(), executionContext);
            UpdateStackResult updateStackResult = response.getAwsResponse();
            return updateStackResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackResourcesResult describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeStackResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackResourcesRequest> request = null;
        Response<DescribeStackResourcesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackResourcesRequestMarshaller().marshall(describeStackResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new DescribeStackResourcesResultStaxUnmarshaller(), executionContext);
            DescribeStackResourcesResult describeStackResourcesResult = response.getAwsResponse();
            return describeStackResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStack(DeleteStackRequest deleteStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteStackRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteStackRequestMarshaller().marshall(deleteStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStackResourcesResult listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listStackResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListStackResourcesRequest> request = null;
        Response<ListStackResourcesResult> response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListStackResourcesRequestMarshaller().marshall(listStackResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            response = this.invoke(request, new ListStackResourcesResultStaxUnmarshaller(), executionContext);
            ListStackResourcesResult listStackResourcesResult = response.getAwsResponse();
            return listStackResourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeStacksResult describeStacks() throws AmazonServiceException, AmazonClientException {
        return this.describeStacks(new DescribeStacksRequest());
    }

    @Override
    public ListStacksResult listStacks() throws AmazonServiceException, AmazonClientException {
        return this.listStacks(new ListStacksRequest());
    }

    @Override
    public EstimateTemplateCostResult estimateTemplateCost() throws AmazonServiceException, AmazonClientException {
        return this.estimateTemplateCost(new EstimateTemplateCostRequest());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeStackEvents(new DescribeStackEventsRequest());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources() throws AmazonServiceException, AmazonClientException {
        return this.describeStackResources(new DescribeStackResourcesRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.getSigner());
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

