/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.route53.AmazonRoute53;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ChangeResourceRecordSetsResult;
import com.amazonaws.services.route53.model.CreateHealthCheckRequest;
import com.amazonaws.services.route53.model.CreateHealthCheckResult;
import com.amazonaws.services.route53.model.CreateHostedZoneRequest;
import com.amazonaws.services.route53.model.CreateHostedZoneResult;
import com.amazonaws.services.route53.model.DeleteHealthCheckRequest;
import com.amazonaws.services.route53.model.DeleteHealthCheckResult;
import com.amazonaws.services.route53.model.DeleteHostedZoneRequest;
import com.amazonaws.services.route53.model.DeleteHostedZoneResult;
import com.amazonaws.services.route53.model.GetChangeRequest;
import com.amazonaws.services.route53.model.GetChangeResult;
import com.amazonaws.services.route53.model.GetHealthCheckRequest;
import com.amazonaws.services.route53.model.GetHealthCheckResult;
import com.amazonaws.services.route53.model.GetHostedZoneRequest;
import com.amazonaws.services.route53.model.GetHostedZoneResult;
import com.amazonaws.services.route53.model.ListHealthChecksRequest;
import com.amazonaws.services.route53.model.ListHealthChecksResult;
import com.amazonaws.services.route53.model.ListHostedZonesRequest;
import com.amazonaws.services.route53.model.ListHostedZonesResult;
import com.amazonaws.services.route53.model.ListResourceRecordSetsRequest;
import com.amazonaws.services.route53.model.ListResourceRecordSetsResult;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ChangeResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.CreateHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DelegationSetNotAvailableExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.DeleteHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetChangeResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneRequestMarshaller;
import com.amazonaws.services.route53.model.transform.GetHostedZoneResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HealthCheckInUseExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.HostedZoneNotEmptyExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidChangeBatchExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidDomainNameExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.InvalidInputExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHealthChecksResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListHostedZonesResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsRequestMarshaller;
import com.amazonaws.services.route53.model.transform.ListResourceRecordSetsResultStaxUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchChangeExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHealthCheckExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.NoSuchHostedZoneExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.PriorRequestNotCompleteExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHealthChecksExceptionUnmarshaller;
import com.amazonaws.services.route53.model.transform.TooManyHostedZonesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRoute53Client
extends AmazonWebServiceClient
implements AmazonRoute53 {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS3Signer signer;

    public AmazonRoute53Client() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonRoute53Client(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonRoute53Client(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new InvalidDomainNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidChangeBatchExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHealthChecksExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyHostedZonesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HostedZoneNotEmptyExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DelegationSetNotAvailableExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchChangeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInputExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new HealthCheckAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHostedZoneExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new NoSuchHealthCheckExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PriorRequestNotCompleteExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("route53.amazonaws.com");
        this.signer = new AWS3Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/route53/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListResourceRecordSetsResult listResourceRecordSets(ListResourceRecordSetsRequest listResourceRecordSetsRequest) {
        ListResourceRecordSetsResult listResourceRecordSetsResult;
        ExecutionContext executionContext = this.createExecutionContext(listResourceRecordSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListResourceRecordSetsRequest> request = null;
        ListResourceRecordSetsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListResourceRecordSetsRequestMarshaller().marshall(listResourceRecordSetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listResourceRecordSetsResult = response = this.invoke(request, new ListResourceRecordSetsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listResourceRecordSetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ChangeResourceRecordSetsResult changeResourceRecordSets(ChangeResourceRecordSetsRequest changeResourceRecordSetsRequest) {
        ChangeResourceRecordSetsResult changeResourceRecordSetsResult;
        ExecutionContext executionContext = this.createExecutionContext(changeResourceRecordSetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ChangeResourceRecordSetsRequest> request = null;
        ChangeResourceRecordSetsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ChangeResourceRecordSetsRequestMarshaller().marshall(changeResourceRecordSetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            changeResourceRecordSetsResult = response = this.invoke(request, new ChangeResourceRecordSetsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return changeResourceRecordSetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHostedZoneResult createHostedZone(CreateHostedZoneRequest createHostedZoneRequest) {
        CreateHostedZoneResult createHostedZoneResult;
        ExecutionContext executionContext = this.createExecutionContext(createHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateHostedZoneRequest> request = null;
        CreateHostedZoneResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateHostedZoneRequestMarshaller().marshall(createHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createHostedZoneResult = response = this.invoke(request, new CreateHostedZoneResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createHostedZoneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHealthCheckResult getHealthCheck(GetHealthCheckRequest getHealthCheckRequest) {
        GetHealthCheckResult getHealthCheckResult;
        ExecutionContext executionContext = this.createExecutionContext(getHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetHealthCheckRequest> request = null;
        GetHealthCheckResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetHealthCheckRequestMarshaller().marshall(getHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getHealthCheckResult = response = this.invoke(request, new GetHealthCheckResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getHealthCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateHealthCheckResult createHealthCheck(CreateHealthCheckRequest createHealthCheckRequest) {
        CreateHealthCheckResult createHealthCheckResult;
        ExecutionContext executionContext = this.createExecutionContext(createHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateHealthCheckRequest> request = null;
        CreateHealthCheckResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateHealthCheckRequestMarshaller().marshall(createHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createHealthCheckResult = response = this.invoke(request, new CreateHealthCheckResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createHealthCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChangeResult getChange(GetChangeRequest getChangeRequest) {
        GetChangeResult getChangeResult;
        ExecutionContext executionContext = this.createExecutionContext(getChangeRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetChangeRequest> request = null;
        GetChangeResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetChangeRequestMarshaller().marshall(getChangeRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getChangeResult = response = this.invoke(request, new GetChangeResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getChangeResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHealthCheckResult deleteHealthCheck(DeleteHealthCheckRequest deleteHealthCheckRequest) {
        DeleteHealthCheckResult deleteHealthCheckResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteHealthCheckRequest> request = null;
        DeleteHealthCheckResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteHealthCheckRequestMarshaller().marshall(deleteHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteHealthCheckResult = response = this.invoke(request, new DeleteHealthCheckResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteHealthCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHostedZoneResult getHostedZone(GetHostedZoneRequest getHostedZoneRequest) {
        GetHostedZoneResult getHostedZoneResult;
        ExecutionContext executionContext = this.createExecutionContext(getHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetHostedZoneRequest> request = null;
        GetHostedZoneResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetHostedZoneRequestMarshaller().marshall(getHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getHostedZoneResult = response = this.invoke(request, new GetHostedZoneResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getHostedZoneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHostedZonesResult listHostedZones(ListHostedZonesRequest listHostedZonesRequest) {
        ListHostedZonesResult listHostedZonesResult;
        ExecutionContext executionContext = this.createExecutionContext(listHostedZonesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListHostedZonesRequest> request = null;
        ListHostedZonesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListHostedZonesRequestMarshaller().marshall(listHostedZonesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listHostedZonesResult = response = this.invoke(request, new ListHostedZonesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listHostedZonesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHostedZoneResult deleteHostedZone(DeleteHostedZoneRequest deleteHostedZoneRequest) {
        DeleteHostedZoneResult deleteHostedZoneResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteHostedZoneRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteHostedZoneRequest> request = null;
        DeleteHostedZoneResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteHostedZoneRequestMarshaller().marshall(deleteHostedZoneRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteHostedZoneResult = response = this.invoke(request, new DeleteHostedZoneResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteHostedZoneResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHealthChecksResult listHealthChecks(ListHealthChecksRequest listHealthChecksRequest) {
        ListHealthChecksResult listHealthChecksResult;
        ExecutionContext executionContext = this.createExecutionContext(listHealthChecksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListHealthChecksRequest> request = null;
        ListHealthChecksResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListHealthChecksRequestMarshaller().marshall(listHealthChecksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listHealthChecksResult = response = this.invoke(request, new ListHealthChecksResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listHealthChecksResult;
    }

    @Override
    public ListHostedZonesResult listHostedZones() throws AmazonServiceException, AmazonClientException {
        return this.listHostedZones(new ListHostedZonesRequest());
    }

    @Override
    public ListHealthChecksResult listHealthChecks() throws AmazonServiceException, AmazonClientException {
        return this.listHealthChecks(new ListHealthChecksRequest());
    }

    @Override
    protected String getServiceAbbreviation() {
        return "route53";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

