/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elastictranscoder.AmazonElasticTranscoder;
import com.amazonaws.services.elastictranscoder.model.CancelJobRequest;
import com.amazonaws.services.elastictranscoder.model.CancelJobResult;
import com.amazonaws.services.elastictranscoder.model.CreateJobRequest;
import com.amazonaws.services.elastictranscoder.model.CreateJobResult;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.CreatePresetRequest;
import com.amazonaws.services.elastictranscoder.model.CreatePresetResult;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePipelineResult;
import com.amazonaws.services.elastictranscoder.model.DeletePresetRequest;
import com.amazonaws.services.elastictranscoder.model.DeletePresetResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusRequest;
import com.amazonaws.services.elastictranscoder.model.ListJobsByStatusResult;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesRequest;
import com.amazonaws.services.elastictranscoder.model.ListPipelinesResult;
import com.amazonaws.services.elastictranscoder.model.ListPresetsRequest;
import com.amazonaws.services.elastictranscoder.model.ListPresetsResult;
import com.amazonaws.services.elastictranscoder.model.ReadJobRequest;
import com.amazonaws.services.elastictranscoder.model.ReadJobResult;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPipelineResult;
import com.amazonaws.services.elastictranscoder.model.ReadPresetRequest;
import com.amazonaws.services.elastictranscoder.model.ReadPresetResult;
import com.amazonaws.services.elastictranscoder.model.TestRoleRequest;
import com.amazonaws.services.elastictranscoder.model.TestRoleResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineNotificationsResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineResult;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusRequest;
import com.amazonaws.services.elastictranscoder.model.UpdatePipelineStatusResult;
import com.amazonaws.services.elastictranscoder.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CancelJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreateJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.CreatePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.DeletePresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.IncompatibleVersionExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.InternalServiceExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListJobsByStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPipelinesResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ListPresetsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadJobResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ReadPresetResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceInUseExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.TestRoleResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusRequestMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.UpdatePipelineStatusResultJsonUnmarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticTranscoderClient
extends AmazonWebServiceClient
implements AmazonElasticTranscoder {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonElasticTranscoder.class);
    protected List<Unmarshaller<AmazonServiceException, JSONObject>> exceptionUnmarshallers;
    private AWS4Signer signer;

    public AmazonElasticTranscoderClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticTranscoderClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, JSONObject>>();
        this.exceptionUnmarshallers.add(new ResourceInUseExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InternalServiceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ValidationExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new IncompatibleVersionExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AccessDeniedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new JsonErrorUnmarshaller());
        this.setEndpoint("elastictranscoder.us-east-1.amazonaws.com/");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("elastictranscoder");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elastictranscoder/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineStatusResult updatePipelineStatus(UpdatePipelineStatusRequest updatePipelineStatusRequest) {
        UpdatePipelineStatusResult updatePipelineStatusResult;
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineStatusRequest> request = null;
        UpdatePipelineStatusResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineStatusRequestMarshaller().marshall(updatePipelineStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineStatusResultJsonUnmarshaller unmarshaller = new UpdatePipelineStatusResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineStatusResult> responseHandler = new JsonResponseHandler<UpdatePipelineStatusResult>(unmarshaller);
            updatePipelineStatusResult = response = (UpdatePipelineStatusResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updatePipelineStatusResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineNotificationsResult updatePipelineNotifications(UpdatePipelineNotificationsRequest updatePipelineNotificationsRequest) {
        UpdatePipelineNotificationsResult updatePipelineNotificationsResult;
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineNotificationsRequest> request = null;
        UpdatePipelineNotificationsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineNotificationsRequestMarshaller().marshall(updatePipelineNotificationsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineNotificationsResultJsonUnmarshaller unmarshaller = new UpdatePipelineNotificationsResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineNotificationsResult> responseHandler = new JsonResponseHandler<UpdatePipelineNotificationsResult>(unmarshaller);
            updatePipelineNotificationsResult = response = (UpdatePipelineNotificationsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updatePipelineNotificationsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadJobResult readJob(ReadJobRequest readJobRequest) {
        ReadJobResult readJobResult;
        ExecutionContext executionContext = this.createExecutionContext(readJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadJobRequest> request = null;
        ReadJobResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadJobRequestMarshaller().marshall(readJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadJobResultJsonUnmarshaller unmarshaller = new ReadJobResultJsonUnmarshaller();
            JsonResponseHandler<ReadJobResult> responseHandler = new JsonResponseHandler<ReadJobResult>(unmarshaller);
            readJobResult = response = (ReadJobResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return readJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsByStatusResult listJobsByStatus(ListJobsByStatusRequest listJobsByStatusRequest) {
        ListJobsByStatusResult listJobsByStatusResult;
        ExecutionContext executionContext = this.createExecutionContext(listJobsByStatusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByStatusRequest> request = null;
        ListJobsByStatusResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByStatusRequestMarshaller().marshall(listJobsByStatusRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsByStatusResultJsonUnmarshaller unmarshaller = new ListJobsByStatusResultJsonUnmarshaller();
            JsonResponseHandler<ListJobsByStatusResult> responseHandler = new JsonResponseHandler<ListJobsByStatusResult>(unmarshaller);
            listJobsByStatusResult = response = (ListJobsByStatusResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listJobsByStatusResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadPresetResult readPreset(ReadPresetRequest readPresetRequest) {
        ReadPresetResult readPresetResult;
        ExecutionContext executionContext = this.createExecutionContext(readPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPresetRequest> request = null;
        ReadPresetResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPresetRequestMarshaller().marshall(readPresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadPresetResultJsonUnmarshaller unmarshaller = new ReadPresetResultJsonUnmarshaller();
            JsonResponseHandler<ReadPresetResult> responseHandler = new JsonResponseHandler<ReadPresetResult>(unmarshaller);
            readPresetResult = response = (ReadPresetResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return readPresetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePipelineResult createPipeline(CreatePipelineRequest createPipelineRequest) {
        CreatePipelineResult createPipelineResult;
        ExecutionContext executionContext = this.createExecutionContext(createPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePipelineRequest> request = null;
        CreatePipelineResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePipelineRequestMarshaller().marshall(createPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePipelineResultJsonUnmarshaller unmarshaller = new CreatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<CreatePipelineResult> responseHandler = new JsonResponseHandler<CreatePipelineResult>(unmarshaller);
            createPipelineResult = response = (CreatePipelineResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createPipelineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelJobResult cancelJob(CancelJobRequest cancelJobRequest) {
        CancelJobResult cancelJobResult;
        ExecutionContext executionContext = this.createExecutionContext(cancelJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelJobRequest> request = null;
        CancelJobResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelJobRequestMarshaller().marshall(cancelJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CancelJobResultJsonUnmarshaller unmarshaller = new CancelJobResultJsonUnmarshaller();
            JsonResponseHandler<CancelJobResult> responseHandler = new JsonResponseHandler<CancelJobResult>(unmarshaller);
            cancelJobResult = response = (CancelJobResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return cancelJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePipelineResult updatePipeline(UpdatePipelineRequest updatePipelineRequest) {
        UpdatePipelineResult updatePipelineResult;
        ExecutionContext executionContext = this.createExecutionContext(updatePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdatePipelineRequest> request = null;
        UpdatePipelineResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdatePipelineRequestMarshaller().marshall(updatePipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UpdatePipelineResultJsonUnmarshaller unmarshaller = new UpdatePipelineResultJsonUnmarshaller();
            JsonResponseHandler<UpdatePipelineResult> responseHandler = new JsonResponseHandler<UpdatePipelineResult>(unmarshaller);
            updatePipelineResult = response = (UpdatePipelineResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updatePipelineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPresetsResult listPresets(ListPresetsRequest listPresetsRequest) {
        ListPresetsResult listPresetsResult;
        ExecutionContext executionContext = this.createExecutionContext(listPresetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPresetsRequest> request = null;
        ListPresetsResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPresetsRequestMarshaller().marshall(listPresetsRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPresetsResultJsonUnmarshaller unmarshaller = new ListPresetsResultJsonUnmarshaller();
            JsonResponseHandler<ListPresetsResult> responseHandler = new JsonResponseHandler<ListPresetsResult>(unmarshaller);
            listPresetsResult = response = (ListPresetsResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listPresetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePipelineResult deletePipeline(DeletePipelineRequest deletePipelineRequest) {
        DeletePipelineResult deletePipelineResult;
        ExecutionContext executionContext = this.createExecutionContext(deletePipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePipelineRequest> request = null;
        DeletePipelineResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePipelineRequestMarshaller().marshall(deletePipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeletePipelineResultJsonUnmarshaller unmarshaller = new DeletePipelineResultJsonUnmarshaller();
            JsonResponseHandler<DeletePipelineResult> responseHandler = new JsonResponseHandler<DeletePipelineResult>(unmarshaller);
            deletePipelineResult = response = (DeletePipelineResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deletePipelineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestRoleResult testRole(TestRoleRequest testRoleRequest) {
        TestRoleResult testRoleResult;
        ExecutionContext executionContext = this.createExecutionContext(testRoleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestRoleRequest> request = null;
        TestRoleResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestRoleRequestMarshaller().marshall(testRoleRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            TestRoleResultJsonUnmarshaller unmarshaller = new TestRoleResultJsonUnmarshaller();
            JsonResponseHandler<TestRoleResult> responseHandler = new JsonResponseHandler<TestRoleResult>(unmarshaller);
            testRoleResult = response = (TestRoleResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return testRoleResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPipelinesResult listPipelines(ListPipelinesRequest listPipelinesRequest) {
        ListPipelinesResult listPipelinesResult;
        ExecutionContext executionContext = this.createExecutionContext(listPipelinesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPipelinesRequest> request = null;
        ListPipelinesResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPipelinesRequestMarshaller().marshall(listPipelinesRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPipelinesResultJsonUnmarshaller unmarshaller = new ListPipelinesResultJsonUnmarshaller();
            JsonResponseHandler<ListPipelinesResult> responseHandler = new JsonResponseHandler<ListPipelinesResult>(unmarshaller);
            listPipelinesResult = response = (ListPipelinesResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listPipelinesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadPipelineResult readPipeline(ReadPipelineRequest readPipelineRequest) {
        ReadPipelineResult readPipelineResult;
        ExecutionContext executionContext = this.createExecutionContext(readPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ReadPipelineRequest> request = null;
        ReadPipelineResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ReadPipelineRequestMarshaller().marshall(readPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ReadPipelineResultJsonUnmarshaller unmarshaller = new ReadPipelineResultJsonUnmarshaller();
            JsonResponseHandler<ReadPipelineResult> responseHandler = new JsonResponseHandler<ReadPipelineResult>(unmarshaller);
            readPipelineResult = response = (ReadPipelineResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return readPipelineResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePresetResult createPreset(CreatePresetRequest createPresetRequest) {
        CreatePresetResult createPresetResult;
        ExecutionContext executionContext = this.createExecutionContext(createPresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePresetRequest> request = null;
        CreatePresetResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePresetRequestMarshaller().marshall(createPresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreatePresetResultJsonUnmarshaller unmarshaller = new CreatePresetResultJsonUnmarshaller();
            JsonResponseHandler<CreatePresetResult> responseHandler = new JsonResponseHandler<CreatePresetResult>(unmarshaller);
            createPresetResult = response = (CreatePresetResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createPresetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePresetResult deletePreset(DeletePresetRequest deletePresetRequest) {
        DeletePresetResult deletePresetResult;
        ExecutionContext executionContext = this.createExecutionContext(deletePresetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePresetRequest> request = null;
        DeletePresetResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePresetRequestMarshaller().marshall(deletePresetRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DeletePresetResultJsonUnmarshaller unmarshaller = new DeletePresetResultJsonUnmarshaller();
            JsonResponseHandler<DeletePresetResult> responseHandler = new JsonResponseHandler<DeletePresetResult>(unmarshaller);
            deletePresetResult = response = (DeletePresetResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deletePresetResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateJobResult createJob(CreateJobRequest createJobRequest) {
        CreateJobResult createJobResult;
        ExecutionContext executionContext = this.createExecutionContext(createJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateJobRequest> request = null;
        CreateJobResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateJobRequestMarshaller().marshall(createJobRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateJobResultJsonUnmarshaller unmarshaller = new CreateJobResultJsonUnmarshaller();
            JsonResponseHandler<CreateJobResult> responseHandler = new JsonResponseHandler<CreateJobResult>(unmarshaller);
            createJobResult = response = (CreateJobResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createJobResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsByPipelineResult listJobsByPipeline(ListJobsByPipelineRequest listJobsByPipelineRequest) {
        ListJobsByPipelineResult listJobsByPipelineResult;
        ExecutionContext executionContext = this.createExecutionContext(listJobsByPipelineRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsByPipelineRequest> request = null;
        ListJobsByPipelineResult response = null;
        try {
            awsRequestMetrics.startEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsByPipelineRequestMarshaller().marshall(listJobsByPipelineRequest);
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent(AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsByPipelineResultJsonUnmarshaller unmarshaller = new ListJobsByPipelineResultJsonUnmarshaller();
            JsonResponseHandler<ListJobsByPipelineResult> responseHandler = new JsonResponseHandler<ListJobsByPipelineResult>(unmarshaller);
            listJobsByPipelineResult = response = (ListJobsByPipelineResult)this.invoke(request, responseHandler, executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listJobsByPipelineResult;
    }

    @Override
    public ListPresetsResult listPresets() throws AmazonServiceException, AmazonClientException {
        return this.listPresets(new ListPresetsRequest());
    }

    @Override
    public ListPipelinesResult listPipelines() throws AmazonServiceException, AmazonClientException {
        return this.listPipelines(new ListPipelinesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elastictranscoder";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent(AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.exceptionUnmarshallers);
        Object result = this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
        awsRequestMetrics.log();
        return (X)result;
    }
}

