/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest;
import com.amazonaws.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResult;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest;
import com.amazonaws.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResult;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest;
import com.amazonaws.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesResult;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResult;
import com.amazonaws.services.elasticloadbalancing.model.transform.ApplySecurityGroupsToLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ApplySecurityGroupsToLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.AttachLoadBalancerToSubnetsRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.AttachLoadBalancerToSubnetsResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CertificateNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerListenersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerListenersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerAttributesResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerPoliciesRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerPoliciesResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerPolicyTypesRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancerPolicyTypesResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DetachLoadBalancerFromSubnetsRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DetachLoadBalancerFromSubnetsResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicateListenerExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicateLoadBalancerNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicatePolicyNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidConfigurationRequestExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidInstanceExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidSchemeExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidSecurityGroupExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidSubnetExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.LoadBalancerAttributeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.LoadBalancerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ModifyLoadBalancerAttributesResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyTypeNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerListenerSSLCertificateRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesForBackendServerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesForBackendServerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SubnetNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyLoadBalancersExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyPoliciesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticLoadBalancingClient
extends AmazonWebServiceClient
implements AmazonElasticLoadBalancing {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonElasticLoadBalancingClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonElasticLoadBalancingClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonElasticLoadBalancingClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonElasticLoadBalancingClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new ListenerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SubnetNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidConfigurationRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LoadBalancerAttributeNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyPoliciesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CertificateNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidSubnetExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidSecurityGroupExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LoadBalancerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PolicyNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateListenerExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyLoadBalancersExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PolicyTypeNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidSchemeExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInstanceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicatePolicyNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateLoadBalancerNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticloadbalancing.amazonaws.com");
        this.signer = new AWS4Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticloadbalancing/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerPolicyTypesResult describeLoadBalancerPolicyTypes(DescribeLoadBalancerPolicyTypesRequest describeLoadBalancerPolicyTypesRequest) {
        DescribeLoadBalancerPolicyTypesResult describeLoadBalancerPolicyTypesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeLoadBalancerPolicyTypesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeLoadBalancerPolicyTypesRequest> request = null;
        DescribeLoadBalancerPolicyTypesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeLoadBalancerPolicyTypesRequestMarshaller().marshall(describeLoadBalancerPolicyTypesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeLoadBalancerPolicyTypesResult = response = this.invoke(request, new DescribeLoadBalancerPolicyTypesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeLoadBalancerPolicyTypesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigureHealthCheckResult configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) {
        ConfigureHealthCheckResult configureHealthCheckResult;
        ExecutionContext executionContext = this.createExecutionContext(configureHealthCheckRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ConfigureHealthCheckRequest> request = null;
        ConfigureHealthCheckResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ConfigureHealthCheckRequestMarshaller().marshall(configureHealthCheckRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            configureHealthCheckResult = response = this.invoke(request, new ConfigureHealthCheckResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return configureHealthCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachLoadBalancerFromSubnetsResult detachLoadBalancerFromSubnets(DetachLoadBalancerFromSubnetsRequest detachLoadBalancerFromSubnetsRequest) {
        DetachLoadBalancerFromSubnetsResult detachLoadBalancerFromSubnetsResult;
        ExecutionContext executionContext = this.createExecutionContext(detachLoadBalancerFromSubnetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DetachLoadBalancerFromSubnetsRequest> request = null;
        DetachLoadBalancerFromSubnetsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DetachLoadBalancerFromSubnetsRequestMarshaller().marshall(detachLoadBalancerFromSubnetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            detachLoadBalancerFromSubnetsResult = response = this.invoke(request, new DetachLoadBalancerFromSubnetsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return detachLoadBalancerFromSubnetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLoadBalancerAttributesResult modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) {
        ModifyLoadBalancerAttributesResult modifyLoadBalancerAttributesResult;
        ExecutionContext executionContext = this.createExecutionContext(modifyLoadBalancerAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ModifyLoadBalancerAttributesRequest> request = null;
        ModifyLoadBalancerAttributesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ModifyLoadBalancerAttributesRequestMarshaller().marshall(modifyLoadBalancerAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            modifyLoadBalancerAttributesResult = response = this.invoke(request, new ModifyLoadBalancerAttributesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return modifyLoadBalancerAttributesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createLoadBalancerListenersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateLoadBalancerListenersRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateLoadBalancerListenersRequestMarshaller().marshall(createLoadBalancerListenersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLoadBalancerListenersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteLoadBalancerListenersRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteLoadBalancerListenersRequestMarshaller().marshall(deleteLoadBalancerListenersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAppCookieStickinessPolicyResult createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) {
        CreateAppCookieStickinessPolicyResult createAppCookieStickinessPolicyResult;
        ExecutionContext executionContext = this.createExecutionContext(createAppCookieStickinessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateAppCookieStickinessPolicyRequest> request = null;
        CreateAppCookieStickinessPolicyResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateAppCookieStickinessPolicyRequestMarshaller().marshall(createAppCookieStickinessPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createAppCookieStickinessPolicyResult = response = this.invoke(request, new CreateAppCookieStickinessPolicyResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createAppCookieStickinessPolicyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplySecurityGroupsToLoadBalancerResult applySecurityGroupsToLoadBalancer(ApplySecurityGroupsToLoadBalancerRequest applySecurityGroupsToLoadBalancerRequest) {
        ApplySecurityGroupsToLoadBalancerResult applySecurityGroupsToLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(applySecurityGroupsToLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ApplySecurityGroupsToLoadBalancerRequest> request = null;
        ApplySecurityGroupsToLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ApplySecurityGroupsToLoadBalancerRequestMarshaller().marshall(applySecurityGroupsToLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            applySecurityGroupsToLoadBalancerResult = response = this.invoke(request, new ApplySecurityGroupsToLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return applySecurityGroupsToLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerPoliciesResult describeLoadBalancerPolicies(DescribeLoadBalancerPoliciesRequest describeLoadBalancerPoliciesRequest) {
        DescribeLoadBalancerPoliciesResult describeLoadBalancerPoliciesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeLoadBalancerPoliciesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeLoadBalancerPoliciesRequest> request = null;
        DescribeLoadBalancerPoliciesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeLoadBalancerPoliciesRequestMarshaller().marshall(describeLoadBalancerPoliciesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeLoadBalancerPoliciesResult = response = this.invoke(request, new DescribeLoadBalancerPoliciesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeLoadBalancerPoliciesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetLoadBalancerPoliciesOfListenerResult setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) {
        SetLoadBalancerPoliciesOfListenerResult setLoadBalancerPoliciesOfListenerResult;
        ExecutionContext executionContext = this.createExecutionContext(setLoadBalancerPoliciesOfListenerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetLoadBalancerPoliciesOfListenerRequest> request = null;
        SetLoadBalancerPoliciesOfListenerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetLoadBalancerPoliciesOfListenerRequestMarshaller().marshall(setLoadBalancerPoliciesOfListenerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            setLoadBalancerPoliciesOfListenerResult = response = this.invoke(request, new SetLoadBalancerPoliciesOfListenerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return setLoadBalancerPoliciesOfListenerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableAvailabilityZonesForLoadBalancerResult disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) {
        DisableAvailabilityZonesForLoadBalancerResult disableAvailabilityZonesForLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(disableAvailabilityZonesForLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DisableAvailabilityZonesForLoadBalancerRequest> request = null;
        DisableAvailabilityZonesForLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DisableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(disableAvailabilityZonesForLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            disableAvailabilityZonesForLoadBalancerResult = response = this.invoke(request, new DisableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return disableAvailabilityZonesForLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceHealthResult describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) {
        DescribeInstanceHealthResult describeInstanceHealthResult;
        ExecutionContext executionContext = this.createExecutionContext(describeInstanceHealthRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeInstanceHealthRequest> request = null;
        DescribeInstanceHealthResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeInstanceHealthRequestMarshaller().marshall(describeInstanceHealthRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeInstanceHealthResult = response = this.invoke(request, new DescribeInstanceHealthResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeInstanceHealthResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerPolicyResult deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) {
        DeleteLoadBalancerPolicyResult deleteLoadBalancerPolicyResult;
        ExecutionContext executionContext = this.createExecutionContext(deleteLoadBalancerPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteLoadBalancerPolicyRequest> request = null;
        DeleteLoadBalancerPolicyResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteLoadBalancerPolicyRequestMarshaller().marshall(deleteLoadBalancerPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deleteLoadBalancerPolicyResult = response = this.invoke(request, new DeleteLoadBalancerPolicyResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deleteLoadBalancerPolicyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerPolicyResult createLoadBalancerPolicy(CreateLoadBalancerPolicyRequest createLoadBalancerPolicyRequest) {
        CreateLoadBalancerPolicyResult createLoadBalancerPolicyResult;
        ExecutionContext executionContext = this.createExecutionContext(createLoadBalancerPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateLoadBalancerPolicyRequest> request = null;
        CreateLoadBalancerPolicyResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateLoadBalancerPolicyRequestMarshaller().marshall(createLoadBalancerPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createLoadBalancerPolicyResult = response = this.invoke(request, new CreateLoadBalancerPolicyResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createLoadBalancerPolicyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableAvailabilityZonesForLoadBalancerResult enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) {
        EnableAvailabilityZonesForLoadBalancerResult enableAvailabilityZonesForLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(enableAvailabilityZonesForLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<EnableAvailabilityZonesForLoadBalancerRequest> request = null;
        EnableAvailabilityZonesForLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new EnableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(enableAvailabilityZonesForLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            enableAvailabilityZonesForLoadBalancerResult = response = this.invoke(request, new EnableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return enableAvailabilityZonesForLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteLoadBalancerRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteLoadBalancerRequestMarshaller().marshall(deleteLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerResult createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) {
        CreateLoadBalancerResult createLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(createLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateLoadBalancerRequest> request = null;
        CreateLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateLoadBalancerRequestMarshaller().marshall(createLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createLoadBalancerResult = response = this.invoke(request, new CreateLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetLoadBalancerPoliciesForBackendServerResult setLoadBalancerPoliciesForBackendServer(SetLoadBalancerPoliciesForBackendServerRequest setLoadBalancerPoliciesForBackendServerRequest) {
        SetLoadBalancerPoliciesForBackendServerResult setLoadBalancerPoliciesForBackendServerResult;
        ExecutionContext executionContext = this.createExecutionContext(setLoadBalancerPoliciesForBackendServerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetLoadBalancerPoliciesForBackendServerRequest> request = null;
        SetLoadBalancerPoliciesForBackendServerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetLoadBalancerPoliciesForBackendServerRequestMarshaller().marshall(setLoadBalancerPoliciesForBackendServerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            setLoadBalancerPoliciesForBackendServerResult = response = this.invoke(request, new SetLoadBalancerPoliciesForBackendServerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return setLoadBalancerPoliciesForBackendServerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterInstancesFromLoadBalancerResult deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) {
        DeregisterInstancesFromLoadBalancerResult deregisterInstancesFromLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(deregisterInstancesFromLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeregisterInstancesFromLoadBalancerRequest> request = null;
        DeregisterInstancesFromLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeregisterInstancesFromLoadBalancerRequestMarshaller().marshall(deregisterInstancesFromLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            deregisterInstancesFromLoadBalancerResult = response = this.invoke(request, new DeregisterInstancesFromLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return deregisterInstancesFromLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSSLCertificateRequest setLoadBalancerListenerSSLCertificateRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setLoadBalancerListenerSSLCertificateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetLoadBalancerListenerSSLCertificateRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetLoadBalancerListenerSSLCertificateRequestMarshaller().marshall(setLoadBalancerListenerSSLCertificateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerAttributesResult describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) {
        DescribeLoadBalancerAttributesResult describeLoadBalancerAttributesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeLoadBalancerAttributesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeLoadBalancerAttributesRequest> request = null;
        DescribeLoadBalancerAttributesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeLoadBalancerAttributesRequestMarshaller().marshall(describeLoadBalancerAttributesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeLoadBalancerAttributesResult = response = this.invoke(request, new DescribeLoadBalancerAttributesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeLoadBalancerAttributesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLBCookieStickinessPolicyResult createLBCookieStickinessPolicy(CreateLBCookieStickinessPolicyRequest createLBCookieStickinessPolicyRequest) {
        CreateLBCookieStickinessPolicyResult createLBCookieStickinessPolicyResult;
        ExecutionContext executionContext = this.createExecutionContext(createLBCookieStickinessPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateLBCookieStickinessPolicyRequest> request = null;
        CreateLBCookieStickinessPolicyResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateLBCookieStickinessPolicyRequestMarshaller().marshall(createLBCookieStickinessPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createLBCookieStickinessPolicyResult = response = this.invoke(request, new CreateLBCookieStickinessPolicyResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createLBCookieStickinessPolicyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachLoadBalancerToSubnetsResult attachLoadBalancerToSubnets(AttachLoadBalancerToSubnetsRequest attachLoadBalancerToSubnetsRequest) {
        AttachLoadBalancerToSubnetsResult attachLoadBalancerToSubnetsResult;
        ExecutionContext executionContext = this.createExecutionContext(attachLoadBalancerToSubnetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<AttachLoadBalancerToSubnetsRequest> request = null;
        AttachLoadBalancerToSubnetsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new AttachLoadBalancerToSubnetsRequestMarshaller().marshall(attachLoadBalancerToSubnetsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            attachLoadBalancerToSubnetsResult = response = this.invoke(request, new AttachLoadBalancerToSubnetsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return attachLoadBalancerToSubnetsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterInstancesWithLoadBalancerResult registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) {
        RegisterInstancesWithLoadBalancerResult registerInstancesWithLoadBalancerResult;
        ExecutionContext executionContext = this.createExecutionContext(registerInstancesWithLoadBalancerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<RegisterInstancesWithLoadBalancerRequest> request = null;
        RegisterInstancesWithLoadBalancerResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new RegisterInstancesWithLoadBalancerRequestMarshaller().marshall(registerInstancesWithLoadBalancerRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            registerInstancesWithLoadBalancerResult = response = this.invoke(request, new RegisterInstancesWithLoadBalancerResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return registerInstancesWithLoadBalancerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) {
        DescribeLoadBalancersResult describeLoadBalancersResult;
        ExecutionContext executionContext = this.createExecutionContext(describeLoadBalancersRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeLoadBalancersRequest> request = null;
        DescribeLoadBalancersResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeLoadBalancersRequestMarshaller().marshall(describeLoadBalancersRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeLoadBalancersResult = response = this.invoke(request, new DescribeLoadBalancersResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeLoadBalancersResult;
    }

    @Override
    public DescribeLoadBalancerPolicyTypesResult describeLoadBalancerPolicyTypes() throws AmazonServiceException, AmazonClientException {
        return this.describeLoadBalancerPolicyTypes(new DescribeLoadBalancerPolicyTypesRequest());
    }

    @Override
    public DescribeLoadBalancerPoliciesResult describeLoadBalancerPolicies() throws AmazonServiceException, AmazonClientException {
        return this.describeLoadBalancerPolicies(new DescribeLoadBalancerPoliciesRequest());
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers() throws AmazonServiceException, AmazonClientException {
        return this.describeLoadBalancers(new DescribeLoadBalancersRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "elasticloadbalancing";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

