/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.CancelUpdateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.CreateStackResult;
import com.amazonaws.services.cloudformation.model.DeleteStackRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackEventsResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourceResult;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostRequest;
import com.amazonaws.services.cloudformation.model.EstimateTemplateCostResult;
import com.amazonaws.services.cloudformation.model.GetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.GetStackPolicyResult;
import com.amazonaws.services.cloudformation.model.GetTemplateRequest;
import com.amazonaws.services.cloudformation.model.GetTemplateResult;
import com.amazonaws.services.cloudformation.model.ListStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.ListStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ListStacksRequest;
import com.amazonaws.services.cloudformation.model.ListStacksResult;
import com.amazonaws.services.cloudformation.model.SetStackPolicyRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackRequest;
import com.amazonaws.services.cloudformation.model.UpdateStackResult;
import com.amazonaws.services.cloudformation.model.ValidateTemplateRequest;
import com.amazonaws.services.cloudformation.model.ValidateTemplateResult;
import com.amazonaws.services.cloudformation.model.transform.AlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.CancelUpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.CreateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DeleteStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackEventsResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourceResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.DescribeStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.EstimateTemplateCostResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetStackPolicyRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetStackPolicyResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.GetTemplateResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.InsufficientCapabilitiesExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStackResourcesResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ListStacksResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.SetStackPolicyRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.UpdateStackResultStaxUnmarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateRequestMarshaller;
import com.amazonaws.services.cloudformation.model.transform.ValidateTemplateResultStaxUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonCloudFormationClient
extends AmazonWebServiceClient
implements AmazonCloudFormation {
    private AWSCredentialsProvider awsCredentialsProvider;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
    private AWS4Signer signer;

    public AmazonCloudFormationClient() {
        this(new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonCloudFormationClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonCloudFormationClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.exceptionUnmarshallers.add(new AlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientCapabilitiesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("cloudformation.us-east-1.amazonaws.com");
        this.signer = new AWS4Signer();
        this.signer.setServiceName("cloudformation");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/cloudformation/request.handlers"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateTemplateResult validateTemplate(ValidateTemplateRequest validateTemplateRequest) {
        ValidateTemplateResult validateTemplateResult;
        ExecutionContext executionContext = this.createExecutionContext(validateTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ValidateTemplateRequest> request = null;
        ValidateTemplateResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ValidateTemplateRequestMarshaller().marshall(validateTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            validateTemplateResult = response = this.invoke(request, new ValidateTemplateResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return validateTemplateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStacksResult describeStacks(DescribeStacksRequest describeStacksRequest) {
        DescribeStacksResult describeStacksResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStacksRequest> request = null;
        DescribeStacksResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStacksRequestMarshaller().marshall(describeStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStacksResult = response = this.invoke(request, new DescribeStacksResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStacksResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTemplateResult getTemplate(GetTemplateRequest getTemplateRequest) {
        GetTemplateResult getTemplateResult;
        ExecutionContext executionContext = this.createExecutionContext(getTemplateRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetTemplateRequest> request = null;
        GetTemplateResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetTemplateRequestMarshaller().marshall(getTemplateRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getTemplateResult = response = this.invoke(request, new GetTemplateResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getTemplateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetStackPolicyResult getStackPolicy(GetStackPolicyRequest getStackPolicyRequest) {
        GetStackPolicyResult getStackPolicyResult;
        ExecutionContext executionContext = this.createExecutionContext(getStackPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<GetStackPolicyRequest> request = null;
        GetStackPolicyResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new GetStackPolicyRequestMarshaller().marshall(getStackPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            getStackPolicyResult = response = this.invoke(request, new GetStackPolicyResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return getStackPolicyResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStacksResult listStacks(ListStacksRequest listStacksRequest) {
        ListStacksResult listStacksResult;
        ExecutionContext executionContext = this.createExecutionContext(listStacksRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListStacksRequest> request = null;
        ListStacksResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListStacksRequestMarshaller().marshall(listStacksRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listStacksResult = response = this.invoke(request, new ListStacksResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listStacksResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateStackResult createStack(CreateStackRequest createStackRequest) {
        CreateStackResult createStackResult;
        ExecutionContext executionContext = this.createExecutionContext(createStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CreateStackRequest> request = null;
        CreateStackResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CreateStackRequestMarshaller().marshall(createStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            createStackResult = response = this.invoke(request, new CreateStackResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return createStackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStackPolicy(SetStackPolicyRequest setStackPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setStackPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<SetStackPolicyRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new SetStackPolicyRequestMarshaller().marshall(setStackPolicyRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EstimateTemplateCostResult estimateTemplateCost(EstimateTemplateCostRequest estimateTemplateCostRequest) {
        EstimateTemplateCostResult estimateTemplateCostResult;
        ExecutionContext executionContext = this.createExecutionContext(estimateTemplateCostRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<EstimateTemplateCostRequest> request = null;
        EstimateTemplateCostResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new EstimateTemplateCostRequestMarshaller().marshall(estimateTemplateCostRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            estimateTemplateCostResult = response = this.invoke(request, new EstimateTemplateCostResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return estimateTemplateCostResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackEventsResult describeStackEvents(DescribeStackEventsRequest describeStackEventsRequest) {
        DescribeStackEventsResult describeStackEventsResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStackEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackEventsRequest> request = null;
        DescribeStackEventsResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackEventsRequestMarshaller().marshall(describeStackEventsRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStackEventsResult = response = this.invoke(request, new DescribeStackEventsResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStackEventsResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackResourceResult describeStackResource(DescribeStackResourceRequest describeStackResourceRequest) {
        DescribeStackResourceResult describeStackResourceResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStackResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackResourceRequest> request = null;
        DescribeStackResourceResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackResourceRequestMarshaller().marshall(describeStackResourceRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStackResourceResult = response = this.invoke(request, new DescribeStackResourceResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStackResourceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpdateStack(CancelUpdateStackRequest cancelUpdateStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelUpdateStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<CancelUpdateStackRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new CancelUpdateStackRequestMarshaller().marshall(cancelUpdateStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateStackResult updateStack(UpdateStackRequest updateStackRequest) {
        UpdateStackResult updateStackResult;
        ExecutionContext executionContext = this.createExecutionContext(updateStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<UpdateStackRequest> request = null;
        UpdateStackResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new UpdateStackRequestMarshaller().marshall(updateStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            updateStackResult = response = this.invoke(request, new UpdateStackResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return updateStackResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeStackResourcesResult describeStackResources(DescribeStackResourcesRequest describeStackResourcesRequest) {
        DescribeStackResourcesResult describeStackResourcesResult;
        ExecutionContext executionContext = this.createExecutionContext(describeStackResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DescribeStackResourcesRequest> request = null;
        DescribeStackResourcesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DescribeStackResourcesRequestMarshaller().marshall(describeStackResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            describeStackResourcesResult = response = this.invoke(request, new DescribeStackResourcesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return describeStackResourcesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteStack(DeleteStackRequest deleteStackRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteStackRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<DeleteStackRequest> request = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new DeleteStackRequestMarshaller().marshall(deleteStackRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            this.invoke(request, null, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListStackResourcesResult listStackResources(ListStackResourcesRequest listStackResourcesRequest) {
        ListStackResourcesResult listStackResourcesResult;
        ExecutionContext executionContext = this.createExecutionContext(listStackResourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        Request<ListStackResourcesRequest> request = null;
        ListStackResourcesResult response = null;
        awsRequestMetrics.startEvent(AWSRequestMetrics.Field.ClientExecuteTime);
        try {
            request = new ListStackResourcesRequestMarshaller().marshall(listStackResourcesRequest);
            request.setAWSRequestMetrics(awsRequestMetrics);
            listStackResourcesResult = response = this.invoke(request, new ListStackResourcesResultStaxUnmarshaller(), executionContext);
        }
        catch (Throwable throwable) {
            this.endClientExecution(awsRequestMetrics, request, response);
            throw throwable;
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return listStackResourcesResult;
    }

    @Override
    public DescribeStacksResult describeStacks() throws AmazonServiceException, AmazonClientException {
        return this.describeStacks(new DescribeStacksRequest());
    }

    @Override
    public ListStacksResult listStacks() throws AmazonServiceException, AmazonClientException {
        return this.listStacks(new ListStacksRequest());
    }

    @Override
    public EstimateTemplateCostResult estimateTemplateCost() throws AmazonServiceException, AmazonClientException {
        return this.estimateTemplateCost(new EstimateTemplateCostRequest());
    }

    @Override
    public DescribeStackEventsResult describeStackEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeStackEvents(new DescribeStackEventsRequest());
    }

    @Override
    public DescribeStackResourcesResult describeStackResources() throws AmazonServiceException, AmazonClientException {
        return this.describeStackResources(new DescribeStackResourcesRequest());
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        this.setEndpoint(endpoint);
        this.signer.setServiceName(serviceName);
        this.signer.setRegionName(regionId);
    }

    @Override
    protected String getServiceAbbreviation() {
        return "cloudformation";
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        for (Map.Entry<String, String> entry : originalRequest.copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AWSCredentials credentials = this.awsCredentialsProvider.getCredentials();
        if (originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setSigner(this.signer);
        executionContext.setCredentials(credentials);
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

