/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http.conn;

import com.amazonaws.http.conn.Wrapped;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.ServiceLatencyProvider;
import com.amazonaws.metrics.ServiceMetricCollector;
import com.amazonaws.util.AWSServiceMetrics;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionRequest;

class ClientConnectionRequestFactory {
    private static final Log log = LogFactory.getLog(ClientConnectionRequestFactory.class);
    private static final Class<?>[] interfaces = new Class[]{ClientConnectionRequest.class, Wrapped.class};

    ClientConnectionRequestFactory() {
    }

    static ClientConnectionRequest wrap(ClientConnectionRequest orig) {
        if (orig instanceof Wrapped) {
            throw new IllegalArgumentException();
        }
        return (ClientConnectionRequest)Proxy.newProxyInstance(ClientConnectionRequest.class.getClassLoader(), interfaces, (InvocationHandler)new Handler(orig));
    }

    private static class Handler
    implements InvocationHandler {
        private final ClientConnectionRequest orig;

        Handler(ClientConnectionRequest orig) {
            this.orig = orig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!"getConnection".equals(method.getName())) return method.invoke((Object)this.orig, args);
            ServiceLatencyProvider latencyProvider = new ServiceLatencyProvider(AWSServiceMetrics.HttpClientGetConnectionTime);
            try {
                Object object = method.invoke((Object)this.orig, args);
                ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                return object;
            }
            catch (Throwable throwable) {
                try {
                    ((ServiceMetricCollector)AwsSdkMetrics.getServiceMetricCollector()).collectLatency(latencyProvider.endTiming());
                    throw throwable;
                }
                catch (InvocationTargetException e) {
                    log.debug((Object)"", (Throwable)e);
                    throw e.getCause();
                }
            }
        }
    }
}

