/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.directconnect.model.AllocateConnectionOnInterconnectRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocateConnectionOnInterconnectRequestMarshaller
implements Marshaller<Request<AllocateConnectionOnInterconnectRequest>, AllocateConnectionOnInterconnectRequest> {
    @Override
    public Request<AllocateConnectionOnInterconnectRequest> marshall(AllocateConnectionOnInterconnectRequest allocateConnectionOnInterconnectRequest) {
        if (allocateConnectionOnInterconnectRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AllocateConnectionOnInterconnectRequest> request = new DefaultRequest<AllocateConnectionOnInterconnectRequest>(allocateConnectionOnInterconnectRequest, "AmazonDirectConnect");
        String target = "OvertureService.AllocateConnectionOnInterconnect";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.1");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "";
        uriResourcePath = uriResourcePath.replaceAll("//", "/");
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (allocateConnectionOnInterconnectRequest.getBandwidth() != null) {
                jsonWriter.key("bandwidth").value(allocateConnectionOnInterconnectRequest.getBandwidth());
            }
            if (allocateConnectionOnInterconnectRequest.getConnectionName() != null) {
                jsonWriter.key("connectionName").value(allocateConnectionOnInterconnectRequest.getConnectionName());
            }
            if (allocateConnectionOnInterconnectRequest.getOwnerAccount() != null) {
                jsonWriter.key("ownerAccount").value(allocateConnectionOnInterconnectRequest.getOwnerAccount());
            }
            if (allocateConnectionOnInterconnectRequest.getInterconnectId() != null) {
                jsonWriter.key("interconnectId").value(allocateConnectionOnInterconnectRequest.getInterconnectId());
            }
            if (allocateConnectionOnInterconnectRequest.getVlan() != null) {
                jsonWriter.key("vlan").value(allocateConnectionOnInterconnectRequest.getVlan());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

