/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.services.s3.transfer.Transfer;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.AbstractTransfer;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MultipleFileTransfer
extends AbstractTransfer {
    protected final Collection<? extends Transfer> subTransfers;

    MultipleFileTransfer(String description, TransferProgress transferProgress, com.amazonaws.event.ProgressListenerChain progressListenerChain, Collection<? extends Transfer> subTransfers) {
        super(description, transferProgress, progressListenerChain);
        this.subTransfers = subTransfers;
    }

    @Deprecated
    MultipleFileTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, Collection<? extends Transfer> subTransfers) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), subTransfers);
    }

    public void collateFinalState() {
        boolean seenCanceled = false;
        for (Transfer transfer : this.subTransfers) {
            if (transfer.getState() == Transfer.TransferState.Failed) {
                this.setState(Transfer.TransferState.Failed);
                return;
            }
            if (transfer.getState() != Transfer.TransferState.Canceled) continue;
            seenCanceled = true;
        }
        if (seenCanceled) {
            this.setState(Transfer.TransferState.Canceled);
        } else {
            this.setState(Transfer.TransferState.Completed);
        }
    }
}

