/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.http.annotation.NotThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public class TimingInfo {
    private static final int UNKNOWN = -1;
    private final long startEpochTimeMilli;
    private final long startTimeNano;
    private long endTimeNano;
    private final Map<String, List<TimingInfo>> subMeasurementsByName = new HashMap<String, List<TimingInfo>>();
    private final Map<String, Number> countersByName = new HashMap<String, Number>();

    @Deprecated
    public TimingInfo() {
        this(System.currentTimeMillis(), System.nanoTime(), -1L);
    }

    @Deprecated
    public TimingInfo(long startTimeNano) {
        this(-1L, startTimeNano, -1L);
    }

    @Deprecated
    public TimingInfo(long startTimeNano, long endTimeNano) {
        this(-1L, startTimeNano, endTimeNano);
    }

    public static TimingInfo startTiming() {
        return new TimingInfo(System.currentTimeMillis(), System.nanoTime(), -1L);
    }

    public static TimingInfo startTiming(long startTimeNano) {
        return new TimingInfo(-1L, startTimeNano, -1L);
    }

    public static TimingInfo newTimingInfo(long startTimeNano, long endTimeNano) {
        return new TimingInfo(-1L, startTimeNano, endTimeNano);
    }

    public static TimingInfo newTimingInfo(long startEpochTimeMilli, long startTimeNano, long endTimeNano) {
        return new TimingInfo(startEpochTimeMilli, startTimeNano, endTimeNano);
    }

    private TimingInfo(long startEpochTimeMilli, long startTimeNano, long endTimeNano) {
        this.startEpochTimeMilli = startEpochTimeMilli;
        this.startTimeNano = startTimeNano;
        this.endTimeNano = endTimeNano;
    }

    @Deprecated
    public long getStartTime() {
        return this.startEpochTimeMilli < 0L ? TimeUnit.NANOSECONDS.toMillis(this.startTimeNano) : this.startEpochTimeMilli;
    }

    public long getStartEpochTimeMilli() {
        return this.startEpochTimeMilli;
    }

    public long getStartTimeNano() {
        return this.startTimeNano;
    }

    @Deprecated
    public long getEndTime() {
        return this.getEndEpochTimeMilli();
    }

    public long getEndEpochTimeMilli() {
        return this.startEpochTimeMilli < 0L || this.endTimeNano < 0L ? -1L : this.startEpochTimeMilli + this.getElapsedTimeMillis();
    }

    public long getEndTimeNano() {
        return this.endTimeNano;
    }

    public double getTimeTakenMillis() {
        double micros = TimeUnit.NANOSECONDS.toMicros(this.endTimeNano - this.startTimeNano);
        return micros / 1000.0;
    }

    public long getElapsedTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.endTimeNano - this.startTimeNano);
    }

    public String toString() {
        return String.valueOf(this.getTimeTakenMillis());
    }

    @Deprecated
    public void setEndTime(long endTimeMilli) {
        this.endTimeNano = TimeUnit.MILLISECONDS.toNanos(endTimeMilli);
    }

    public void setEndTimeNano(long endTimeNano) {
        this.endTimeNano = endTimeNano;
    }

    public TimingInfo endTiming() {
        this.endTimeNano = System.nanoTime();
        return this;
    }

    public void addSubMeasurement(String subMeasurementName, TimingInfo timingInfo) {
        List<TimingInfo> timings = this.subMeasurementsByName.get(subMeasurementName);
        if (timings == null) {
            timings = new ArrayList<TimingInfo>();
            this.subMeasurementsByName.put(subMeasurementName, timings);
        }
        timings.add(timingInfo);
    }

    public TimingInfo getSubMeasurement(String subMeasurementName) {
        return this.getSubMeasurement(subMeasurementName, 0);
    }

    public TimingInfo getSubMeasurement(String subMesurementName, int index) {
        List<TimingInfo> timings = this.subMeasurementsByName.get(subMesurementName);
        if (index < 0 || timings == null || timings.size() == 0 || index >= timings.size()) {
            return null;
        }
        return timings.get(index);
    }

    public TimingInfo getLastSubMeasurement(String subMeasurementName) {
        if (this.subMeasurementsByName == null || this.subMeasurementsByName.size() == 0) {
            return null;
        }
        List<TimingInfo> timings = this.subMeasurementsByName.get(subMeasurementName);
        if (timings == null || timings.size() == 0) {
            return null;
        }
        return timings.get(timings.size() - 1);
    }

    public List<TimingInfo> getAllSubMeasurements(String subMeasurementName) {
        return this.subMeasurementsByName.get(subMeasurementName);
    }

    public Map<String, List<TimingInfo>> getSubMeasurementsByName() {
        return this.subMeasurementsByName;
    }

    public Number getCounter(String key) {
        return this.countersByName.get(key);
    }

    public Map<String, Number> getAllCounters() {
        return this.countersByName;
    }

    public void setCounter(String key, long count) {
        this.countersByName.put(key, count);
    }

    public void incrementCounter(String key) {
        int count = 0;
        Number counter = this.getCounter(key);
        if (counter != null) {
            count = counter.intValue();
        }
        this.setCounter(key, ++count);
    }
}

