/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.services.glacier.model.PartListElement;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartListElementJsonUnmarshaller
implements Unmarshaller<PartListElement, JsonUnmarshallerContext> {
    private static PartListElementJsonUnmarshaller instance;

    @Override
    public PartListElement unmarshall(JsonUnmarshallerContext context) throws Exception {
        PartListElement partListElement = new PartListElement();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.currentToken;
        if (token == null) {
            token = context.nextToken();
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("RangeInBytes", targetDepth)) {
                    context.nextToken();
                    partListElement.setRangeInBytes(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SHA256TreeHash", targetDepth)) {
                    context.nextToken();
                    partListElement.setSHA256TreeHash(SimpleTypeJsonUnmarshallers.StringJsonUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return partListElement;
    }

    public static PartListElementJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new PartListElementJsonUnmarshaller();
        }
        return instance;
    }
}

