/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Region {
    US_Standard(null),
    US_West("us-west-1"),
    US_West_2("us-west-2"),
    US_GovCloud("s3-us-gov-west-1"),
    EU_Ireland("eu-west-1", "EU"),
    AP_Singapore("ap-southeast-1"),
    AP_Sydney("ap-southeast-2"),
    AP_Tokyo("ap-northeast-1"),
    SA_SaoPaulo("sa-east-1");

    private final List<String> regionIds;

    private Region(String ... regionIds) {
        this.regionIds = regionIds != null ? Arrays.asList(regionIds) : null;
    }

    public String toString() {
        if (this.regionIds != null) {
            return this.regionIds.get(0);
        }
        return null;
    }

    public static Region fromValue(String s3RegionString) throws IllegalArgumentException {
        if (s3RegionString != null && s3RegionString.equals("US")) {
            return US_Standard;
        }
        for (Region region : Region.values()) {
            List<String> regionIds = region.regionIds;
            if (regionIds == null && s3RegionString == null) {
                return region;
            }
            if (regionIds == null || !regionIds.contains(s3RegionString)) continue;
            return region;
        }
        throw new IllegalArgumentException("Cannot create enum from " + s3RegionString + " value!");
    }
}

