/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.Reservation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeInstancesResult
implements Serializable {
    private ListWithAutoConstructFlag<Reservation> reservations;

    public List<Reservation> getReservations() {
        if (this.reservations == null) {
            this.reservations = new ListWithAutoConstructFlag();
            this.reservations.setAutoConstruct(true);
        }
        return this.reservations;
    }

    public void setReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
            return;
        }
        ListWithAutoConstructFlag reservationsCopy = new ListWithAutoConstructFlag(reservations.size());
        reservationsCopy.addAll(reservations);
        this.reservations = reservationsCopy;
    }

    public DescribeInstancesResult withReservations(Reservation ... reservations) {
        if (this.getReservations() == null) {
            this.setReservations(new ArrayList<Reservation>(reservations.length));
        }
        for (Reservation value : reservations) {
            this.getReservations().add(value);
        }
        return this;
    }

    public DescribeInstancesResult withReservations(Collection<Reservation> reservations) {
        if (reservations == null) {
            this.reservations = null;
        } else {
            ListWithAutoConstructFlag reservationsCopy = new ListWithAutoConstructFlag(reservations.size());
            reservationsCopy.addAll(reservations);
            this.reservations = reservationsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservations() != null) {
            sb.append("Reservations: " + this.getReservations());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservations() == null ? 0 : ((Object)this.getReservations()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResult)) {
            return false;
        }
        DescribeInstancesResult other = (DescribeInstancesResult)obj;
        if (other.getReservations() == null ^ this.getReservations() == null) {
            return false;
        }
        return other.getReservations() == null || ((Object)other.getReservations()).equals(this.getReservations());
    }
}

