/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.KeyValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopJarStepConfig
implements Serializable {
    private ListWithAutoConstructFlag<KeyValue> properties;
    private String jar;
    private String mainClass;
    private ListWithAutoConstructFlag<String> args;

    public HadoopJarStepConfig() {
    }

    public HadoopJarStepConfig(String jar) {
        this.setJar(jar);
    }

    public List<KeyValue> getProperties() {
        if (this.properties == null) {
            this.properties = new ListWithAutoConstructFlag();
            this.properties.setAutoConstruct(true);
        }
        return this.properties;
    }

    public void setProperties(Collection<KeyValue> properties) {
        if (properties == null) {
            this.properties = null;
            return;
        }
        ListWithAutoConstructFlag propertiesCopy = new ListWithAutoConstructFlag(properties.size());
        propertiesCopy.addAll(properties);
        this.properties = propertiesCopy;
    }

    public HadoopJarStepConfig withProperties(KeyValue ... properties) {
        if (this.getProperties() == null) {
            this.setProperties(new ArrayList<KeyValue>(properties.length));
        }
        for (KeyValue value : properties) {
            this.getProperties().add(value);
        }
        return this;
    }

    public HadoopJarStepConfig withProperties(Collection<KeyValue> properties) {
        if (properties == null) {
            this.properties = null;
        } else {
            ListWithAutoConstructFlag propertiesCopy = new ListWithAutoConstructFlag(properties.size());
            propertiesCopy.addAll(properties);
            this.properties = propertiesCopy;
        }
        return this;
    }

    public String getJar() {
        return this.jar;
    }

    public void setJar(String jar) {
        this.jar = jar;
    }

    public HadoopJarStepConfig withJar(String jar) {
        this.jar = jar;
        return this;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public HadoopJarStepConfig withMainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public List<String> getArgs() {
        if (this.args == null) {
            this.args = new ListWithAutoConstructFlag();
            this.args.setAutoConstruct(true);
        }
        return this.args;
    }

    public void setArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
            return;
        }
        ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
        argsCopy.addAll(args);
        this.args = argsCopy;
    }

    public HadoopJarStepConfig withArgs(String ... args) {
        if (this.getArgs() == null) {
            this.setArgs(new ArrayList<String>(args.length));
        }
        for (String value : args) {
            this.getArgs().add(value);
        }
        return this;
    }

    public HadoopJarStepConfig withArgs(Collection<String> args) {
        if (args == null) {
            this.args = null;
        } else {
            ListWithAutoConstructFlag argsCopy = new ListWithAutoConstructFlag(args.size());
            argsCopy.addAll(args);
            this.args = argsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProperties() != null) {
            sb.append("Properties: " + this.getProperties() + ",");
        }
        if (this.getJar() != null) {
            sb.append("Jar: " + this.getJar() + ",");
        }
        if (this.getMainClass() != null) {
            sb.append("MainClass: " + this.getMainClass() + ",");
        }
        if (this.getArgs() != null) {
            sb.append("Args: " + this.getArgs());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProperties() == null ? 0 : ((Object)this.getProperties()).hashCode());
        hashCode = 31 * hashCode + (this.getJar() == null ? 0 : this.getJar().hashCode());
        hashCode = 31 * hashCode + (this.getMainClass() == null ? 0 : this.getMainClass().hashCode());
        hashCode = 31 * hashCode + (this.getArgs() == null ? 0 : ((Object)this.getArgs()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HadoopJarStepConfig)) {
            return false;
        }
        HadoopJarStepConfig other = (HadoopJarStepConfig)obj;
        if (other.getProperties() == null ^ this.getProperties() == null) {
            return false;
        }
        if (other.getProperties() != null && !((Object)other.getProperties()).equals(this.getProperties())) {
            return false;
        }
        if (other.getJar() == null ^ this.getJar() == null) {
            return false;
        }
        if (other.getJar() != null && !other.getJar().equals(this.getJar())) {
            return false;
        }
        if (other.getMainClass() == null ^ this.getMainClass() == null) {
            return false;
        }
        if (other.getMainClass() != null && !other.getMainClass().equals(this.getMainClass())) {
            return false;
        }
        if (other.getArgs() == null ^ this.getArgs() == null) {
            return false;
        }
        return other.getArgs() == null || ((Object)other.getArgs()).equals(this.getArgs());
    }
}

