/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.cloudformation.model.Stack;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeStacksResult
implements Serializable {
    private ListWithAutoConstructFlag<Stack> stacks;
    private String nextToken;

    public List<Stack> getStacks() {
        if (this.stacks == null) {
            this.stacks = new ListWithAutoConstructFlag();
            this.stacks.setAutoConstruct(true);
        }
        return this.stacks;
    }

    public void setStacks(Collection<Stack> stacks) {
        if (stacks == null) {
            this.stacks = null;
            return;
        }
        ListWithAutoConstructFlag stacksCopy = new ListWithAutoConstructFlag(stacks.size());
        stacksCopy.addAll(stacks);
        this.stacks = stacksCopy;
    }

    public DescribeStacksResult withStacks(Stack ... stacks) {
        if (this.getStacks() == null) {
            this.setStacks(new ArrayList<Stack>(stacks.length));
        }
        for (Stack value : stacks) {
            this.getStacks().add(value);
        }
        return this;
    }

    public DescribeStacksResult withStacks(Collection<Stack> stacks) {
        if (stacks == null) {
            this.stacks = null;
        } else {
            ListWithAutoConstructFlag stacksCopy = new ListWithAutoConstructFlag(stacks.size());
            stacksCopy.addAll(stacks);
            this.stacks = stacksCopy;
        }
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeStacksResult withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStacks() != null) {
            sb.append("Stacks: " + this.getStacks() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStacks() == null ? 0 : ((Object)this.getStacks()).hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResult)) {
            return false;
        }
        DescribeStacksResult other = (DescribeStacksResult)obj;
        if (other.getStacks() == null ^ this.getStacks() == null) {
            return false;
        }
        if (other.getStacks() != null && !((Object)other.getStacks()).equals(this.getStacks())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

