/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securitytoken;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceAsync;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import com.amazonaws.services.securitytoken.model.GetFederationTokenResult;
import com.amazonaws.services.securitytoken.model.GetSessionTokenRequest;
import com.amazonaws.services.securitytoken.model.GetSessionTokenResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSSecurityTokenServiceAsyncClient
extends AWSSecurityTokenServiceClient
implements AWSSecurityTokenServiceAsync {
    private ExecutorService executorService;

    public AWSSecurityTokenServiceAsyncClient() {
        this(new DefaultAWSCredentialsProviderChain());
    }

    public AWSSecurityTokenServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newCachedThreadPool());
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        super(awsCredentials);
        this.executorService = executorService;
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newCachedThreadPool());
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, new ClientConfiguration(), executorService);
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public AWSSecurityTokenServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(final GetSessionTokenRequest getSessionTokenRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.getSessionToken(getSessionTokenRequest);
            }
        });
    }

    @Override
    public Future<GetSessionTokenResult> getSessionTokenAsync(final GetSessionTokenRequest getSessionTokenRequest, final AsyncHandler<GetSessionTokenRequest, GetSessionTokenResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetSessionTokenResult>(){

            @Override
            public GetSessionTokenResult call() throws Exception {
                GetSessionTokenResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.getSessionToken(getSessionTokenRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getSessionTokenRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(final AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
            }
        });
    }

    @Override
    public Future<AssumeRoleWithWebIdentityResult> assumeRoleWithWebIdentityAsync(final AssumeRoleWithWebIdentityRequest assumeRoleWithWebIdentityRequest, final AsyncHandler<AssumeRoleWithWebIdentityRequest, AssumeRoleWithWebIdentityResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleWithWebIdentityResult>(){

            @Override
            public AssumeRoleWithWebIdentityResult call() throws Exception {
                AssumeRoleWithWebIdentityResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.assumeRoleWithWebIdentity(assumeRoleWithWebIdentityRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(assumeRoleWithWebIdentityRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(final GetFederationTokenRequest getFederationTokenRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.getFederationToken(getFederationTokenRequest);
            }
        });
    }

    @Override
    public Future<GetFederationTokenResult> getFederationTokenAsync(final GetFederationTokenRequest getFederationTokenRequest, final AsyncHandler<GetFederationTokenRequest, GetFederationTokenResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<GetFederationTokenResult>(){

            @Override
            public GetFederationTokenResult call() throws Exception {
                GetFederationTokenResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.getFederationToken(getFederationTokenRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getFederationTokenRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(final AssumeRoleRequest assumeRoleRequest) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                return AWSSecurityTokenServiceAsyncClient.this.assumeRole(assumeRoleRequest);
            }
        });
    }

    @Override
    public Future<AssumeRoleResult> assumeRoleAsync(final AssumeRoleRequest assumeRoleRequest, final AsyncHandler<AssumeRoleRequest, AssumeRoleResult> asyncHandler) throws AmazonServiceException, AmazonClientException {
        return this.executorService.submit(new Callable<AssumeRoleResult>(){

            @Override
            public AssumeRoleResult call() throws Exception {
                AssumeRoleResult result;
                try {
                    result = AWSSecurityTokenServiceAsyncClient.this.assumeRole(assumeRoleRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(assumeRoleRequest, result);
                return result;
            }
        });
    }
}

