/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.BSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.BUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGeneratedKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBHashKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIgnore;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBIndexRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMarshalling;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBRangeKey;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTable;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.datamodeling.NSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.NUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.SSUnmarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.SUnmarshaller;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.util.DateUtils;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamoDBReflector {
    private final Map<Class<?>, Collection<Method>> getterCache = new HashMap();
    private final Map<Class<?>, Method> hashKeyGetterCache = new HashMap();
    private final Map<Class<?>, Method> rangeKeyGetterCache = new HashMap();
    private final IndexKeyNameToIndexNamesCache indexKeyNameToIndexNamesCache = new IndexKeyNameToIndexNamesCache();
    private final Map<Method, Method> setterCache = new HashMap<Method, Method>();
    private final Map<Method, String> attributeNameCache = new HashMap<Method, String>();
    private final Map<Method, ArgumentUnmarshaller> argumentUnmarshallerCache = new HashMap<Method, ArgumentUnmarshaller>();
    private final Map<Method, ArgumentMarshaller> argumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, ArgumentMarshaller> versionArgumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, ArgumentMarshaller> keyArgumentMarshallerCache = new HashMap<Method, ArgumentMarshaller>();
    private final Map<Method, Boolean> versionAttributeGetterCache = new HashMap<Method, Boolean>();
    private final Map<Method, Boolean> autoGeneratedKeyGetterCache = new HashMap<Method, Boolean>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Method> getRelevantGetters(Class<?> clazz) {
        Map<Class<?>, Collection<Method>> map = this.getterCache;
        synchronized (map) {
            if (!this.getterCache.containsKey(clazz)) {
                LinkedList<Method> relevantGetters = new LinkedList<Method>();
                for (Method m : clazz.getMethods()) {
                    if (!this.isRelevantGetter(m)) continue;
                    relevantGetters.add(m);
                }
                this.getterCache.put(clazz, relevantGetters);
            }
        }
        return this.getterCache.get(clazz);
    }

    private boolean isRelevantGetter(Method m) {
        return (m.getName().startsWith("get") || m.getName().startsWith("is")) && m.getParameterTypes().length == 0 && m.getDeclaringClass().getAnnotation(DynamoDBTable.class) != null && !m.isAnnotationPresent(DynamoDBIgnore.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getRangeKeyGetter(Class<T> clazz) {
        Map<Class<?>, Method> map = this.rangeKeyGetterCache;
        synchronized (map) {
            if (!this.rangeKeyGetterCache.containsKey(clazz)) {
                Method rangeKeyMethod = null;
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
                    rangeKeyMethod = method;
                    break;
                }
                this.rangeKeyGetterCache.put(clazz, rangeKeyMethod);
            }
        }
        return this.rangeKeyGetterCache.get(clazz);
    }

    <T> Collection<Method> getKeyGetters(Class<T> clazz) {
        LinkedList<Method> keyGetters = new LinkedList<Method>();
        for (Method getter : this.getRelevantGetters(clazz)) {
            if (!getter.isAnnotationPresent(DynamoDBHashKey.class) && !getter.isAnnotationPresent(DynamoDBRangeKey.class)) continue;
            keyGetters.add(getter);
        }
        return keyGetters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Method getHashKeyGetter(Class<T> clazz) {
        Map<Class<?>, Method> map = this.hashKeyGetterCache;
        synchronized (map) {
            if (!this.hashKeyGetterCache.containsKey(clazz)) {
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(DynamoDBHashKey.class)) continue;
                    this.hashKeyGetterCache.put(clazz, method);
                    break;
                }
            }
        }
        Method hashKeyMethod = this.hashKeyGetterCache.get(clazz);
        if (hashKeyMethod == null) {
            throw new DynamoDBMappingException("Public, zero-parameter hash key property must be annotated with " + DynamoDBHashKey.class);
        }
        return hashKeyMethod;
    }

    <T> DynamoDBTable getTable(Class<T> clazz) {
        DynamoDBTable table = clazz.getAnnotation(DynamoDBTable.class);
        if (table == null) {
            throw new DynamoDBMappingException("Class " + clazz + " must be annotated with " + DynamoDBTable.class);
        }
        return table;
    }

    private boolean isCustomMarshaller(Method getter) {
        return getter.isAnnotationPresent(DynamoDBMarshalling.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> ArgumentUnmarshaller getArgumentUnmarshaller(final T toReturn, final Method getter, Method setter) {
        Map<Method, ArgumentUnmarshaller> map = this.argumentUnmarshallerCache;
        synchronized (map) {
            if (!this.argumentUnmarshallerCache.containsKey(getter)) {
                Class<?>[] parameterTypes = setter.getParameterTypes();
                Class paramType = parameterTypes[0];
                if (parameterTypes.length != 1) {
                    throw new DynamoDBMappingException("Expected exactly one agument to " + setter);
                }
                ArgumentUnmarshaller unmarshaller = null;
                if (this.isCustomMarshaller(getter)) {
                    unmarshaller = new SUnmarshaller(){

                        public Object unmarshall(AttributeValue value) {
                            return DynamoDBReflector.this.getCustomMarshalledValue(toReturn, getter, value);
                        }
                    };
                } else {
                    boolean isCollection = false;
                    if (Set.class.isAssignableFrom(paramType)) {
                        isCollection = true;
                        Type genericType = setter.getGenericParameterTypes()[0];
                        if (genericType instanceof ParameterizedType) {
                            paramType = ((ParameterizedType)genericType).getActualTypeArguments()[0].toString().equals("byte[]") ? byte[].class : (Class)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        }
                    } else if (Collection.class.isAssignableFrom(paramType)) {
                        throw new DynamoDBMappingException("Only java.util.Set collection types are permitted for " + DynamoDBAttribute.class);
                    }
                    if (Double.TYPE.isAssignableFrom(paramType) || Double.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Double> argument = new HashSet<Double>();
                                for (String s : value.getNS()) {
                                    argument.add(Double.parseDouble(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Double.parseDouble(value.getN());
                            }
                        };
                    } else if (BigDecimal.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<BigDecimal> argument = new HashSet<BigDecimal>();
                                for (String s : value.getNS()) {
                                    argument.add(new BigDecimal(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return new BigDecimal(value.getN());
                            }
                        };
                    } else if (BigInteger.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<BigInteger> argument = new HashSet<BigInteger>();
                                for (String s : value.getNS()) {
                                    argument.add(new BigInteger(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return new BigInteger(value.getN());
                            }
                        };
                    } else if (Integer.TYPE.isAssignableFrom(paramType) || Integer.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Integer> argument = new HashSet<Integer>();
                                for (String s : value.getNS()) {
                                    argument.add(Integer.parseInt(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Integer.parseInt(value.getN());
                            }
                        };
                    } else if (Float.TYPE.isAssignableFrom(paramType) || Float.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Float> argument = new HashSet<Float>();
                                for (String s : value.getNS()) {
                                    argument.add(Float.valueOf(Float.parseFloat(s)));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Float.valueOf(Float.parseFloat(value.getN()));
                            }
                        };
                    } else if (Byte.TYPE.isAssignableFrom(paramType) || Byte.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Byte> argument = new HashSet<Byte>();
                                for (String s : value.getNS()) {
                                    argument.add(Byte.parseByte(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Byte.parseByte(value.getN());
                            }
                        };
                    } else if (Long.TYPE.isAssignableFrom(paramType) || Long.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Long> argument = new HashSet<Long>();
                                for (String s : value.getNS()) {
                                    argument.add(Long.parseLong(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Long.parseLong(value.getN());
                            }
                        };
                    } else if (Short.TYPE.isAssignableFrom(paramType) || Short.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Short> argument = new HashSet<Short>();
                                for (String s : value.getNS()) {
                                    argument.add(Short.parseShort(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return Short.parseShort(value.getN());
                            }
                        };
                    } else if (Boolean.TYPE.isAssignableFrom(paramType) || Boolean.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new NSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<Boolean> argument = new HashSet<Boolean>();
                                for (String s : value.getNS()) {
                                    argument.add(DynamoDBReflector.this.parseBoolean(s));
                                }
                                return argument;
                            }
                        } : new NUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return DynamoDBReflector.this.parseBoolean(value.getN());
                            }
                        };
                    } else if (Date.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new SSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                HashSet<Date> argument = new HashSet<Date>();
                                for (String s : value.getSS()) {
                                    argument.add(new DateUtils().parseIso8601Date(s));
                                }
                                return argument;
                            }
                        } : new SUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                return new DateUtils().parseIso8601Date(value.getS());
                            }
                        };
                    } else if (Calendar.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new SSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                HashSet<Calendar> argument = new HashSet<Calendar>();
                                for (String s : value.getSS()) {
                                    Calendar cal = GregorianCalendar.getInstance();
                                    cal.setTime(new DateUtils().parseIso8601Date(s));
                                    argument.add(cal);
                                }
                                return argument;
                            }
                        } : new SUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                Calendar cal = GregorianCalendar.getInstance();
                                cal.setTime(new DateUtils().parseIso8601Date(value.getS()));
                                return cal;
                            }
                        };
                    } else if (ByteBuffer.class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new BSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                HashSet<ByteBuffer> argument = new HashSet<ByteBuffer>();
                                for (ByteBuffer b : value.getBS()) {
                                    argument.add(b);
                                }
                                return argument;
                            }
                        } : new BUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                return value.getB();
                            }
                        };
                    } else if (byte[].class.isAssignableFrom(paramType)) {
                        unmarshaller = isCollection ? new BSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                HashSet<byte[]> argument = new HashSet<byte[]>();
                                for (ByteBuffer b : value.getBS()) {
                                    byte[] bytes = null;
                                    if (b.hasArray()) {
                                        bytes = b.array();
                                    } else {
                                        bytes = new byte[b.limit()];
                                        b.get(bytes, 0, bytes.length);
                                    }
                                    argument.add(bytes);
                                }
                                return argument;
                            }
                        } : new BUnmarshaller(){

                            public Object unmarshall(AttributeValue value) throws ParseException {
                                ByteBuffer byteBuffer = value.getB();
                                byte[] bytes = null;
                                if (byteBuffer.hasArray()) {
                                    bytes = byteBuffer.array();
                                } else {
                                    bytes = new byte[byteBuffer.limit()];
                                    byteBuffer.get(bytes, 0, bytes.length);
                                }
                                return bytes;
                            }
                        };
                    } else {
                        if (!String.class.isAssignableFrom(paramType)) {
                            throw new DynamoDBMappingException("Expected a String, but was " + paramType);
                        }
                        unmarshaller = isCollection ? new SSUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                HashSet<String> argument = new HashSet<String>();
                                for (String s : value.getSS()) {
                                    argument.add(s);
                                }
                                return argument;
                            }
                        } : new SUnmarshaller(){

                            public Object unmarshall(AttributeValue value) {
                                return value.getS();
                            }
                        };
                    }
                }
                this.argumentUnmarshallerCache.put(getter, unmarshaller);
            }
        }
        return this.argumentUnmarshallerCache.get(getter);
    }

    private <T> T getCustomMarshalledValue(T toReturn, Method getter, AttributeValue value) {
        DynamoDBMarshaller<? extends Object> marshaller;
        DynamoDBMarshalling annotation = getter.getAnnotation(DynamoDBMarshalling.class);
        Class<? extends DynamoDBMarshaller<? extends Object>> marshallerClass = annotation.marshallerClass();
        try {
            marshaller = marshallerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Couldn't instantiate marshaller of class " + marshallerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Couldn't instantiate marshaller of class " + marshallerClass, e);
        }
        return (T)marshaller.unmarshall(getter.getReturnType(), value.getS());
    }

    private AttributeValue getCustomerMarshallerAttributeValue(Method getter, Object getterReturnResult) {
        DynamoDBMarshaller<? extends Object> marshaller;
        DynamoDBMarshalling annotation = getter.getAnnotation(DynamoDBMarshalling.class);
        Class<? extends DynamoDBMarshaller<? extends Object>> marshallerClass = annotation.marshallerClass();
        try {
            marshaller = marshallerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaller for class " + marshallerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new DynamoDBMappingException("Failed to instantiate custom marshaller for class " + marshallerClass, e);
        }
        String stringValue = marshaller.marshall(getterReturnResult);
        return new AttributeValue().withS(stringValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getArgumentMarshaller(final Method getter) {
        Map<Method, ArgumentMarshaller> map = this.argumentMarshallerCache;
        synchronized (map) {
            if (!this.argumentMarshallerCache.containsKey(getter)) {
                ArgumentMarshaller marshaller = null;
                if (this.isCustomMarshaller(getter)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            return DynamoDBReflector.this.getCustomerMarshallerAttributeValue(getter, obj);
                        }
                    };
                } else {
                    Class<?> returnType = getter.getReturnType();
                    if (Set.class.isAssignableFrom(returnType)) {
                        Type genericType = getter.getGenericReturnType();
                        if (genericType instanceof ParameterizedType) {
                            returnType = ((ParameterizedType)genericType).getActualTypeArguments()[0].toString().equals("byte[]") ? byte[].class : (Class<?>)((ParameterizedType)genericType).getActualTypeArguments()[0];
                        }
                        marshaller = Date.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                LinkedList<String> timestamps = new LinkedList<String>();
                                for (Object o : (Set)obj) {
                                    timestamps.add(new DateUtils().formatIso8601Date((Date)o));
                                }
                                return new AttributeValue().withSS(timestamps);
                            }
                        } : (Calendar.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                LinkedList<String> timestamps = new LinkedList<String>();
                                for (Object o : (Set)obj) {
                                    timestamps.add(new DateUtils().formatIso8601Date(((Calendar)o).getTime()));
                                }
                                return new AttributeValue().withSS(timestamps);
                            }
                        } : (Boolean.TYPE.isAssignableFrom(returnType) || Boolean.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                ArrayList<String> booleanAttributes = new ArrayList<String>();
                                for (Object b : (Set)obj) {
                                    if (b == null || !((Boolean)b).booleanValue()) {
                                        booleanAttributes.add("0");
                                        continue;
                                    }
                                    booleanAttributes.add("1");
                                }
                                return new AttributeValue().withNS(booleanAttributes);
                            }
                        } : (returnType.isPrimitive() || Number.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                ArrayList<String> attributes = new ArrayList<String>();
                                for (Object o : (Set)obj) {
                                    attributes.add(String.valueOf(o));
                                }
                                return new AttributeValue().withNS(attributes);
                            }
                        } : (ByteBuffer.class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                ArrayList<ByteBuffer> attributes = new ArrayList<ByteBuffer>();
                                for (Object o : (Set)obj) {
                                    attributes.add((ByteBuffer)o);
                                }
                                return new AttributeValue().withBS(attributes);
                            }
                        } : (byte[].class.isAssignableFrom(returnType) ? new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                ArrayList<ByteBuffer> attributes = new ArrayList<ByteBuffer>();
                                for (Object o : (Set)obj) {
                                    attributes.add(ByteBuffer.wrap((byte[])o));
                                }
                                return new AttributeValue().withBS(attributes);
                            }
                        } : new ArgumentMarshaller(){

                            public AttributeValue marshall(Object obj) {
                                ArrayList<String> attributes = new ArrayList<String>();
                                for (Object o : (Set)obj) {
                                    attributes.add(String.valueOf(o));
                                }
                                return new AttributeValue().withSS(attributes);
                            }
                        })))));
                    } else {
                        if (Collection.class.isAssignableFrom(returnType)) {
                            throw new DynamoDBMappingException("Non-set collections aren't supported: " + getter.getDeclaringClass() + "." + getter.getName());
                        }
                        if (Date.class.isAssignableFrom(returnType)) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    return new AttributeValue().withS(new DateUtils().formatIso8601Date((Date)obj));
                                }
                            };
                        } else if (Calendar.class.isAssignableFrom(returnType)) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    return new AttributeValue().withS(new DateUtils().formatIso8601Date(((Calendar)obj).getTime()));
                                }
                            };
                        } else if (Boolean.TYPE.isAssignableFrom(returnType) || Boolean.class.isAssignableFrom(returnType)) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    if (obj == null || !((Boolean)obj).booleanValue()) {
                                        return new AttributeValue().withN("0");
                                    }
                                    return new AttributeValue().withN("1");
                                }
                            };
                        } else if (returnType.isPrimitive() || Number.class.isAssignableFrom(returnType)) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    return new AttributeValue().withN(String.valueOf(obj));
                                }
                            };
                        } else if (returnType == String.class) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    if (((String)obj).length() == 0) {
                                        return null;
                                    }
                                    return new AttributeValue().withS(String.valueOf(obj));
                                }
                            };
                        } else if (returnType == ByteBuffer.class) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    return new AttributeValue().withB((ByteBuffer)obj);
                                }
                            };
                        } else if (returnType == byte[].class) {
                            marshaller = new ArgumentMarshaller(){

                                public AttributeValue marshall(Object obj) {
                                    return new AttributeValue().withB(ByteBuffer.wrap((byte[])obj));
                                }
                            };
                        } else {
                            throw new DynamoDBMappingException("Unsupported type: " + returnType + " for " + getter);
                        }
                    }
                }
                this.argumentMarshallerCache.put(getter, marshaller);
            }
        }
        return this.argumentMarshallerCache.get(getter);
    }

    private boolean parseBoolean(String s) {
        if ("1".equals(s)) {
            return true;
        }
        if ("0".equals(s)) {
            return false;
        }
        throw new IllegalArgumentException("Expected 1 or 0 for boolean value, was " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getAttributeName(Method getter) {
        Map<Method, String> map = this.attributeNameCache;
        synchronized (map) {
            if (!this.attributeNameCache.containsKey(getter)) {
                DynamoDBHashKey hashKeyAnnotation = getter.getAnnotation(DynamoDBHashKey.class);
                if (hashKeyAnnotation != null && hashKeyAnnotation.attributeName() != null && hashKeyAnnotation.attributeName().length() > 0) {
                    return hashKeyAnnotation.attributeName();
                }
                DynamoDBRangeKey rangeKey = getter.getAnnotation(DynamoDBRangeKey.class);
                if (rangeKey != null && rangeKey.attributeName() != null && rangeKey.attributeName().length() > 0) {
                    return rangeKey.attributeName();
                }
                DynamoDBIndexRangeKey indexRangeKey = getter.getAnnotation(DynamoDBIndexRangeKey.class);
                if (indexRangeKey != null && indexRangeKey.attributeName() != null && indexRangeKey.attributeName().length() > 0) {
                    return indexRangeKey.attributeName();
                }
                DynamoDBAttribute attribute = getter.getAnnotation(DynamoDBAttribute.class);
                if (attribute != null && attribute.attributeName() != null && attribute.attributeName().length() > 0) {
                    return attribute.attributeName();
                }
                DynamoDBVersionAttribute version = getter.getAnnotation(DynamoDBVersionAttribute.class);
                if (version != null && version.attributeName() != null && version.attributeName().length() > 0) {
                    return version.attributeName();
                }
                String attributeName = null;
                if (getter.getName().startsWith("get")) {
                    attributeName = getter.getName().substring("get".length());
                } else if (getter.getName().startsWith("is")) {
                    attributeName = getter.getName().substring("is".length());
                } else {
                    throw new DynamoDBMappingException("Getter must begin with 'get' or 'is'");
                }
                attributeName = attributeName.substring(0, 1).toLowerCase() + attributeName.substring(1);
                this.attributeNameCache.put(getter, attributeName);
            }
        }
        return this.attributeNameCache.get(getter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Method getSetter(Method getter) {
        Map<Method, Method> map = this.setterCache;
        synchronized (map) {
            if (!this.setterCache.containsKey(getter)) {
                String attributeName = null;
                if (getter.getName().startsWith("get")) {
                    attributeName = getter.getName().substring("get".length());
                } else if (getter.getName().startsWith("is")) {
                    attributeName = getter.getName().substring("is".length());
                } else {
                    throw new RuntimeException("Getter method must start with 'is' or 'get'");
                }
                String setterName = "set" + attributeName;
                Method setter = null;
                try {
                    setter = getter.getDeclaringClass().getMethod(setterName, getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    throw new DynamoDBMappingException("Expected a public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                catch (SecurityException e) {
                    throw new DynamoDBMappingException("No access to public, one-argument method called " + setterName + " on class " + getter.getDeclaringClass(), e);
                }
                this.setterCache.put(getter, setter);
            }
        }
        return this.setterCache.get(getter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getVersionedArgumentMarshaller(final Method getter, Object getterReturnResult) {
        Map<Method, ArgumentMarshaller> map = this.versionArgumentMarshallerCache;
        synchronized (map) {
            if (!this.versionArgumentMarshallerCache.containsKey(getter)) {
                ArgumentMarshaller marshaller = null;
                Class<?> returnType = getter.getReturnType();
                if (BigInteger.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = BigInteger.ZERO;
                            }
                            BigInteger newValue = ((BigInteger)obj).add(BigInteger.ONE);
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Integer.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Integer(0);
                            }
                            Integer newValue = (Integer)obj + 1;
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Byte.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Byte(0);
                            }
                            Byte newValue = (byte)(((Byte)obj + 1) % 127);
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else if (Long.class.isAssignableFrom(returnType)) {
                    marshaller = new ArgumentMarshaller(){

                        public AttributeValue marshall(Object obj) {
                            if (obj == null) {
                                obj = new Long(0L);
                            }
                            Long newValue = (Long)obj + 1L;
                            return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                        }
                    };
                } else {
                    throw new DynamoDBMappingException("Unsupported parameter type for " + DynamoDBVersionAttribute.class + ": " + returnType + ". Must be a whole-number type.");
                }
                this.versionArgumentMarshallerCache.put(getter, marshaller);
            }
        }
        return this.versionArgumentMarshallerCache.get(getter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArgumentMarshaller getAutoGeneratedKeyArgumentMarshaller(final Method getter) {
        Map<Method, ArgumentMarshaller> map = this.keyArgumentMarshallerCache;
        synchronized (map) {
            if (!this.keyArgumentMarshallerCache.containsKey(getter)) {
                ArgumentMarshaller marshaller = null;
                Class<?> returnType = getter.getReturnType();
                if (!String.class.isAssignableFrom(returnType)) {
                    throw new DynamoDBMappingException("Unsupported type for " + getter + ": " + returnType + ".  Only Strings are supported when auto-generating keys.");
                }
                marshaller = new ArgumentMarshaller(){

                    public AttributeValue marshall(Object obj) {
                        String newValue = UUID.randomUUID().toString();
                        return DynamoDBReflector.this.getArgumentMarshaller(getter).marshall(newValue);
                    }
                };
                this.keyArgumentMarshallerCache.put(getter, marshaller);
            }
        }
        return this.keyArgumentMarshallerCache.get(getter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionAttributeGetter(Method getter) {
        Map<Method, Boolean> map = this.versionAttributeGetterCache;
        synchronized (map) {
            if (!this.versionAttributeGetterCache.containsKey(getter)) {
                this.versionAttributeGetterCache.put(getter, getter.getName().startsWith("get") && getter.getParameterTypes().length == 0 && getter.isAnnotationPresent(DynamoDBVersionAttribute.class));
            }
        }
        return this.versionAttributeGetterCache.get(getter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAssignableKey(Method getter) {
        Map<Method, Boolean> map = this.autoGeneratedKeyGetterCache;
        synchronized (map) {
            if (!this.autoGeneratedKeyGetterCache.containsKey(getter)) {
                this.autoGeneratedKeyGetterCache.put(getter, getter.isAnnotationPresent(DynamoDBAutoGeneratedKey.class) && (getter.isAnnotationPresent(DynamoDBHashKey.class) || getter.isAnnotationPresent(DynamoDBRangeKey.class)));
            }
        }
        return this.autoGeneratedKeyGetterCache.get(getter);
    }

    String getPrimaryRangeKeyName(Class<?> clazz) {
        return this.getAttributeName(this.getRangeKeyGetter(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getIndexNameByIndexRangeKeyName(Class<?> clazz, String indexRangeKeyName) {
        IndexKeyNameToIndexNamesCache indexKeyNameToIndexNamesCache = this.indexKeyNameToIndexNamesCache;
        synchronized (indexKeyNameToIndexNamesCache) {
            if (!this.indexKeyNameToIndexNamesCache.isCached(clazz)) {
                HashMap<String, List<String>> indexKeyNameToIndexNamesMap = new HashMap<String, List<String>>();
                for (Method method : this.getRelevantGetters(clazz)) {
                    if (method.getParameterTypes().length != 0 || !method.isAnnotationPresent(DynamoDBIndexRangeKey.class)) continue;
                    DynamoDBIndexRangeKey indexRangeKeyAnnotation = method.getAnnotation(DynamoDBIndexRangeKey.class);
                    String localSecondaryIndexName = indexRangeKeyAnnotation.localSecondaryIndexName();
                    String[] localSecondaryIndexNames = indexRangeKeyAnnotation.localSecondaryIndexNames();
                    if (localSecondaryIndexName.length() != 0 && localSecondaryIndexNames.length != 0) {
                        throw new DynamoDBMappingException("@DynamoDBIndexRangeKey annotation on getter " + method + " contains both localSecondaryIndexName and localSecondaryIndexNames.");
                    }
                    if (localSecondaryIndexName.length() == 0 && localSecondaryIndexNames.length == 0) {
                        throw new DynamoDBMappingException("@DynamoDBIndexRangeKey annotation on getter " + method + " doesn't contain index name.");
                    }
                    String attributeName = this.getAttributeName(method);
                    if (localSecondaryIndexName.length() != 0) {
                        indexKeyNameToIndexNamesMap.put(attributeName, Collections.singletonList(localSecondaryIndexName));
                        continue;
                    }
                    indexKeyNameToIndexNamesMap.put(attributeName, Arrays.asList(localSecondaryIndexNames));
                }
                this.indexKeyNameToIndexNamesCache.cache(clazz, indexKeyNameToIndexNamesMap);
            }
        }
        return this.indexKeyNameToIndexNamesCache.getIndexNames(clazz, indexRangeKeyName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IndexKeyNameToIndexNamesCache {
        private Map<Class<?>, Map<String, List<String>>> cacheMap = new HashMap();

        private IndexKeyNameToIndexNamesCache() {
        }

        public boolean isCached(Class<?> clazz) {
            return this.cacheMap.containsKey(clazz);
        }

        public List<String> getIndexNames(Class<?> clazz, String indexKeyName) {
            return this.cacheMap.get(clazz).get(indexKeyName);
        }

        public Map<String, List<String>> cache(Class<?> clazz, Map<String, List<String>> indexKeyNameToIndexNamesMap) {
            return this.cacheMap.put(clazz, indexKeyNameToIndexNamesMap);
        }
    }
}

