/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeScalingActivitiesRequest
extends AmazonWebServiceRequest
implements Serializable {
    private List<String> activityIds;
    private String autoScalingGroupName;
    private Integer maxRecords;
    private String nextToken;

    public List<String> getActivityIds() {
        if (this.activityIds == null) {
            this.activityIds = new ArrayList<String>();
        }
        return this.activityIds;
    }

    public void setActivityIds(Collection<String> activityIds) {
        if (activityIds == null) {
            this.activityIds = null;
            return;
        }
        ArrayList<String> activityIdsCopy = new ArrayList<String>(activityIds.size());
        activityIdsCopy.addAll(activityIds);
        this.activityIds = activityIdsCopy;
    }

    public DescribeScalingActivitiesRequest withActivityIds(String ... activityIds) {
        if (this.getActivityIds() == null) {
            this.setActivityIds(new ArrayList<String>(activityIds.length));
        }
        for (String value : activityIds) {
            this.getActivityIds().add(value);
        }
        return this;
    }

    public DescribeScalingActivitiesRequest withActivityIds(Collection<String> activityIds) {
        if (activityIds == null) {
            this.activityIds = null;
        } else {
            ArrayList<String> activityIdsCopy = new ArrayList<String>(activityIds.size());
            activityIdsCopy.addAll(activityIds);
            this.activityIds = activityIdsCopy;
        }
        return this;
    }

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public DescribeScalingActivitiesRequest withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public Integer getMaxRecords() {
        return this.maxRecords;
    }

    public void setMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
    }

    public DescribeScalingActivitiesRequest withMaxRecords(Integer maxRecords) {
        this.maxRecords = maxRecords;
        return this;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public DescribeScalingActivitiesRequest withNextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getActivityIds() != null) {
            sb.append("ActivityIds: " + this.getActivityIds() + ",");
        }
        if (this.getAutoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: " + this.getAutoScalingGroupName() + ",");
        }
        if (this.getMaxRecords() != null) {
            sb.append("MaxRecords: " + this.getMaxRecords() + ",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: " + this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getActivityIds() == null ? 0 : ((Object)this.getActivityIds()).hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupName() == null ? 0 : this.getAutoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getMaxRecords() == null ? 0 : this.getMaxRecords().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest)obj;
        if (other.getActivityIds() == null ^ this.getActivityIds() == null) {
            return false;
        }
        if (other.getActivityIds() != null && !((Object)other.getActivityIds()).equals(this.getActivityIds())) {
            return false;
        }
        if (other.getAutoScalingGroupName() == null ^ this.getAutoScalingGroupName() == null) {
            return false;
        }
        if (other.getAutoScalingGroupName() != null && !other.getAutoScalingGroupName().equals(this.getAutoScalingGroupName())) {
            return false;
        }
        if (other.getMaxRecords() == null ^ this.getMaxRecords() == null) {
            return false;
        }
        if (other.getMaxRecords() != null && !other.getMaxRecords().equals(this.getMaxRecords())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }
}

