/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.services.elastictranscoder.model.Permission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineOutputConfig
implements Serializable {
    private String bucket;
    private String storageClass;
    private List<Permission> permissions;

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public PipelineOutputConfig withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public PipelineOutputConfig withStorageClass(String storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public List<Permission> getPermissions() {
        if (this.permissions == null) {
            this.permissions = new ArrayList<Permission>();
        }
        return this.permissions;
    }

    public void setPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        ArrayList<Permission> permissionsCopy = new ArrayList<Permission>(permissions.size());
        permissionsCopy.addAll(permissions);
        this.permissions = permissionsCopy;
    }

    public PipelineOutputConfig withPermissions(Permission ... permissions) {
        if (this.getPermissions() == null) {
            this.setPermissions(new ArrayList<Permission>(permissions.length));
        }
        for (Permission value : permissions) {
            this.getPermissions().add(value);
        }
        return this;
    }

    public PipelineOutputConfig withPermissions(Collection<Permission> permissions) {
        if (permissions == null) {
            this.permissions = null;
        } else {
            ArrayList<Permission> permissionsCopy = new ArrayList<Permission>(permissions.size());
            permissionsCopy.addAll(permissions);
            this.permissions = permissionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBucket() != null) {
            sb.append("Bucket: " + this.getBucket() + ",");
        }
        if (this.getStorageClass() != null) {
            sb.append("StorageClass: " + this.getStorageClass() + ",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: " + this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBucket() == null ? 0 : this.getBucket().hashCode());
        hashCode = 31 * hashCode + (this.getStorageClass() == null ? 0 : this.getStorageClass().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : ((Object)this.getPermissions()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineOutputConfig)) {
            return false;
        }
        PipelineOutputConfig other = (PipelineOutputConfig)obj;
        if (other.getBucket() == null ^ this.getBucket() == null) {
            return false;
        }
        if (other.getBucket() != null && !other.getBucket().equals(this.getBucket())) {
            return false;
        }
        if (other.getStorageClass() == null ^ this.getStorageClass() == null) {
            return false;
        }
        if (other.getStorageClass() != null && !other.getStorageClass().equals(this.getStorageClass())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || ((Object)other.getPermissions()).equals(this.getPermissions());
    }
}

