/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

public class DynamoDBMapperConfig {
    private final SaveBehavior saveBehavior;
    private final ConsistentReads consistentReads;
    private final TableNameOverride tableNameOverride;
    public static final DynamoDBMapperConfig DEFAULT = new DynamoDBMapperConfig(SaveBehavior.UPDATE, ConsistentReads.EVENTUAL, null);

    public DynamoDBMapperConfig(SaveBehavior saveBehavior, ConsistentReads consistentReads, TableNameOverride tableNameOverride) {
        this.saveBehavior = saveBehavior;
        this.consistentReads = consistentReads;
        this.tableNameOverride = tableNameOverride;
    }

    public DynamoDBMapperConfig(SaveBehavior saveBehavior) {
        this(saveBehavior, null, null);
    }

    public DynamoDBMapperConfig(ConsistentReads consistentReads) {
        this(null, consistentReads, null);
    }

    public DynamoDBMapperConfig(TableNameOverride tableNameOverride) {
        this(null, null, tableNameOverride);
    }

    DynamoDBMapperConfig(DynamoDBMapperConfig defaults, DynamoDBMapperConfig overrides) {
        if (overrides == null) {
            this.saveBehavior = defaults.getSaveBehavior();
            this.consistentReads = defaults.getConsistentReads();
            this.tableNameOverride = defaults.getTableNameOverride();
        } else {
            this.saveBehavior = overrides.getSaveBehavior() == null ? defaults.getSaveBehavior() : overrides.getSaveBehavior();
            this.consistentReads = overrides.getConsistentReads() == null ? defaults.getConsistentReads() : overrides.getConsistentReads();
            this.tableNameOverride = overrides.getTableNameOverride() == null ? defaults.getTableNameOverride() : overrides.getTableNameOverride();
        }
    }

    public SaveBehavior getSaveBehavior() {
        return this.saveBehavior;
    }

    public ConsistentReads getConsistentReads() {
        return this.consistentReads;
    }

    public TableNameOverride getTableNameOverride() {
        return this.tableNameOverride;
    }

    public static final class TableNameOverride {
        private final String tableNameOverride;

        public TableNameOverride(String tableNameOverride) {
            this.tableNameOverride = tableNameOverride;
        }

        public String getTableName() {
            return this.tableNameOverride;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConsistentReads {
        CONSISTENT,
        EVENTUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SaveBehavior {
        UPDATE,
        CLOBBER;

    }
}

