/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit.spring;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestBase;
import com.amazonaws.services.simpleworkflow.flow.junit.spring.SpringTestPOJOWorkflowImplementationGenericWorkflowClient;
import com.amazonaws.services.simpleworkflow.flow.spring.WorkflowScope;
import com.amazonaws.services.simpleworkflow.flow.test.TestDecisionContext;
import com.amazonaws.services.simpleworkflow.flow.test.TestPOJOActivityImplementationGenericActivityClient;
import com.amazonaws.services.simpleworkflow.flow.test.TestPOJOActivityImplementationWorker;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowContext;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWorkflowTest
extends WorkflowTestBase {
    private TestPOJOActivityImplementationGenericActivityClient activityClient;
    private SpringTestPOJOWorkflowImplementationGenericWorkflowClient workflowClient;
    private Map<String, TestPOJOActivityImplementationWorker> workers = new HashMap<String, TestPOJOActivityImplementationWorker>();
    private DataConverter dataConverter;

    public SpringWorkflowTest() {
        super(new TestDecisionContext(new TestPOJOActivityImplementationGenericActivityClient(), new SpringTestPOJOWorkflowImplementationGenericWorkflowClient(), new TestWorkflowClock(), new TestWorkflowContext()));
        this.activityClient = (TestPOJOActivityImplementationGenericActivityClient)this.decisionContext.getActivityClient();
        this.workflowClient = (SpringTestPOJOWorkflowImplementationGenericWorkflowClient)this.decisionContext.getWorkflowClient();
    }

    public void addActivitiesImplementation(Object activitiesImplementation) {
        this.addActivitiesImplementation(this.defaultActivitiesTaskListToPoll, activitiesImplementation);
    }

    public void addActivitiesImplementation(String taskList, Object activitiesImplementation) {
        try {
            TestPOJOActivityImplementationWorker worker = this.getActivityWorker(taskList);
            worker.addActivitiesImplementation(activitiesImplementation);
            this.activityClient.addWorker(worker);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid activities implementation: " + activitiesImplementation, e);
        }
    }

    private TestPOJOActivityImplementationWorker getActivityWorker(String taskList) {
        TestPOJOActivityImplementationWorker result = this.workers.get(taskList);
        if (result == null) {
            result = new TestPOJOActivityImplementationWorker(taskList);
            if (this.dataConverter != null) {
                result.setDataConverter(this.dataConverter);
            }
            this.workers.put(taskList, result);
        }
        return result;
    }

    public void setActivitiesImplementations(Iterable<Object> activityImplementationObjects) {
        this.workers.clear();
        this.addActivitiesImplementations(this.defaultActivitiesTaskListToPoll, activityImplementationObjects);
    }

    public void addActivitiesImplementations(String taskList, Iterable<Object> activityImplementationObjects) {
        try {
            TestPOJOActivityImplementationWorker worker = this.getActivityWorker(taskList);
            worker.setActivitiesImplementations(activityImplementationObjects);
            this.activityClient.addWorker(worker);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid activities implementation: " + activityImplementationObjects, e);
        }
    }

    public void setTaskListActivitiesImplementationMap(Map<String, Object> map) {
        this.workers.clear();
        for (Map.Entry<String, Object> taskImplPair : map.entrySet()) {
            this.addActivitiesImplementation(taskImplPair.getKey(), taskImplPair.getValue());
        }
    }

    public Map<String, Object> getTaskListActivitiesImplementationMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, TestPOJOActivityImplementationWorker> pair : this.workers.entrySet()) {
            Iterable<Object> implementations = pair.getValue().getActivitiesImplementations();
            for (Object impelementation : implementations) {
                result.put(pair.getKey(), impelementation);
            }
        }
        return result;
    }

    public Iterable<Object> getActivitiesImplementations() {
        TestPOJOActivityImplementationWorker worker = this.getActivityWorker(this.defaultActivitiesTaskListToPoll);
        return worker.getActivitiesImplementations();
    }

    public void setWorkflowImplementations(Iterable<Object> workflowImplementations) throws InstantiationException, IllegalAccessException {
        this.workflowClient.setWorkflowImplementations(workflowImplementations);
    }

    public Iterable<Object> getWorkflowImplementations() {
        return this.workflowClient.getWorkflowImplementations();
    }

    public void addWorkflowImplementation(Object workflowImplementation) throws InstantiationException, IllegalAccessException {
        this.workflowClient.addWorkflowImplementation(workflowImplementation);
    }

    public DataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(DataConverter converter) {
        this.dataConverter = converter;
        this.workflowClient.setDataConverter(converter);
    }

    public Iterable<WorkflowType> getWorkflowTypesToRegister() {
        return this.workflowClient.getWorkflowTypesToRegister();
    }

    @Override
    protected void beforeEvaluate(DecisionContext decisionContext) {
        WorkflowScope.setDecisionContext(decisionContext);
    }

    @Override
    protected void afterEvaluate() {
    }
}

