/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.elasticache.model.ParameterNameValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResetCacheParameterGroupRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String cacheParameterGroupName;
    private Boolean resetAllParameters;
    private List<ParameterNameValue> parameterNameValues;

    public ResetCacheParameterGroupRequest() {
    }

    public ResetCacheParameterGroupRequest(String cacheParameterGroupName, List<ParameterNameValue> parameterNameValues) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        this.parameterNameValues = parameterNameValues;
    }

    public String getCacheParameterGroupName() {
        return this.cacheParameterGroupName;
    }

    public void setCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
    }

    public ResetCacheParameterGroupRequest withCacheParameterGroupName(String cacheParameterGroupName) {
        this.cacheParameterGroupName = cacheParameterGroupName;
        return this;
    }

    public Boolean isResetAllParameters() {
        return this.resetAllParameters;
    }

    public void setResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
    }

    public ResetCacheParameterGroupRequest withResetAllParameters(Boolean resetAllParameters) {
        this.resetAllParameters = resetAllParameters;
        return this;
    }

    public Boolean getResetAllParameters() {
        return this.resetAllParameters;
    }

    public List<ParameterNameValue> getParameterNameValues() {
        if (this.parameterNameValues == null) {
            this.parameterNameValues = new ArrayList<ParameterNameValue>();
        }
        return this.parameterNameValues;
    }

    public void setParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        if (parameterNameValues == null) {
            this.parameterNameValues = null;
            return;
        }
        ArrayList<ParameterNameValue> parameterNameValuesCopy = new ArrayList<ParameterNameValue>(parameterNameValues.size());
        parameterNameValuesCopy.addAll(parameterNameValues);
        this.parameterNameValues = parameterNameValuesCopy;
    }

    public ResetCacheParameterGroupRequest withParameterNameValues(ParameterNameValue ... parameterNameValues) {
        if (this.getParameterNameValues() == null) {
            this.setParameterNameValues(new ArrayList<ParameterNameValue>(parameterNameValues.length));
        }
        for (ParameterNameValue value : parameterNameValues) {
            this.getParameterNameValues().add(value);
        }
        return this;
    }

    public ResetCacheParameterGroupRequest withParameterNameValues(Collection<ParameterNameValue> parameterNameValues) {
        if (parameterNameValues == null) {
            this.parameterNameValues = null;
        } else {
            ArrayList<ParameterNameValue> parameterNameValuesCopy = new ArrayList<ParameterNameValue>(parameterNameValues.size());
            parameterNameValuesCopy.addAll(parameterNameValues);
            this.parameterNameValues = parameterNameValuesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCacheParameterGroupName() != null) {
            sb.append("CacheParameterGroupName: " + this.getCacheParameterGroupName() + ", ");
        }
        if (this.isResetAllParameters() != null) {
            sb.append("ResetAllParameters: " + this.isResetAllParameters() + ", ");
        }
        if (this.getParameterNameValues() != null) {
            sb.append("ParameterNameValues: " + this.getParameterNameValues() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCacheParameterGroupName() == null ? 0 : this.getCacheParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.isResetAllParameters() == null ? 0 : this.isResetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.getParameterNameValues() == null ? 0 : ((Object)this.getParameterNameValues()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetCacheParameterGroupRequest)) {
            return false;
        }
        ResetCacheParameterGroupRequest other = (ResetCacheParameterGroupRequest)obj;
        if (other.getCacheParameterGroupName() == null ^ this.getCacheParameterGroupName() == null) {
            return false;
        }
        if (other.getCacheParameterGroupName() != null && !other.getCacheParameterGroupName().equals(this.getCacheParameterGroupName())) {
            return false;
        }
        if (other.isResetAllParameters() == null ^ this.isResetAllParameters() == null) {
            return false;
        }
        if (other.isResetAllParameters() != null && !other.isResetAllParameters().equals(this.isResetAllParameters())) {
            return false;
        }
        if (other.getParameterNameValues() == null ^ this.getParameterNameValues() == null) {
            return false;
        }
        return other.getParameterNameValues() == null || ((Object)other.getParameterNameValues()).equals(this.getParameterNameValues());
    }
}

