/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.common;

import com.amazonaws.services.simpleworkflow.model.PredefinedDuration;
import java.lang.reflect.Method;

public final class FlowHelpers {
    public static String secondsToDuration(Long seconds) {
        if (seconds == null || seconds == -1L) {
            return PredefinedDuration.NONE.toString();
        }
        if (seconds == -2L) {
            return null;
        }
        return Long.toString(seconds);
    }

    public static Object[] validateInput(Method method, Object[] args) {
        Class<?>[] paramterTypes = method.getParameterTypes();
        int numberOfParameters = paramterTypes.length;
        if (args == null || args.length != numberOfParameters) {
            throw new IllegalStateException("Number of parameters does not match args size.");
        }
        int index = 0;
        for (Class<?> paramType : paramterTypes) {
            Object argument = args[index];
            if (argument != null && !paramType.isAssignableFrom(argument.getClass())) {
                throw new IllegalStateException("Param type '" + paramType.getName() + "' is not assigable from '" + argument.getClass().getName() + "'.");
            }
            ++index;
        }
        return args;
    }
}

