/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodb.model.Condition;
import com.amazonaws.services.dynamodb.model.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanRequest
extends AmazonWebServiceRequest {
    private String tableName;
    private List<String> attributesToGet;
    private Integer limit;
    private Boolean count;
    private Map<String, Condition> scanFilter;
    private Key exclusiveStartKey;

    public ScanRequest() {
    }

    public ScanRequest(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public ScanRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        ArrayList<String> attributesToGetCopy = new ArrayList<String>(attributesToGet.size());
        attributesToGetCopy.addAll(attributesToGet);
        this.attributesToGet = attributesToGetCopy;
    }

    public ScanRequest withAttributesToGet(String ... attributesToGet) {
        if (this.getAttributesToGet() == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String value : attributesToGet) {
            this.getAttributesToGet().add(value);
        }
        return this;
    }

    public ScanRequest withAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
        } else {
            ArrayList<String> attributesToGetCopy = new ArrayList<String>(attributesToGet.size());
            attributesToGetCopy.addAll(attributesToGet);
            this.attributesToGet = attributesToGetCopy;
        }
        return this;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public ScanRequest withLimit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Boolean isCount() {
        return this.count;
    }

    public void setCount(Boolean count) {
        this.count = count;
    }

    public ScanRequest withCount(Boolean count) {
        this.count = count;
        return this;
    }

    public Boolean getCount() {
        return this.count;
    }

    public Map<String, Condition> getScanFilter() {
        return this.scanFilter;
    }

    public void setScanFilter(Map<String, Condition> scanFilter) {
        this.scanFilter = scanFilter;
    }

    public ScanRequest withScanFilter(Map<String, Condition> scanFilter) {
        this.setScanFilter(scanFilter);
        return this;
    }

    public Key getExclusiveStartKey() {
        return this.exclusiveStartKey;
    }

    public void setExclusiveStartKey(Key exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
    }

    public ScanRequest withExclusiveStartKey(Key exclusiveStartKey) {
        this.exclusiveStartKey = exclusiveStartKey;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ", ");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: " + this.getAttributesToGet() + ", ");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: " + this.getLimit() + ", ");
        }
        if (this.isCount() != null) {
            sb.append("Count: " + this.isCount() + ", ");
        }
        if (this.getScanFilter() != null) {
            sb.append("ScanFilter: " + this.getScanFilter() + ", ");
        }
        if (this.getExclusiveStartKey() != null) {
            sb.append("ExclusiveStartKey: " + this.getExclusiveStartKey() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : ((Object)this.getAttributesToGet()).hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.isCount() == null ? 0 : this.isCount().hashCode());
        hashCode = 31 * hashCode + (this.getScanFilter() == null ? 0 : ((Object)this.getScanFilter()).hashCode());
        hashCode = 31 * hashCode + (this.getExclusiveStartKey() == null ? 0 : this.getExclusiveStartKey().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanRequest)) {
            return false;
        }
        ScanRequest other = (ScanRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !((Object)other.getAttributesToGet()).equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.isCount() == null ^ this.isCount() == null) {
            return false;
        }
        if (other.isCount() != null && !other.isCount().equals(this.isCount())) {
            return false;
        }
        if (other.getScanFilter() == null ^ this.getScanFilter() == null) {
            return false;
        }
        if (other.getScanFilter() != null && !((Object)other.getScanFilter()).equals(this.getScanFilter())) {
            return false;
        }
        if (other.getExclusiveStartKey() == null ^ this.getExclusiveStartKey() == null) {
            return false;
        }
        return other.getExclusiveStartKey() == null || other.getExclusiveStartKey().equals(this.getExclusiveStartKey());
    }
}

