/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizeSecurityGroupIngressRequest
extends AmazonWebServiceRequest {
    private String groupName;
    private String groupId;
    private String sourceSecurityGroupName;
    private String sourceSecurityGroupOwnerId;
    private String ipProtocol;
    private Integer fromPort;
    private Integer toPort;
    private String cidrIp;
    private List<IpPermission> ipPermissions;

    public AuthorizeSecurityGroupIngressRequest() {
    }

    public AuthorizeSecurityGroupIngressRequest(String groupName, List<IpPermission> ipPermissions) {
        this.groupName = groupName;
        this.ipPermissions = ipPermissions;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public AuthorizeSecurityGroupIngressRequest withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public AuthorizeSecurityGroupIngressRequest withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public String getSourceSecurityGroupName() {
        return this.sourceSecurityGroupName;
    }

    public void setSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.sourceSecurityGroupName = sourceSecurityGroupName;
    }

    public AuthorizeSecurityGroupIngressRequest withSourceSecurityGroupName(String sourceSecurityGroupName) {
        this.sourceSecurityGroupName = sourceSecurityGroupName;
        return this;
    }

    public String getSourceSecurityGroupOwnerId() {
        return this.sourceSecurityGroupOwnerId;
    }

    public void setSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
    }

    public AuthorizeSecurityGroupIngressRequest withSourceSecurityGroupOwnerId(String sourceSecurityGroupOwnerId) {
        this.sourceSecurityGroupOwnerId = sourceSecurityGroupOwnerId;
        return this;
    }

    public String getIpProtocol() {
        return this.ipProtocol;
    }

    public void setIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
    }

    public AuthorizeSecurityGroupIngressRequest withIpProtocol(String ipProtocol) {
        this.ipProtocol = ipProtocol;
        return this;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public void setFromPort(Integer fromPort) {
        this.fromPort = fromPort;
    }

    public AuthorizeSecurityGroupIngressRequest withFromPort(Integer fromPort) {
        this.fromPort = fromPort;
        return this;
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public void setToPort(Integer toPort) {
        this.toPort = toPort;
    }

    public AuthorizeSecurityGroupIngressRequest withToPort(Integer toPort) {
        this.toPort = toPort;
        return this;
    }

    public String getCidrIp() {
        return this.cidrIp;
    }

    public void setCidrIp(String cidrIp) {
        this.cidrIp = cidrIp;
    }

    public AuthorizeSecurityGroupIngressRequest withCidrIp(String cidrIp) {
        this.cidrIp = cidrIp;
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new ArrayList<IpPermission>();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        ArrayList<IpPermission> ipPermissionsCopy = new ArrayList<IpPermission>(ipPermissions.size());
        ipPermissionsCopy.addAll(ipPermissions);
        this.ipPermissions = ipPermissionsCopy;
    }

    public AuthorizeSecurityGroupIngressRequest withIpPermissions(IpPermission ... ipPermissions) {
        if (this.getIpPermissions() == null) {
            this.setIpPermissions(new ArrayList<IpPermission>(ipPermissions.length));
        }
        for (IpPermission value : ipPermissions) {
            this.getIpPermissions().add(value);
        }
        return this;
    }

    public AuthorizeSecurityGroupIngressRequest withIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
        } else {
            ArrayList<IpPermission> ipPermissionsCopy = new ArrayList<IpPermission>(ipPermissions.size());
            ipPermissionsCopy.addAll(ipPermissions);
            this.ipPermissions = ipPermissionsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ", ");
        }
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId() + ", ");
        }
        if (this.getSourceSecurityGroupName() != null) {
            sb.append("SourceSecurityGroupName: " + this.getSourceSecurityGroupName() + ", ");
        }
        if (this.getSourceSecurityGroupOwnerId() != null) {
            sb.append("SourceSecurityGroupOwnerId: " + this.getSourceSecurityGroupOwnerId() + ", ");
        }
        if (this.getIpProtocol() != null) {
            sb.append("IpProtocol: " + this.getIpProtocol() + ", ");
        }
        if (this.getFromPort() != null) {
            sb.append("FromPort: " + this.getFromPort() + ", ");
        }
        if (this.getToPort() != null) {
            sb.append("ToPort: " + this.getToPort() + ", ");
        }
        if (this.getCidrIp() != null) {
            sb.append("CidrIp: " + this.getCidrIp() + ", ");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: " + this.getIpPermissions() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupName() == null ? 0 : this.getSourceSecurityGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSecurityGroupOwnerId() == null ? 0 : this.getSourceSecurityGroupOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getIpProtocol() == null ? 0 : this.getIpProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getFromPort() == null ? 0 : this.getFromPort().hashCode());
        hashCode = 31 * hashCode + (this.getToPort() == null ? 0 : this.getToPort().hashCode());
        hashCode = 31 * hashCode + (this.getCidrIp() == null ? 0 : this.getCidrIp().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : ((Object)this.getIpPermissions()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSecurityGroupIngressRequest)) {
            return false;
        }
        AuthorizeSecurityGroupIngressRequest other = (AuthorizeSecurityGroupIngressRequest)obj;
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getSourceSecurityGroupName() == null ^ this.getSourceSecurityGroupName() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupName() != null && !other.getSourceSecurityGroupName().equals(this.getSourceSecurityGroupName())) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() == null ^ this.getSourceSecurityGroupOwnerId() == null) {
            return false;
        }
        if (other.getSourceSecurityGroupOwnerId() != null && !other.getSourceSecurityGroupOwnerId().equals(this.getSourceSecurityGroupOwnerId())) {
            return false;
        }
        if (other.getIpProtocol() == null ^ this.getIpProtocol() == null) {
            return false;
        }
        if (other.getIpProtocol() != null && !other.getIpProtocol().equals(this.getIpProtocol())) {
            return false;
        }
        if (other.getFromPort() == null ^ this.getFromPort() == null) {
            return false;
        }
        if (other.getFromPort() != null && !other.getFromPort().equals(this.getFromPort())) {
            return false;
        }
        if (other.getToPort() == null ^ this.getToPort() == null) {
            return false;
        }
        if (other.getToPort() != null && !other.getToPort().equals(this.getToPort())) {
            return false;
        }
        if (other.getCidrIp() == null ^ this.getCidrIp() == null) {
            return false;
        }
        if (other.getCidrIp() != null && !other.getCidrIp().equals(this.getCidrIp())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        return other.getIpPermissions() == null || ((Object)other.getIpPermissions()).equals(this.getIpPermissions());
    }
}

