/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.Aliases;
import com.amazonaws.services.cloudfront.model.CacheBehavior;
import com.amazonaws.services.cloudfront.model.CacheBehaviors;
import com.amazonaws.services.cloudfront.model.CustomOriginConfig;
import com.amazonaws.services.cloudfront.model.DefaultCacheBehavior;
import com.amazonaws.services.cloudfront.model.DistributionConfig;
import com.amazonaws.services.cloudfront.model.ForwardedValues;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.Origins;
import com.amazonaws.services.cloudfront.model.S3OriginConfig;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import com.amazonaws.services.cloudfront.model.UpdateDistributionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateDistributionRequestMarshaller
implements Marshaller<Request<UpdateDistributionRequest>, UpdateDistributionRequest> {
    @Override
    public Request<UpdateDistributionRequest> marshall(UpdateDistributionRequest updateDistributionRequest) {
        DistributionConfig distributionConfigDistributionConfig;
        if (updateDistributionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateDistributionRequest> request = new DefaultRequest<UpdateDistributionRequest>(updateDistributionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateDistributionRequest.getIfMatch() != null) {
            request.addHeader("If-Match", updateDistributionRequest.getIfMatch());
        }
        String uriResourcePath = "2012-05-05/distribution/{Id}/config";
        if ((uriResourcePath = uriResourcePath.replace("{Id}", this.getString(updateDistributionRequest.getId()))).contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter(stringWriter, "http://cloudfront.amazonaws.com/doc/2012-05-05/");
        if (updateDistributionRequest != null && (distributionConfigDistributionConfig = updateDistributionRequest.getDistributionConfig()) != null) {
            LoggingConfig loggingConfigLogging;
            CacheBehaviors cacheBehaviorsCacheBehaviors;
            DefaultCacheBehavior defaultCacheBehaviorDefaultCacheBehavior;
            Origins originsOrigins;
            Aliases aliasesAliases;
            xmlWriter.startElement("DistributionConfig");
            if (distributionConfigDistributionConfig.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(distributionConfigDistributionConfig.getCallerReference()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (aliasesAliases = distributionConfigDistributionConfig.getAliases()) != null) {
                List<String> aliasesAliasesitemsList;
                xmlWriter.startElement("Aliases");
                if (aliasesAliases.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(aliasesAliases.getQuantity()).endElement();
                }
                if (aliasesAliases != null && (aliasesAliasesitemsList = aliasesAliases.getItems()) != null && aliasesAliasesitemsList.size() > 0) {
                    int aliasesAliasesitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (String aliasesAliasesitemsListValue : aliasesAliasesitemsList) {
                        xmlWriter.startElement("CNAME");
                        xmlWriter.value(aliasesAliasesitemsListValue);
                        xmlWriter.endElement();
                        ++aliasesAliasesitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getDefaultRootObject() != null) {
                xmlWriter.startElement("DefaultRootObject").value(distributionConfigDistributionConfig.getDefaultRootObject()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (originsOrigins = distributionConfigDistributionConfig.getOrigins()) != null) {
                List<Origin> originsOriginsitemsList;
                xmlWriter.startElement("Origins");
                if (originsOrigins.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(originsOrigins.getQuantity()).endElement();
                }
                if (originsOrigins != null && (originsOriginsitemsList = originsOrigins.getItems()) != null && originsOriginsitemsList.size() > 0) {
                    int originsOriginsitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (Origin originsOriginsitemsListValue : originsOriginsitemsList) {
                        CustomOriginConfig customOriginConfigCustomOriginConfig;
                        S3OriginConfig s3OriginConfigS3OriginConfig;
                        xmlWriter.startElement("Origin");
                        if (originsOriginsitemsListValue.getId() != null) {
                            xmlWriter.startElement("Id").value(originsOriginsitemsListValue.getId()).endElement();
                        }
                        if (originsOriginsitemsListValue.getDomainName() != null) {
                            xmlWriter.startElement("DomainName").value(originsOriginsitemsListValue.getDomainName()).endElement();
                        }
                        if (originsOriginsitemsListValue != null && (s3OriginConfigS3OriginConfig = originsOriginsitemsListValue.getS3OriginConfig()) != null) {
                            xmlWriter.startElement("S3OriginConfig");
                            if (s3OriginConfigS3OriginConfig.getOriginAccessIdentity() != null) {
                                xmlWriter.startElement("OriginAccessIdentity").value(s3OriginConfigS3OriginConfig.getOriginAccessIdentity()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (originsOriginsitemsListValue != null && (customOriginConfigCustomOriginConfig = originsOriginsitemsListValue.getCustomOriginConfig()) != null) {
                            xmlWriter.startElement("CustomOriginConfig");
                            if (customOriginConfigCustomOriginConfig.getHTTPPort() != null) {
                                xmlWriter.startElement("HTTPPort").value(customOriginConfigCustomOriginConfig.getHTTPPort()).endElement();
                            }
                            if (customOriginConfigCustomOriginConfig.getHTTPSPort() != null) {
                                xmlWriter.startElement("HTTPSPort").value(customOriginConfigCustomOriginConfig.getHTTPSPort()).endElement();
                            }
                            if (customOriginConfigCustomOriginConfig.getOriginProtocolPolicy() != null) {
                                xmlWriter.startElement("OriginProtocolPolicy").value(customOriginConfigCustomOriginConfig.getOriginProtocolPolicy()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                        ++originsOriginsitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (defaultCacheBehaviorDefaultCacheBehavior = distributionConfigDistributionConfig.getDefaultCacheBehavior()) != null) {
                TrustedSigners trustedSignersTrustedSigners;
                ForwardedValues forwardedValuesForwardedValues;
                xmlWriter.startElement("DefaultCacheBehavior");
                if (defaultCacheBehaviorDefaultCacheBehavior.getTargetOriginId() != null) {
                    xmlWriter.startElement("TargetOriginId").value(defaultCacheBehaviorDefaultCacheBehavior.getTargetOriginId()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior != null && (forwardedValuesForwardedValues = defaultCacheBehaviorDefaultCacheBehavior.getForwardedValues()) != null) {
                    xmlWriter.startElement("ForwardedValues");
                    if (forwardedValuesForwardedValues.isQueryString() != null) {
                        xmlWriter.startElement("QueryString").value(forwardedValuesForwardedValues.isQueryString()).endElement();
                    }
                    xmlWriter.endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior != null && (trustedSignersTrustedSigners = defaultCacheBehaviorDefaultCacheBehavior.getTrustedSigners()) != null) {
                    List<String> trustedSignersTrustedSignersitemsList;
                    xmlWriter.startElement("TrustedSigners");
                    if (trustedSignersTrustedSigners.isEnabled() != null) {
                        xmlWriter.startElement("Enabled").value(trustedSignersTrustedSigners.isEnabled()).endElement();
                    }
                    if (trustedSignersTrustedSigners.getQuantity() != null) {
                        xmlWriter.startElement("Quantity").value(trustedSignersTrustedSigners.getQuantity()).endElement();
                    }
                    if (trustedSignersTrustedSigners != null && (trustedSignersTrustedSignersitemsList = trustedSignersTrustedSigners.getItems()) != null && trustedSignersTrustedSignersitemsList.size() > 0) {
                        int trustedSignersTrustedSignersitemsListIndex = 1;
                        xmlWriter.startElement("Items");
                        for (String trustedSignersTrustedSignersitemsListValue : trustedSignersTrustedSignersitemsList) {
                            xmlWriter.startElement("AwsAccountNumber");
                            xmlWriter.value(trustedSignersTrustedSignersitemsListValue);
                            xmlWriter.endElement();
                            ++trustedSignersTrustedSignersitemsListIndex;
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getViewerProtocolPolicy() != null) {
                    xmlWriter.startElement("ViewerProtocolPolicy").value(defaultCacheBehaviorDefaultCacheBehavior.getViewerProtocolPolicy()).endElement();
                }
                if (defaultCacheBehaviorDefaultCacheBehavior.getMinTTL() != null) {
                    xmlWriter.startElement("MinTTL").value(defaultCacheBehaviorDefaultCacheBehavior.getMinTTL()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig != null && (cacheBehaviorsCacheBehaviors = distributionConfigDistributionConfig.getCacheBehaviors()) != null) {
                List<CacheBehavior> cacheBehaviorsCacheBehaviorsitemsList;
                xmlWriter.startElement("CacheBehaviors");
                if (cacheBehaviorsCacheBehaviors.getQuantity() != null) {
                    xmlWriter.startElement("Quantity").value(cacheBehaviorsCacheBehaviors.getQuantity()).endElement();
                }
                if (cacheBehaviorsCacheBehaviors != null && (cacheBehaviorsCacheBehaviorsitemsList = cacheBehaviorsCacheBehaviors.getItems()) != null && cacheBehaviorsCacheBehaviorsitemsList.size() > 0) {
                    int cacheBehaviorsCacheBehaviorsitemsListIndex = 1;
                    xmlWriter.startElement("Items");
                    for (CacheBehavior cacheBehaviorsCacheBehaviorsitemsListValue : cacheBehaviorsCacheBehaviorsitemsList) {
                        TrustedSigners trustedSignersTrustedSigners;
                        ForwardedValues forwardedValuesForwardedValues;
                        xmlWriter.startElement("CacheBehavior");
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getPathPattern() != null) {
                            xmlWriter.startElement("PathPattern").value(cacheBehaviorsCacheBehaviorsitemsListValue.getPathPattern()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getTargetOriginId() != null) {
                            xmlWriter.startElement("TargetOriginId").value(cacheBehaviorsCacheBehaviorsitemsListValue.getTargetOriginId()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue != null && (forwardedValuesForwardedValues = cacheBehaviorsCacheBehaviorsitemsListValue.getForwardedValues()) != null) {
                            xmlWriter.startElement("ForwardedValues");
                            if (forwardedValuesForwardedValues.isQueryString() != null) {
                                xmlWriter.startElement("QueryString").value(forwardedValuesForwardedValues.isQueryString()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue != null && (trustedSignersTrustedSigners = cacheBehaviorsCacheBehaviorsitemsListValue.getTrustedSigners()) != null) {
                            List<String> trustedSignersTrustedSignersitemsList;
                            xmlWriter.startElement("TrustedSigners");
                            if (trustedSignersTrustedSigners.isEnabled() != null) {
                                xmlWriter.startElement("Enabled").value(trustedSignersTrustedSigners.isEnabled()).endElement();
                            }
                            if (trustedSignersTrustedSigners.getQuantity() != null) {
                                xmlWriter.startElement("Quantity").value(trustedSignersTrustedSigners.getQuantity()).endElement();
                            }
                            if (trustedSignersTrustedSigners != null && (trustedSignersTrustedSignersitemsList = trustedSignersTrustedSigners.getItems()) != null && trustedSignersTrustedSignersitemsList.size() > 0) {
                                int trustedSignersTrustedSignersitemsListIndex = 1;
                                xmlWriter.startElement("Items");
                                for (String trustedSignersTrustedSignersitemsListValue : trustedSignersTrustedSignersitemsList) {
                                    xmlWriter.startElement("AwsAccountNumber");
                                    xmlWriter.value(trustedSignersTrustedSignersitemsListValue);
                                    xmlWriter.endElement();
                                    ++trustedSignersTrustedSignersitemsListIndex;
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getViewerProtocolPolicy() != null) {
                            xmlWriter.startElement("ViewerProtocolPolicy").value(cacheBehaviorsCacheBehaviorsitemsListValue.getViewerProtocolPolicy()).endElement();
                        }
                        if (cacheBehaviorsCacheBehaviorsitemsListValue.getMinTTL() != null) {
                            xmlWriter.startElement("MinTTL").value(cacheBehaviorsCacheBehaviorsitemsListValue.getMinTTL()).endElement();
                        }
                        xmlWriter.endElement();
                        ++cacheBehaviorsCacheBehaviorsitemsListIndex;
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.getComment() != null) {
                xmlWriter.startElement("Comment").value(distributionConfigDistributionConfig.getComment()).endElement();
            }
            if (distributionConfigDistributionConfig != null && (loggingConfigLogging = distributionConfigDistributionConfig.getLogging()) != null) {
                xmlWriter.startElement("Logging");
                if (loggingConfigLogging.isEnabled() != null) {
                    xmlWriter.startElement("Enabled").value(loggingConfigLogging.isEnabled()).endElement();
                }
                if (loggingConfigLogging.getBucket() != null) {
                    xmlWriter.startElement("Bucket").value(loggingConfigLogging.getBucket()).endElement();
                }
                if (loggingConfigLogging.getPrefix() != null) {
                    xmlWriter.startElement("Prefix").value(loggingConfigLogging.getPrefix()).endElement();
                }
                xmlWriter.endElement();
            }
            if (distributionConfigDistributionConfig.isEnabled() != null) {
                xmlWriter.startElement("Enabled").value(distributionConfigDistributionConfig.isEnabled()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

