/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.dynamodb.model.CreateTableRequest;
import com.amazonaws.services.dynamodb.model.KeySchema;
import com.amazonaws.services.dynamodb.model.KeySchemaElement;
import com.amazonaws.services.dynamodb.model.ProvisionedThroughput;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableRequestMarshaller
implements Marshaller<Request<CreateTableRequest>, CreateTableRequest> {
    @Override
    public Request<CreateTableRequest> marshall(CreateTableRequest createTableRequest) {
        if (createTableRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTableRequest> request = new DefaultRequest<CreateTableRequest>(createTableRequest, "AmazonDynamoDB");
        String target = "DynamoDB_20111205.CreateTable";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            ProvisionedThroughput provisionedThroughputProvisionedThroughput;
            KeySchema keySchemaKeySchema;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createTableRequest.getTableName() != null) {
                jsonWriter.key("TableName").value(createTableRequest.getTableName());
            }
            if (createTableRequest != null && (keySchemaKeySchema = createTableRequest.getKeySchema()) != null) {
                KeySchemaElement keySchemaElementRangeKeyElement;
                KeySchemaElement keySchemaElementHashKeyElement;
                jsonWriter.key("KeySchema").object();
                if (keySchemaKeySchema != null && (keySchemaElementHashKeyElement = keySchemaKeySchema.getHashKeyElement()) != null) {
                    jsonWriter.key("HashKeyElement").object();
                    if (keySchemaElementHashKeyElement.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value(keySchemaElementHashKeyElement.getAttributeName());
                    }
                    if (keySchemaElementHashKeyElement.getAttributeType() != null) {
                        jsonWriter.key("AttributeType").value(keySchemaElementHashKeyElement.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                if (keySchemaKeySchema != null && (keySchemaElementRangeKeyElement = keySchemaKeySchema.getRangeKeyElement()) != null) {
                    jsonWriter.key("RangeKeyElement").object();
                    if (keySchemaElementRangeKeyElement.getAttributeName() != null) {
                        jsonWriter.key("AttributeName").value(keySchemaElementRangeKeyElement.getAttributeName());
                    }
                    if (keySchemaElementRangeKeyElement.getAttributeType() != null) {
                        jsonWriter.key("AttributeType").value(keySchemaElementRangeKeyElement.getAttributeType());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (createTableRequest != null && (provisionedThroughputProvisionedThroughput = createTableRequest.getProvisionedThroughput()) != null) {
                jsonWriter.key("ProvisionedThroughput").object();
                if (provisionedThroughputProvisionedThroughput.getReadCapacityUnits() != null) {
                    jsonWriter.key("ReadCapacityUnits").value(provisionedThroughputProvisionedThroughput.getReadCapacityUnits());
                }
                if (provisionedThroughputProvisionedThroughput.getWriteCapacityUnits() != null) {
                    jsonWriter.key("WriteCapacityUnits").value(provisionedThroughputProvisionedThroughput.getWriteCapacityUnits());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

