/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterImageRequest
extends AmazonWebServiceRequest {
    private String imageLocation;
    private String name;
    private String description;
    private String architecture;
    private String kernelId;
    private String ramdiskId;
    private String rootDeviceName;
    private List<BlockDeviceMapping> blockDeviceMappings;

    public RegisterImageRequest() {
    }

    public RegisterImageRequest(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public RegisterImageRequest withImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RegisterImageRequest withName(String name) {
        this.name = name;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RegisterImageRequest withDescription(String description) {
        this.description = description;
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public RegisterImageRequest withArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public RegisterImageRequest withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public RegisterImageRequest withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public RegisterImageRequest withRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public RegisterImageRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>());
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public RegisterImageRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ImageLocation: " + this.imageLocation + ", ");
        sb.append("Name: " + this.name + ", ");
        sb.append("Description: " + this.description + ", ");
        sb.append("Architecture: " + this.architecture + ", ");
        sb.append("KernelId: " + this.kernelId + ", ");
        sb.append("RamdiskId: " + this.ramdiskId + ", ");
        sb.append("RootDeviceName: " + this.rootDeviceName + ", ");
        sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        sb.append("}");
        return sb.toString();
    }
}

