/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    @Override
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        DefaultRequest<ModifySnapshotAttributeRequest> request = new DefaultRequest<ModifySnapshotAttributeRequest>(modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2011-05-15");
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifySnapshotAttributeRequest.getOperationType()));
        }
        if (modifySnapshotAttributeRequest != null) {
            List<String> userIdsList = modifySnapshotAttributeRequest.getUserIds();
            int userIdsListIndex = 1;
            for (String userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString(userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (modifySnapshotAttributeRequest != null) {
            List<String> groupNamesList = modifySnapshotAttributeRequest.getGroupNames();
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString(groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (modifySnapshotAttributeRequest != null) {
            CreateVolumePermissionModifications createVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission();
            if (createVolumePermission != null) {
                List<CreateVolumePermission> addList = createVolumePermission.getAdd();
                int addListIndex = 1;
                for (CreateVolumePermission addListValue : addList) {
                    if (addListValue != null && addListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString(addListValue.getUserId()));
                    }
                    if (addListValue != null && addListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString(addListValue.getGroup()));
                    }
                    ++addListIndex;
                }
            }
            if (createVolumePermission != null) {
                List<CreateVolumePermission> removeList = createVolumePermission.getRemove();
                int removeListIndex = 1;
                for (CreateVolumePermission removeListValue : removeList) {
                    if (removeListValue != null && removeListValue.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString(removeListValue.getUserId()));
                    }
                    if (removeListValue != null && removeListValue.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString(removeListValue.getGroup()));
                    }
                    ++removeListIndex;
                }
            }
        }
        return request;
    }
}

