/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.services.elasticmapreduce.model.InstanceGroupDetail;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobFlowInstancesDetail {
    private String masterInstanceType;
    private String masterPublicDnsName;
    private String masterInstanceId;
    private String slaveInstanceType;
    private Integer instanceCount;
    private List<InstanceGroupDetail> instanceGroups;
    private Integer normalizedInstanceHours;
    private String ec2KeyName;
    private String ec2SubnetId;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;

    public JobFlowInstancesDetail() {
    }

    public JobFlowInstancesDetail(String masterInstanceType, String slaveInstanceType, Integer instanceCount) {
        this.masterInstanceType = masterInstanceType;
        this.slaveInstanceType = slaveInstanceType;
        this.instanceCount = instanceCount;
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public JobFlowInstancesDetail withMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
        return this;
    }

    public String getMasterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public void setMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
    }

    public JobFlowInstancesDetail withMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
        return this;
    }

    public String getMasterInstanceId() {
        return this.masterInstanceId;
    }

    public void setMasterInstanceId(String masterInstanceId) {
        this.masterInstanceId = masterInstanceId;
    }

    public JobFlowInstancesDetail withMasterInstanceId(String masterInstanceId) {
        this.masterInstanceId = masterInstanceId;
        return this;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public JobFlowInstancesDetail withSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public JobFlowInstancesDetail withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public List<InstanceGroupDetail> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ArrayList<InstanceGroupDetail>();
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        ArrayList<InstanceGroupDetail> instanceGroupsCopy = new ArrayList<InstanceGroupDetail>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
    }

    public JobFlowInstancesDetail withInstanceGroups(InstanceGroupDetail ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupDetail>());
        }
        for (InstanceGroupDetail value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public JobFlowInstancesDetail withInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        ArrayList<InstanceGroupDetail> instanceGroupsCopy = new ArrayList<InstanceGroupDetail>();
        if (instanceGroups != null) {
            instanceGroupsCopy.addAll(instanceGroups);
        }
        this.instanceGroups = instanceGroupsCopy;
        return this;
    }

    public Integer getNormalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
    }

    public JobFlowInstancesDetail withNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
        return this;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public JobFlowInstancesDetail withEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
        return this;
    }

    public String getEc2SubnetId() {
        return this.ec2SubnetId;
    }

    public void setEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
    }

    public JobFlowInstancesDetail withEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
        return this;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public JobFlowInstancesDetail withPlacement(PlacementType placement) {
        this.placement = placement;
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesDetail withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        return this;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public JobFlowInstancesDetail withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public JobFlowInstancesDetail withHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("MasterInstanceType: " + this.masterInstanceType + ", ");
        sb.append("MasterPublicDnsName: " + this.masterPublicDnsName + ", ");
        sb.append("MasterInstanceId: " + this.masterInstanceId + ", ");
        sb.append("SlaveInstanceType: " + this.slaveInstanceType + ", ");
        sb.append("InstanceCount: " + this.instanceCount + ", ");
        sb.append("InstanceGroups: " + this.instanceGroups + ", ");
        sb.append("NormalizedInstanceHours: " + this.normalizedInstanceHours + ", ");
        sb.append("Ec2KeyName: " + this.ec2KeyName + ", ");
        sb.append("Ec2SubnetId: " + this.ec2SubnetId + ", ");
        sb.append("Placement: " + this.placement + ", ");
        sb.append("KeepJobFlowAliveWhenNoSteps: " + this.keepJobFlowAliveWhenNoSteps + ", ");
        sb.append("TerminationProtected: " + this.terminationProtected + ", ");
        sb.append("HadoopVersion: " + this.hadoopVersion + ", ");
        sb.append("}");
        return sb.toString();
    }
}

