/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model;

import com.amazonaws.services.autoscaling.model.EnabledMetric;
import com.amazonaws.services.autoscaling.model.Instance;
import com.amazonaws.services.autoscaling.model.SuspendedProcess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoScalingGroup {
    private String autoScalingGroupName;
    private String autoScalingGroupARN;
    private String launchConfigurationName;
    private Integer minSize;
    private Integer maxSize;
    private Integer desiredCapacity;
    private Integer defaultCooldown;
    private List<String> availabilityZones;
    private List<String> loadBalancerNames;
    private String healthCheckType;
    private Integer healthCheckGracePeriod;
    private List<Instance> instances;
    private Date createdTime;
    private List<SuspendedProcess> suspendedProcesses;
    private String placementGroup;
    private String vPCZoneIdentifier;
    private List<EnabledMetric> enabledMetrics;
    private String status;

    public String getAutoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public void setAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
    }

    public AutoScalingGroup withAutoScalingGroupName(String autoScalingGroupName) {
        this.autoScalingGroupName = autoScalingGroupName;
        return this;
    }

    public String getAutoScalingGroupARN() {
        return this.autoScalingGroupARN;
    }

    public void setAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
    }

    public AutoScalingGroup withAutoScalingGroupARN(String autoScalingGroupARN) {
        this.autoScalingGroupARN = autoScalingGroupARN;
        return this;
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
    }

    public AutoScalingGroup withLaunchConfigurationName(String launchConfigurationName) {
        this.launchConfigurationName = launchConfigurationName;
        return this;
    }

    public Integer getMinSize() {
        return this.minSize;
    }

    public void setMinSize(Integer minSize) {
        this.minSize = minSize;
    }

    public AutoScalingGroup withMinSize(Integer minSize) {
        this.minSize = minSize;
        return this;
    }

    public Integer getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
    }

    public AutoScalingGroup withMaxSize(Integer maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    public Integer getDesiredCapacity() {
        return this.desiredCapacity;
    }

    public void setDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
    }

    public AutoScalingGroup withDesiredCapacity(Integer desiredCapacity) {
        this.desiredCapacity = desiredCapacity;
        return this;
    }

    public Integer getDefaultCooldown() {
        return this.defaultCooldown;
    }

    public void setDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
    }

    public AutoScalingGroup withDefaultCooldown(Integer defaultCooldown) {
        this.defaultCooldown = defaultCooldown;
        return this;
    }

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new ArrayList<String>();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
    }

    public AutoScalingGroup withAvailabilityZones(String ... availabilityZones) {
        if (this.getAvailabilityZones() == null) {
            this.setAvailabilityZones(new ArrayList<String>());
        }
        for (String value : availabilityZones) {
            this.getAvailabilityZones().add(value);
        }
        return this;
    }

    public AutoScalingGroup withAvailabilityZones(Collection<String> availabilityZones) {
        ArrayList<String> availabilityZonesCopy = new ArrayList<String>();
        if (availabilityZones != null) {
            availabilityZonesCopy.addAll(availabilityZones);
        }
        this.availabilityZones = availabilityZonesCopy;
        return this;
    }

    public List<String> getLoadBalancerNames() {
        if (this.loadBalancerNames == null) {
            this.loadBalancerNames = new ArrayList<String>();
        }
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        ArrayList<String> loadBalancerNamesCopy = new ArrayList<String>();
        if (loadBalancerNames != null) {
            loadBalancerNamesCopy.addAll(loadBalancerNames);
        }
        this.loadBalancerNames = loadBalancerNamesCopy;
    }

    public AutoScalingGroup withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.getLoadBalancerNames() == null) {
            this.setLoadBalancerNames(new ArrayList<String>());
        }
        for (String value : loadBalancerNames) {
            this.getLoadBalancerNames().add(value);
        }
        return this;
    }

    public AutoScalingGroup withLoadBalancerNames(Collection<String> loadBalancerNames) {
        ArrayList<String> loadBalancerNamesCopy = new ArrayList<String>();
        if (loadBalancerNames != null) {
            loadBalancerNamesCopy.addAll(loadBalancerNames);
        }
        this.loadBalancerNames = loadBalancerNamesCopy;
        return this;
    }

    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    public void setHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
    }

    public AutoScalingGroup withHealthCheckType(String healthCheckType) {
        this.healthCheckType = healthCheckType;
        return this;
    }

    public Integer getHealthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
    }

    public AutoScalingGroup withHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
        this.healthCheckGracePeriod = healthCheckGracePeriod;
        return this;
    }

    public List<Instance> getInstances() {
        if (this.instances == null) {
            this.instances = new ArrayList<Instance>();
        }
        return this.instances;
    }

    public void setInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
    }

    public AutoScalingGroup withInstances(Instance ... instances) {
        if (this.getInstances() == null) {
            this.setInstances(new ArrayList<Instance>());
        }
        for (Instance value : instances) {
            this.getInstances().add(value);
        }
        return this;
    }

    public AutoScalingGroup withInstances(Collection<Instance> instances) {
        ArrayList<Instance> instancesCopy = new ArrayList<Instance>();
        if (instances != null) {
            instancesCopy.addAll(instances);
        }
        this.instances = instancesCopy;
        return this;
    }

    public Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
    }

    public AutoScalingGroup withCreatedTime(Date createdTime) {
        this.createdTime = createdTime;
        return this;
    }

    public List<SuspendedProcess> getSuspendedProcesses() {
        if (this.suspendedProcesses == null) {
            this.suspendedProcesses = new ArrayList<SuspendedProcess>();
        }
        return this.suspendedProcesses;
    }

    public void setSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        ArrayList<SuspendedProcess> suspendedProcessesCopy = new ArrayList<SuspendedProcess>();
        if (suspendedProcesses != null) {
            suspendedProcessesCopy.addAll(suspendedProcesses);
        }
        this.suspendedProcesses = suspendedProcessesCopy;
    }

    public AutoScalingGroup withSuspendedProcesses(SuspendedProcess ... suspendedProcesses) {
        if (this.getSuspendedProcesses() == null) {
            this.setSuspendedProcesses(new ArrayList<SuspendedProcess>());
        }
        for (SuspendedProcess value : suspendedProcesses) {
            this.getSuspendedProcesses().add(value);
        }
        return this;
    }

    public AutoScalingGroup withSuspendedProcesses(Collection<SuspendedProcess> suspendedProcesses) {
        ArrayList<SuspendedProcess> suspendedProcessesCopy = new ArrayList<SuspendedProcess>();
        if (suspendedProcesses != null) {
            suspendedProcessesCopy.addAll(suspendedProcesses);
        }
        this.suspendedProcesses = suspendedProcessesCopy;
        return this;
    }

    public String getPlacementGroup() {
        return this.placementGroup;
    }

    public void setPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
    }

    public AutoScalingGroup withPlacementGroup(String placementGroup) {
        this.placementGroup = placementGroup;
        return this;
    }

    public String getVPCZoneIdentifier() {
        return this.vPCZoneIdentifier;
    }

    public void setVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
    }

    public AutoScalingGroup withVPCZoneIdentifier(String vPCZoneIdentifier) {
        this.vPCZoneIdentifier = vPCZoneIdentifier;
        return this;
    }

    public List<EnabledMetric> getEnabledMetrics() {
        if (this.enabledMetrics == null) {
            this.enabledMetrics = new ArrayList<EnabledMetric>();
        }
        return this.enabledMetrics;
    }

    public void setEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        ArrayList<EnabledMetric> enabledMetricsCopy = new ArrayList<EnabledMetric>();
        if (enabledMetrics != null) {
            enabledMetricsCopy.addAll(enabledMetrics);
        }
        this.enabledMetrics = enabledMetricsCopy;
    }

    public AutoScalingGroup withEnabledMetrics(EnabledMetric ... enabledMetrics) {
        if (this.getEnabledMetrics() == null) {
            this.setEnabledMetrics(new ArrayList<EnabledMetric>());
        }
        for (EnabledMetric value : enabledMetrics) {
            this.getEnabledMetrics().add(value);
        }
        return this;
    }

    public AutoScalingGroup withEnabledMetrics(Collection<EnabledMetric> enabledMetrics) {
        ArrayList<EnabledMetric> enabledMetricsCopy = new ArrayList<EnabledMetric>();
        if (enabledMetrics != null) {
            enabledMetricsCopy.addAll(enabledMetrics);
        }
        this.enabledMetrics = enabledMetricsCopy;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public AutoScalingGroup withStatus(String status) {
        this.status = status;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("AutoScalingGroupName: " + this.autoScalingGroupName + ", ");
        sb.append("AutoScalingGroupARN: " + this.autoScalingGroupARN + ", ");
        sb.append("LaunchConfigurationName: " + this.launchConfigurationName + ", ");
        sb.append("MinSize: " + this.minSize + ", ");
        sb.append("MaxSize: " + this.maxSize + ", ");
        sb.append("DesiredCapacity: " + this.desiredCapacity + ", ");
        sb.append("DefaultCooldown: " + this.defaultCooldown + ", ");
        sb.append("AvailabilityZones: " + this.availabilityZones + ", ");
        sb.append("LoadBalancerNames: " + this.loadBalancerNames + ", ");
        sb.append("HealthCheckType: " + this.healthCheckType + ", ");
        sb.append("HealthCheckGracePeriod: " + this.healthCheckGracePeriod + ", ");
        sb.append("Instances: " + this.instances + ", ");
        sb.append("CreatedTime: " + this.createdTime + ", ");
        sb.append("SuspendedProcesses: " + this.suspendedProcesses + ", ");
        sb.append("PlacementGroup: " + this.placementGroup + ", ");
        sb.append("VPCZoneIdentifier: " + this.vPCZoneIdentifier + ", ");
        sb.append("EnabledMetrics: " + this.enabledMetrics + ", ");
        sb.append("Status: " + this.status + ", ");
        sb.append("}");
        return sb.toString();
    }
}

