/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model;

import com.amazonaws.services.cloudfront.model.CustomOrigin;
import com.amazonaws.services.cloudfront.model.LoggingConfig;
import com.amazonaws.services.cloudfront.model.RequiredProtocols;
import com.amazonaws.services.cloudfront.model.S3Origin;
import com.amazonaws.services.cloudfront.model.TrustedSigners;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributionConfig {
    private S3Origin s3Origin;
    private CustomOrigin customOrigin;
    private String callerReference;
    private List<String> cNAME;
    private String comment;
    private Boolean enabled;
    private LoggingConfig logging;
    private TrustedSigners trustedSigners;
    private RequiredProtocols requiredProtocols;
    private String defaultRootObject;

    public DistributionConfig() {
    }

    public DistributionConfig(String callerReference, Boolean enabled) {
        this.callerReference = callerReference;
        this.enabled = enabled;
    }

    public S3Origin getS3Origin() {
        return this.s3Origin;
    }

    public void setS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
    }

    public DistributionConfig withS3Origin(S3Origin s3Origin) {
        this.s3Origin = s3Origin;
        return this;
    }

    public CustomOrigin getCustomOrigin() {
        return this.customOrigin;
    }

    public void setCustomOrigin(CustomOrigin customOrigin) {
        this.customOrigin = customOrigin;
    }

    public DistributionConfig withCustomOrigin(CustomOrigin customOrigin) {
        this.customOrigin = customOrigin;
        return this;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String callerReference) {
        this.callerReference = callerReference;
    }

    public DistributionConfig withCallerReference(String callerReference) {
        this.callerReference = callerReference;
        return this;
    }

    public List<String> getCNAME() {
        if (this.cNAME == null) {
            this.cNAME = new ArrayList<String>();
        }
        return this.cNAME;
    }

    public void setCNAME(Collection<String> cNAME) {
        ArrayList<String> cNAMECopy = new ArrayList<String>();
        if (cNAME != null) {
            cNAMECopy.addAll(cNAME);
        }
        this.cNAME = cNAMECopy;
    }

    public DistributionConfig withCNAME(String ... cNAME) {
        if (this.getCNAME() == null) {
            this.setCNAME(new ArrayList<String>());
        }
        for (String value : cNAME) {
            this.getCNAME().add(value);
        }
        return this;
    }

    public DistributionConfig withCNAME(Collection<String> cNAME) {
        ArrayList<String> cNAMECopy = new ArrayList<String>();
        if (cNAME != null) {
            cNAMECopy.addAll(cNAME);
        }
        this.cNAME = cNAMECopy;
        return this;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public DistributionConfig withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public DistributionConfig withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public LoggingConfig getLogging() {
        return this.logging;
    }

    public void setLogging(LoggingConfig logging) {
        this.logging = logging;
    }

    public DistributionConfig withLogging(LoggingConfig logging) {
        this.logging = logging;
        return this;
    }

    public TrustedSigners getTrustedSigners() {
        return this.trustedSigners;
    }

    public void setTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
    }

    public DistributionConfig withTrustedSigners(TrustedSigners trustedSigners) {
        this.trustedSigners = trustedSigners;
        return this;
    }

    public RequiredProtocols getRequiredProtocols() {
        return this.requiredProtocols;
    }

    public void setRequiredProtocols(RequiredProtocols requiredProtocols) {
        this.requiredProtocols = requiredProtocols;
    }

    public DistributionConfig withRequiredProtocols(RequiredProtocols requiredProtocols) {
        this.requiredProtocols = requiredProtocols;
        return this;
    }

    public String getDefaultRootObject() {
        return this.defaultRootObject;
    }

    public void setDefaultRootObject(String defaultRootObject) {
        this.defaultRootObject = defaultRootObject;
    }

    public DistributionConfig withDefaultRootObject(String defaultRootObject) {
        this.defaultRootObject = defaultRootObject;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("S3Origin: " + this.s3Origin + ", ");
        sb.append("CustomOrigin: " + this.customOrigin + ", ");
        sb.append("CallerReference: " + this.callerReference + ", ");
        sb.append("CNAME: " + this.cNAME + ", ");
        sb.append("Comment: " + this.comment + ", ");
        sb.append("Enabled: " + this.enabled + ", ");
        sb.append("Logging: " + this.logging + ", ");
        sb.append("TrustedSigners: " + this.trustedSigners + ", ");
        sb.append("RequiredProtocols: " + this.requiredProtocols + ", ");
        sb.append("DefaultRootObject: " + this.defaultRootObject + ", ");
        sb.append("}");
        return sb.toString();
    }
}

