/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeEnvironmentsRequestMarshaller
implements Marshaller<Request<DescribeEnvironmentsRequest>, DescribeEnvironmentsRequest> {
    @Override
    public Request<DescribeEnvironmentsRequest> marshall(DescribeEnvironmentsRequest describeEnvironmentsRequest) {
        DefaultRequest<DescribeEnvironmentsRequest> request = new DefaultRequest<DescribeEnvironmentsRequest>(describeEnvironmentsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeEnvironments");
        request.addParameter("Version", "2010-12-01");
        if (describeEnvironmentsRequest != null && describeEnvironmentsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString(describeEnvironmentsRequest.getApplicationName()));
        }
        if (describeEnvironmentsRequest != null && describeEnvironmentsRequest.getVersionLabel() != null) {
            request.addParameter("VersionLabel", StringUtils.fromString(describeEnvironmentsRequest.getVersionLabel()));
        }
        if (describeEnvironmentsRequest != null) {
            List<String> environmentIdsList = describeEnvironmentsRequest.getEnvironmentIds();
            int environmentIdsListIndex = 1;
            for (String environmentIdsListValue : environmentIdsList) {
                if (environmentIdsListValue != null) {
                    request.addParameter("EnvironmentIds.member." + environmentIdsListIndex, StringUtils.fromString(environmentIdsListValue));
                }
                ++environmentIdsListIndex;
            }
        }
        if (describeEnvironmentsRequest != null) {
            List<String> environmentNamesList = describeEnvironmentsRequest.getEnvironmentNames();
            int environmentNamesListIndex = 1;
            for (String environmentNamesListValue : environmentNamesList) {
                if (environmentNamesListValue != null) {
                    request.addParameter("EnvironmentNames.member." + environmentNamesListIndex, StringUtils.fromString(environmentNamesListValue));
                }
                ++environmentNamesListIndex;
            }
        }
        if (describeEnvironmentsRequest != null && describeEnvironmentsRequest.isIncludeDeleted() != null) {
            request.addParameter("IncludeDeleted", StringUtils.fromBoolean(describeEnvironmentsRequest.isIncludeDeleted()));
        }
        if (describeEnvironmentsRequest != null && describeEnvironmentsRequest.getIncludedDeletedBackTo() != null) {
            request.addParameter("IncludedDeletedBackTo", StringUtils.fromDate(describeEnvironmentsRequest.getIncludedDeletedBackTo()));
        }
        return request;
    }
}

