/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateRouteRequestMarshaller
implements Marshaller<Request<CreateRouteRequest>, CreateRouteRequest> {
    @Override
    public Request<CreateRouteRequest> marshall(CreateRouteRequest createRouteRequest) {
        DefaultRequest<CreateRouteRequest> request = new DefaultRequest<CreateRouteRequest>(createRouteRequest, "AmazonEC2");
        request.addParameter("Action", "CreateRoute");
        request.addParameter("Version", "2011-01-01");
        if (createRouteRequest != null && createRouteRequest.getRouteTableId() != null) {
            request.addParameter("RouteTableId", StringUtils.fromString(createRouteRequest.getRouteTableId()));
        }
        if (createRouteRequest != null && createRouteRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(createRouteRequest.getDestinationCidrBlock()));
        }
        if (createRouteRequest != null && createRouteRequest.getGatewayId() != null) {
            request.addParameter("GatewayId", StringUtils.fromString(createRouteRequest.getGatewayId()));
        }
        if (createRouteRequest != null && createRouteRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString(createRouteRequest.getInstanceId()));
        }
        return request;
    }
}

