/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.rds.AmazonRDS;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceReadReplicaRequest;
import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.services.rds.model.CreateDBParameterGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBParameterGroup;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DeleteDBInstanceRequest;
import com.amazonaws.services.rds.model.DeleteDBParameterGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DeleteDBSnapshotRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsRequest;
import com.amazonaws.services.rds.model.DescribeDBEngineVersionsResult;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBParameterGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBParametersRequest;
import com.amazonaws.services.rds.model.DescribeDBParametersResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import com.amazonaws.services.rds.model.DescribeEngineDefaultParametersRequest;
import com.amazonaws.services.rds.model.DescribeEventsRequest;
import com.amazonaws.services.rds.model.DescribeEventsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesOfferingsResult;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeReservedDBInstancesResult;
import com.amazonaws.services.rds.model.EngineDefaults;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupResult;
import com.amazonaws.services.rds.model.PurchaseReservedDBInstancesOfferingRequest;
import com.amazonaws.services.rds.model.RebootDBInstanceRequest;
import com.amazonaws.services.rds.model.ReservedDBInstance;
import com.amazonaws.services.rds.model.ResetDBParameterGroupRequest;
import com.amazonaws.services.rds.model.ResetDBParameterGroupResult;
import com.amazonaws.services.rds.model.RestoreDBInstanceFromDBSnapshotRequest;
import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.transform.AuthorizationAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizationNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizationQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.AuthorizeDBSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBInstanceReadReplicaRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBSecurityGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.CreateDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBInstanceStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBParameterGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSecurityGroupStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.DBSnapshotStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBSecurityGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DeleteDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBEngineVersionsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBEngineVersionsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBInstancesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBInstancesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParameterGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParameterGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParametersRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBParametersResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSecurityGroupsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSecurityGroupsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSnapshotsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeDBSnapshotsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEngineDefaultParametersRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeEventsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesOfferingsRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesOfferingsResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesRequestMarshaller;
import com.amazonaws.services.rds.model.transform.DescribeReservedDBInstancesResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.EngineDefaultsStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.InstanceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InsufficientDBInstanceCapacityExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBInstanceStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBParameterGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSecurityGroupStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.InvalidDBSnapshotStateExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ModifyDBParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.PointInTimeRestoreNotEnabledExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.PurchaseReservedDBInstancesOfferingRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RebootDBInstanceRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstanceStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.ReservedDBInstancesOfferingNotFoundExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.ResetDBParameterGroupRequestMarshaller;
import com.amazonaws.services.rds.model.transform.ResetDBParameterGroupResultStaxUnmarshaller;
import com.amazonaws.services.rds.model.transform.RestoreDBInstanceFromDBSnapshotRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RestoreDBInstanceToPointInTimeRequestMarshaller;
import com.amazonaws.services.rds.model.transform.RevokeDBSecurityGroupIngressRequestMarshaller;
import com.amazonaws.services.rds.model.transform.SnapshotQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.rds.model.transform.StorageQuotaExceededExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonRDSClient
extends AmazonWebServiceClient
implements AmazonRDS {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private final List<RequestHandler> requestHandlers;
    private QueryStringSigner signer;

    public AmazonRDSClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonRDSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new DBParameterGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBParameterGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSecurityGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSnapshotAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InsufficientDBInstanceCapacityExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBSnapshotStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSnapshotNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PointInTimeRestoreNotEnabledExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBInstanceAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StorageQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstanceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBSecurityGroupQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ReservedDBInstancesOfferingNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new AuthorizationQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBInstanceNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBParameterGroupStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new SnapshotQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DBParameterGroupAlreadyExistsExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InstanceQuotaExceededExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidDBInstanceStateExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("rds.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/rds/request.handlers"));
        this.client = new HttpClient(clientConfiguration);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public void deleteDBParameterGroup(DeleteDBParameterGroupRequest deleteDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBParameterGroupRequest> request = new DeleteDBParameterGroupRequestMarshaller().marshall(deleteDBParameterGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DBSnapshot deleteDBSnapshot(DeleteDBSnapshotRequest deleteDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBSnapshotRequest> request = new DeleteDBSnapshotRequestMarshaller().marshall(deleteDBSnapshotRequest);
        return this.invoke(request, new DBSnapshotStaxUnmarshaller());
    }

    @Override
    public ModifyDBParameterGroupResult modifyDBParameterGroup(ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyDBParameterGroupRequest> request = new ModifyDBParameterGroupRequestMarshaller().marshall(modifyDBParameterGroupRequest);
        return this.invoke(request, new ModifyDBParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup revokeDBSecurityGroupIngress(RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<RevokeDBSecurityGroupIngressRequest> request = new RevokeDBSecurityGroupIngressRequestMarshaller().marshall(revokeDBSecurityGroupIngressRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DescribeDBParametersResult describeDBParameters(DescribeDBParametersRequest describeDBParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBParametersRequest> request = new DescribeDBParametersRequestMarshaller().marshall(describeDBParametersRequest);
        return this.invoke(request, new DescribeDBParametersResultStaxUnmarshaller());
    }

    @Override
    public DescribeEventsResult describeEvents(DescribeEventsRequest describeEventsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEventsRequest> request = new DescribeEventsRequestMarshaller().marshall(describeEventsRequest);
        return this.invoke(request, new DescribeEventsResultStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup createDBSecurityGroup(CreateDBSecurityGroupRequest createDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBSecurityGroupRequest> request = new CreateDBSecurityGroupRequestMarshaller().marshall(createDBSecurityGroupRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DescribeDBInstancesResult describeDBInstances(DescribeDBInstancesRequest describeDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBInstancesRequest> request = new DescribeDBInstancesRequestMarshaller().marshall(describeDBInstancesRequest);
        return this.invoke(request, new DescribeDBInstancesResultStaxUnmarshaller());
    }

    @Override
    public DescribeDBParameterGroupsResult describeDBParameterGroups(DescribeDBParameterGroupsRequest describeDBParameterGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBParameterGroupsRequest> request = new DescribeDBParameterGroupsRequestMarshaller().marshall(describeDBParameterGroupsRequest);
        return this.invoke(request, new DescribeDBParameterGroupsResultStaxUnmarshaller());
    }

    @Override
    public DBSnapshot createDBSnapshot(CreateDBSnapshotRequest createDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBSnapshotRequest> request = new CreateDBSnapshotRequestMarshaller().marshall(createDBSnapshotRequest);
        return this.invoke(request, new DBSnapshotStaxUnmarshaller());
    }

    @Override
    public DescribeDBEngineVersionsResult describeDBEngineVersions(DescribeDBEngineVersionsRequest describeDBEngineVersionsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBEngineVersionsRequest> request = new DescribeDBEngineVersionsRequestMarshaller().marshall(describeDBEngineVersionsRequest);
        return this.invoke(request, new DescribeDBEngineVersionsResultStaxUnmarshaller());
    }

    @Override
    public DBInstance rebootDBInstance(RebootDBInstanceRequest rebootDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<RebootDBInstanceRequest> request = new RebootDBInstanceRequestMarshaller().marshall(rebootDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DBSecurityGroup authorizeDBSecurityGroupIngress(AuthorizeDBSecurityGroupIngressRequest authorizeDBSecurityGroupIngressRequest) throws AmazonServiceException, AmazonClientException {
        Request<AuthorizeDBSecurityGroupIngressRequest> request = new AuthorizeDBSecurityGroupIngressRequestMarshaller().marshall(authorizeDBSecurityGroupIngressRequest);
        return this.invoke(request, new DBSecurityGroupStaxUnmarshaller());
    }

    @Override
    public DBInstance restoreDBInstanceToPointInTime(RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestoreDBInstanceToPointInTimeRequest> request = new RestoreDBInstanceToPointInTimeRequestMarshaller().marshall(restoreDBInstanceToPointInTimeRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeDBSnapshotsResult describeDBSnapshots(DescribeDBSnapshotsRequest describeDBSnapshotsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBSnapshotsRequest> request = new DescribeDBSnapshotsRequestMarshaller().marshall(describeDBSnapshotsRequest);
        return this.invoke(request, new DescribeDBSnapshotsResultStaxUnmarshaller());
    }

    @Override
    public DescribeReservedDBInstancesOfferingsResult describeReservedDBInstancesOfferings(DescribeReservedDBInstancesOfferingsRequest describeReservedDBInstancesOfferingsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedDBInstancesOfferingsRequest> request = new DescribeReservedDBInstancesOfferingsRequestMarshaller().marshall(describeReservedDBInstancesOfferingsRequest);
        return this.invoke(request, new DescribeReservedDBInstancesOfferingsResultStaxUnmarshaller());
    }

    @Override
    public EngineDefaults describeEngineDefaultParameters(DescribeEngineDefaultParametersRequest describeEngineDefaultParametersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeEngineDefaultParametersRequest> request = new DescribeEngineDefaultParametersRequestMarshaller().marshall(describeEngineDefaultParametersRequest);
        return this.invoke(request, new EngineDefaultsStaxUnmarshaller());
    }

    @Override
    public DBInstance deleteDBInstance(DeleteDBInstanceRequest deleteDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBInstanceRequest> request = new DeleteDBInstanceRequestMarshaller().marshall(deleteDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeDBSecurityGroupsResult describeDBSecurityGroups(DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeDBSecurityGroupsRequest> request = new DescribeDBSecurityGroupsRequestMarshaller().marshall(describeDBSecurityGroupsRequest);
        return this.invoke(request, new DescribeDBSecurityGroupsResultStaxUnmarshaller());
    }

    @Override
    public DBInstance createDBInstance(CreateDBInstanceRequest createDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBInstanceRequest> request = new CreateDBInstanceRequestMarshaller().marshall(createDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public ResetDBParameterGroupResult resetDBParameterGroup(ResetDBParameterGroupRequest resetDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<ResetDBParameterGroupRequest> request = new ResetDBParameterGroupRequestMarshaller().marshall(resetDBParameterGroupRequest);
        return this.invoke(request, new ResetDBParameterGroupResultStaxUnmarshaller());
    }

    @Override
    public DBInstance modifyDBInstance(ModifyDBInstanceRequest modifyDBInstanceRequest) throws AmazonServiceException, AmazonClientException {
        Request<ModifyDBInstanceRequest> request = new ModifyDBInstanceRequestMarshaller().marshall(modifyDBInstanceRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DBInstance restoreDBInstanceFromDBSnapshot(RestoreDBInstanceFromDBSnapshotRequest restoreDBInstanceFromDBSnapshotRequest) throws AmazonServiceException, AmazonClientException {
        Request<RestoreDBInstanceFromDBSnapshotRequest> request = new RestoreDBInstanceFromDBSnapshotRequestMarshaller().marshall(restoreDBInstanceFromDBSnapshotRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeReservedDBInstancesResult describeReservedDBInstances(DescribeReservedDBInstancesRequest describeReservedDBInstancesRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeReservedDBInstancesRequest> request = new DescribeReservedDBInstancesRequestMarshaller().marshall(describeReservedDBInstancesRequest);
        return this.invoke(request, new DescribeReservedDBInstancesResultStaxUnmarshaller());
    }

    @Override
    public DBParameterGroup createDBParameterGroup(CreateDBParameterGroupRequest createDBParameterGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBParameterGroupRequest> request = new CreateDBParameterGroupRequestMarshaller().marshall(createDBParameterGroupRequest);
        return this.invoke(request, new DBParameterGroupStaxUnmarshaller());
    }

    @Override
    public void deleteDBSecurityGroup(DeleteDBSecurityGroupRequest deleteDBSecurityGroupRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteDBSecurityGroupRequest> request = new DeleteDBSecurityGroupRequestMarshaller().marshall(deleteDBSecurityGroupRequest);
        this.invoke(request, null);
    }

    @Override
    public DBInstance createDBInstanceReadReplica(CreateDBInstanceReadReplicaRequest createDBInstanceReadReplicaRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateDBInstanceReadReplicaRequest> request = new CreateDBInstanceReadReplicaRequestMarshaller().marshall(createDBInstanceReadReplicaRequest);
        return this.invoke(request, new DBInstanceStaxUnmarshaller());
    }

    @Override
    public ReservedDBInstance purchaseReservedDBInstancesOffering(PurchaseReservedDBInstancesOfferingRequest purchaseReservedDBInstancesOfferingRequest) throws AmazonServiceException, AmazonClientException {
        Request<PurchaseReservedDBInstancesOfferingRequest> request = new PurchaseReservedDBInstancesOfferingRequestMarshaller().marshall(purchaseReservedDBInstancesOfferingRequest);
        return this.invoke(request, new ReservedDBInstanceStaxUnmarshaller());
    }

    @Override
    public DescribeEventsResult describeEvents() throws AmazonServiceException, AmazonClientException {
        return this.describeEvents(new DescribeEventsRequest());
    }

    @Override
    public DescribeDBInstancesResult describeDBInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeDBInstances(new DescribeDBInstancesRequest());
    }

    @Override
    public DescribeDBParameterGroupsResult describeDBParameterGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeDBParameterGroups(new DescribeDBParameterGroupsRequest());
    }

    @Override
    public DescribeDBEngineVersionsResult describeDBEngineVersions() throws AmazonServiceException, AmazonClientException {
        return this.describeDBEngineVersions(new DescribeDBEngineVersionsRequest());
    }

    @Override
    public DescribeDBSnapshotsResult describeDBSnapshots() throws AmazonServiceException, AmazonClientException {
        return this.describeDBSnapshots(new DescribeDBSnapshotsRequest());
    }

    @Override
    public DescribeReservedDBInstancesOfferingsResult describeReservedDBInstancesOfferings() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedDBInstancesOfferings(new DescribeReservedDBInstancesOfferingsRequest());
    }

    @Override
    public DescribeDBSecurityGroupsResult describeDBSecurityGroups() throws AmazonServiceException, AmazonClientException {
        return this.describeDBSecurityGroups(new DescribeDBSecurityGroupsRequest());
    }

    @Override
    public DescribeReservedDBInstancesResult describeReservedDBInstances() throws AmazonServiceException, AmazonClientException {
        return this.describeReservedDBInstances(new DescribeReservedDBInstancesRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

