/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.http;

import com.amazonaws.Request;
import com.amazonaws.http.HttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RepeatableInputStreamRequestEntity
implements RequestEntity {
    private boolean firstAttempt = true;
    private InputStreamRequestEntity inputStreamRequestEntity;
    private InputStream content;
    private static final Log log = LogFactory.getLog(HttpClient.class);

    RepeatableInputStreamRequestEntity(Request<?> request) {
        long contentLength = -2L;
        try {
            String contentLengthString = request.getHeaders().get("Content-Length");
            if (contentLengthString != null) {
                contentLength = Long.parseLong(contentLengthString);
            }
        }
        catch (NumberFormatException nfe) {
            log.warn((Object)"Unable to parse content length from request.  Buffering contents in memory.");
        }
        String contentType = request.getHeaders().get("Content-Type");
        this.inputStreamRequestEntity = new InputStreamRequestEntity(request.getContent(), contentLength, contentType);
        this.content = request.getContent();
    }

    public String getContentType() {
        return this.inputStreamRequestEntity.getContentType();
    }

    public boolean isRepeatable() {
        return this.content.markSupported() || this.inputStreamRequestEntity.isRepeatable();
    }

    public void writeRequest(OutputStream output) throws IOException {
        if (!this.firstAttempt && this.isRepeatable()) {
            this.content.reset();
        }
        this.firstAttempt = false;
        this.inputStreamRequestEntity.writeRequest(output);
    }

    public long getContentLength() {
        return this.inputStreamRequestEntity.getContentLength();
    }
}

