/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleemail;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWS3Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.model.DeleteVerifiedEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaRequest;
import com.amazonaws.services.simpleemail.model.GetSendQuotaResult;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsRequest;
import com.amazonaws.services.simpleemail.model.GetSendStatisticsResult;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesRequest;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.SendEmailRequest;
import com.amazonaws.services.simpleemail.model.SendEmailResult;
import com.amazonaws.services.simpleemail.model.SendRawEmailRequest;
import com.amazonaws.services.simpleemail.model.SendRawEmailResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.amazonaws.services.simpleemail.model.transform.DeleteVerifiedEmailAddressRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendQuotaResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.GetSendStatisticsResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.ListVerifiedEmailAddressesResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.MessageRejectedExceptionUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailRequestMarshaller;
import com.amazonaws.services.simpleemail.model.transform.SendRawEmailResultStaxUnmarshaller;
import com.amazonaws.services.simpleemail.model.transform.VerifyEmailAddressRequestMarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonSimpleEmailServiceClient
extends AmazonWebServiceClient
implements AmazonSimpleEmailService {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private final List<RequestHandler> requestHandlers;
    private AWS3Signer signer;

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonSimpleEmailServiceClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new MessageRejectedExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("email.us-east-1.amazonaws.com");
        this.signer = new AWS3Signer();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/simpleemail/request.handlers"));
        this.client = new HttpClient(clientConfiguration);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public GetSendQuotaResult getSendQuota(GetSendQuotaRequest getSendQuotaRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetSendQuotaRequest> request = new GetSendQuotaRequestMarshaller().marshall(getSendQuotaRequest);
        return this.invoke(request, new GetSendQuotaResultStaxUnmarshaller());
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses(ListVerifiedEmailAddressesRequest listVerifiedEmailAddressesRequest) throws AmazonServiceException, AmazonClientException {
        Request<ListVerifiedEmailAddressesRequest> request = new ListVerifiedEmailAddressesRequestMarshaller().marshall(listVerifiedEmailAddressesRequest);
        return this.invoke(request, new ListVerifiedEmailAddressesResultStaxUnmarshaller());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics(GetSendStatisticsRequest getSendStatisticsRequest) throws AmazonServiceException, AmazonClientException {
        Request<GetSendStatisticsRequest> request = new GetSendStatisticsRequestMarshaller().marshall(getSendStatisticsRequest);
        return this.invoke(request, new GetSendStatisticsResultStaxUnmarshaller());
    }

    @Override
    public SendEmailResult sendEmail(SendEmailRequest sendEmailRequest) throws AmazonServiceException, AmazonClientException {
        Request<SendEmailRequest> request = new SendEmailRequestMarshaller().marshall(sendEmailRequest);
        return this.invoke(request, new SendEmailResultStaxUnmarshaller());
    }

    @Override
    public void deleteVerifiedEmailAddress(DeleteVerifiedEmailAddressRequest deleteVerifiedEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteVerifiedEmailAddressRequest> request = new DeleteVerifiedEmailAddressRequestMarshaller().marshall(deleteVerifiedEmailAddressRequest);
        this.invoke(request, null);
    }

    @Override
    public void verifyEmailAddress(VerifyEmailAddressRequest verifyEmailAddressRequest) throws AmazonServiceException, AmazonClientException {
        Request<VerifyEmailAddressRequest> request = new VerifyEmailAddressRequestMarshaller().marshall(verifyEmailAddressRequest);
        this.invoke(request, null);
    }

    @Override
    public SendRawEmailResult sendRawEmail(SendRawEmailRequest sendRawEmailRequest) throws AmazonServiceException, AmazonClientException {
        Request<SendRawEmailRequest> request = new SendRawEmailRequestMarshaller().marshall(sendRawEmailRequest);
        return this.invoke(request, new SendRawEmailResultStaxUnmarshaller());
    }

    @Override
    public GetSendQuotaResult getSendQuota() throws AmazonServiceException, AmazonClientException {
        return this.getSendQuota(new GetSendQuotaRequest());
    }

    @Override
    public ListVerifiedEmailAddressesResult listVerifiedEmailAddresses() throws AmazonServiceException, AmazonClientException {
        return this.listVerifiedEmailAddresses(new ListVerifiedEmailAddressesRequest());
    }

    @Override
    public GetSendStatisticsResult getSendStatistics() throws AmazonServiceException, AmazonClientException {
        return this.getSendStatistics(new GetSendStatisticsRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

