/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.QueryStringSigner;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.DefaultErrorResponseHandler;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpClient;
import com.amazonaws.http.StaxResponseHandler;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckRequest;
import com.amazonaws.services.elasticloadbalancing.model.ConfigureHealthCheckResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLBCookieStickinessPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.CreateLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyResult;
import com.amazonaws.services.elasticloadbalancing.model.DeleteLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeLoadBalancersResult;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest;
import com.amazonaws.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResult;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerListenerSSLCertificateRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest;
import com.amazonaws.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResult;
import com.amazonaws.services.elasticloadbalancing.model.transform.CertificateNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ConfigureHealthCheckResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateAppCookieStickinessPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLBCookieStickinessPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerListenersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.CreateLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerListenersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerPolicyResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeleteLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DeregisterInstancesFromLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeInstanceHealthResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DescribeLoadBalancersResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DisableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicateListenerExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicateLoadBalancerNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.DuplicatePolicyNameExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.EnableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidConfigurationRequestExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.InvalidInstanceExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.ListenerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.LoadBalancerNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.PolicyNotFoundExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.RegisterInstancesWithLoadBalancerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerListenerSSLCertificateRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerRequestMarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.SetLoadBalancerPoliciesOfListenerResultStaxUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyLoadBalancersExceptionUnmarshaller;
import com.amazonaws.services.elasticloadbalancing.model.transform.TooManyPoliciesExceptionUnmarshaller;
import com.amazonaws.transform.StandardErrorUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmazonElasticLoadBalancingClient
extends AmazonWebServiceClient
implements AmazonElasticLoadBalancing {
    private AWSCredentials awsCredentials;
    protected final List<Unmarshaller<AmazonServiceException, Node>> exceptionUnmarshallers;
    protected final HttpClient client;
    private final List<RequestHandler> requestHandlers;
    private QueryStringSigner signer;

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonElasticLoadBalancingClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentials = awsCredentials;
        this.exceptionUnmarshallers = new ArrayList<Unmarshaller<AmazonServiceException, Node>>();
        this.exceptionUnmarshallers.add(new TooManyPoliciesExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateListenerExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new CertificateNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new LoadBalancerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicatePolicyNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new TooManyLoadBalancersExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new DuplicateLoadBalancerNameExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidInstanceExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new PolicyNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new ListenerNotFoundExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new InvalidConfigurationRequestExceptionUnmarshaller());
        this.exceptionUnmarshallers.add(new StandardErrorUnmarshaller());
        this.setEndpoint("elasticloadbalancing.amazonaws.com");
        this.signer = new QueryStringSigner();
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandlers = Collections.synchronizedList(chainFactory.newRequestHandlerChain("/com/amazonaws/services/elasticloadbalancing/request.handlers"));
        this.client = new HttpClient(clientConfiguration);
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    @Override
    public void createLoadBalancerListeners(CreateLoadBalancerListenersRequest createLoadBalancerListenersRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLoadBalancerListenersRequest> request = new CreateLoadBalancerListenersRequestMarshaller().marshall(createLoadBalancerListenersRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateLBCookieStickinessPolicyResult createLBCookieStickinessPolicy(CreateLBCookieStickinessPolicyRequest createLBCookieStickinessPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLBCookieStickinessPolicyRequest> request = new CreateLBCookieStickinessPolicyRequestMarshaller().marshall(createLBCookieStickinessPolicyRequest);
        return this.invoke(request, new CreateLBCookieStickinessPolicyResultStaxUnmarshaller());
    }

    @Override
    public ConfigureHealthCheckResult configureHealthCheck(ConfigureHealthCheckRequest configureHealthCheckRequest) throws AmazonServiceException, AmazonClientException {
        Request<ConfigureHealthCheckRequest> request = new ConfigureHealthCheckRequestMarshaller().marshall(configureHealthCheckRequest);
        return this.invoke(request, new ConfigureHealthCheckResultStaxUnmarshaller());
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeLoadBalancersRequest> request = new DescribeLoadBalancersRequestMarshaller().marshall(describeLoadBalancersRequest);
        return this.invoke(request, new DescribeLoadBalancersResultStaxUnmarshaller());
    }

    @Override
    public void setLoadBalancerListenerSSLCertificate(SetLoadBalancerListenerSSLCertificateRequest setLoadBalancerListenerSSLCertificateRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetLoadBalancerListenerSSLCertificateRequest> request = new SetLoadBalancerListenerSSLCertificateRequestMarshaller().marshall(setLoadBalancerListenerSSLCertificateRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateLoadBalancerResult createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateLoadBalancerRequest> request = new CreateLoadBalancerRequestMarshaller().marshall(createLoadBalancerRequest);
        return this.invoke(request, new CreateLoadBalancerResultStaxUnmarshaller());
    }

    @Override
    public EnableAvailabilityZonesForLoadBalancerResult enableAvailabilityZonesForLoadBalancer(EnableAvailabilityZonesForLoadBalancerRequest enableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<EnableAvailabilityZonesForLoadBalancerRequest> request = new EnableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(enableAvailabilityZonesForLoadBalancerRequest);
        return this.invoke(request, new EnableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller());
    }

    @Override
    public DescribeInstanceHealthResult describeInstanceHealth(DescribeInstanceHealthRequest describeInstanceHealthRequest) throws AmazonServiceException, AmazonClientException {
        Request<DescribeInstanceHealthRequest> request = new DescribeInstanceHealthRequestMarshaller().marshall(describeInstanceHealthRequest);
        return this.invoke(request, new DescribeInstanceHealthResultStaxUnmarshaller());
    }

    @Override
    public DeleteLoadBalancerPolicyResult deleteLoadBalancerPolicy(DeleteLoadBalancerPolicyRequest deleteLoadBalancerPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoadBalancerPolicyRequest> request = new DeleteLoadBalancerPolicyRequestMarshaller().marshall(deleteLoadBalancerPolicyRequest);
        return this.invoke(request, new DeleteLoadBalancerPolicyResultStaxUnmarshaller());
    }

    @Override
    public DisableAvailabilityZonesForLoadBalancerResult disableAvailabilityZonesForLoadBalancer(DisableAvailabilityZonesForLoadBalancerRequest disableAvailabilityZonesForLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DisableAvailabilityZonesForLoadBalancerRequest> request = new DisableAvailabilityZonesForLoadBalancerRequestMarshaller().marshall(disableAvailabilityZonesForLoadBalancerRequest);
        return this.invoke(request, new DisableAvailabilityZonesForLoadBalancerResultStaxUnmarshaller());
    }

    @Override
    public DeregisterInstancesFromLoadBalancerResult deregisterInstancesFromLoadBalancer(DeregisterInstancesFromLoadBalancerRequest deregisterInstancesFromLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeregisterInstancesFromLoadBalancerRequest> request = new DeregisterInstancesFromLoadBalancerRequestMarshaller().marshall(deregisterInstancesFromLoadBalancerRequest);
        return this.invoke(request, new DeregisterInstancesFromLoadBalancerResultStaxUnmarshaller());
    }

    @Override
    public void deleteLoadBalancerListeners(DeleteLoadBalancerListenersRequest deleteLoadBalancerListenersRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoadBalancerListenersRequest> request = new DeleteLoadBalancerListenersRequestMarshaller().marshall(deleteLoadBalancerListenersRequest);
        this.invoke(request, null);
    }

    @Override
    public void deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<DeleteLoadBalancerRequest> request = new DeleteLoadBalancerRequestMarshaller().marshall(deleteLoadBalancerRequest);
        this.invoke(request, null);
    }

    @Override
    public CreateAppCookieStickinessPolicyResult createAppCookieStickinessPolicy(CreateAppCookieStickinessPolicyRequest createAppCookieStickinessPolicyRequest) throws AmazonServiceException, AmazonClientException {
        Request<CreateAppCookieStickinessPolicyRequest> request = new CreateAppCookieStickinessPolicyRequestMarshaller().marshall(createAppCookieStickinessPolicyRequest);
        return this.invoke(request, new CreateAppCookieStickinessPolicyResultStaxUnmarshaller());
    }

    @Override
    public RegisterInstancesWithLoadBalancerResult registerInstancesWithLoadBalancer(RegisterInstancesWithLoadBalancerRequest registerInstancesWithLoadBalancerRequest) throws AmazonServiceException, AmazonClientException {
        Request<RegisterInstancesWithLoadBalancerRequest> request = new RegisterInstancesWithLoadBalancerRequestMarshaller().marshall(registerInstancesWithLoadBalancerRequest);
        return this.invoke(request, new RegisterInstancesWithLoadBalancerResultStaxUnmarshaller());
    }

    @Override
    public SetLoadBalancerPoliciesOfListenerResult setLoadBalancerPoliciesOfListener(SetLoadBalancerPoliciesOfListenerRequest setLoadBalancerPoliciesOfListenerRequest) throws AmazonServiceException, AmazonClientException {
        Request<SetLoadBalancerPoliciesOfListenerRequest> request = new SetLoadBalancerPoliciesOfListenerRequestMarshaller().marshall(setLoadBalancerPoliciesOfListenerRequest);
        return this.invoke(request, new SetLoadBalancerPoliciesOfListenerResultStaxUnmarshaller());
    }

    @Override
    public DescribeLoadBalancersResult describeLoadBalancers() throws AmazonServiceException, AmazonClientException {
        return this.describeLoadBalancers(new DescribeLoadBalancersRequest());
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, StaxUnmarshallerContext> unmarshaller) {
        request.setEndpoint(this.endpoint);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        if (this.requestHandlers != null) {
            for (RequestHandler requestHandler : this.requestHandlers) {
                requestHandler.beforeRequest(request);
            }
        }
        if (request.getOriginalRequest().getRequestCredentials() != null) {
            this.signer.sign(request, request.getOriginalRequest().getRequestCredentials());
        } else {
            this.signer.sign(request, this.awsCredentials);
        }
        StaxResponseHandler<X> responseHandler = new StaxResponseHandler<X>(unmarshaller);
        DefaultErrorResponseHandler errorResponseHandler = new DefaultErrorResponseHandler(this.exceptionUnmarshallers);
        ExecutionContext executionContext = new ExecutionContext(this.requestHandlers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

