/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class InputSubstream
extends FilterInputStream {
    private long bytesRemaining;
    private long offset;

    public InputSubstream(InputStream in, long offset, long length) {
        super(in);
        this.bytesRemaining = length;
        this.offset = offset;
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int bytesRead = this.read(b, 0, 1);
        if (bytesRead == -1) {
            return bytesRead;
        }
        return b[0];
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.offset > 0L) {
            super.skip(this.offset);
            this.offset = 0L;
        }
        if (this.bytesRemaining <= 0L) {
            return -1;
        }
        len = (int)Math.min((long)len, this.bytesRemaining);
        int bytesRead = super.read(b, off, len);
        this.bytesRemaining -= (long)bytesRead;
        return bytesRead;
    }

    public int available() throws IOException {
        return (int)Math.min(this.bytesRemaining, (long)super.available());
    }

    public void close() throws IOException {
    }
}

