/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.Placement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchSpecification {
    private String imageId;
    private String keyName;
    private List<String> securityGroups;
    private String userData;
    private String addressingType;
    private String instanceType;
    private Placement placement;
    private String kernelId;
    private String ramdiskId;
    private List<BlockDeviceMapping> blockDeviceMappings;
    private Boolean monitoringEnabled;
    private String subnetId;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public LaunchSpecification withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public LaunchSpecification withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public List<String> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ArrayList<String>();
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
    }

    public LaunchSpecification withSecurityGroups(String ... securityGroups) {
        for (String value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public LaunchSpecification withSecurityGroups(Collection<String> securityGroups) {
        ArrayList<String> securityGroupsCopy = new ArrayList<String>();
        if (securityGroups != null) {
            securityGroupsCopy.addAll(securityGroups);
        }
        this.securityGroups = securityGroupsCopy;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public LaunchSpecification withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getAddressingType() {
        return this.addressingType;
    }

    public void setAddressingType(String addressingType) {
        this.addressingType = addressingType;
    }

    public LaunchSpecification withAddressingType(String addressingType) {
        this.addressingType = addressingType;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public LaunchSpecification withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public Placement getPlacement() {
        return this.placement;
    }

    public void setPlacement(Placement placement) {
        this.placement = placement;
    }

    public LaunchSpecification withPlacement(Placement placement) {
        this.placement = placement;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public LaunchSpecification withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public LaunchSpecification withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public LaunchSpecification withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public LaunchSpecification withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        ArrayList<BlockDeviceMapping> blockDeviceMappingsCopy = new ArrayList<BlockDeviceMapping>();
        if (blockDeviceMappings != null) {
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        }
        this.blockDeviceMappings = blockDeviceMappingsCopy;
        return this;
    }

    public Boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public LaunchSpecification withMonitoringEnabled(Boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
        return this;
    }

    public Boolean getMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public LaunchSpecification withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("ImageId: " + this.imageId + ", ");
        sb.append("KeyName: " + this.keyName + ", ");
        sb.append("SecurityGroups: " + this.securityGroups + ", ");
        sb.append("UserData: " + this.userData + ", ");
        sb.append("AddressingType: " + this.addressingType + ", ");
        sb.append("InstanceType: " + this.instanceType + ", ");
        sb.append("Placement: " + this.placement + ", ");
        sb.append("KernelId: " + this.kernelId + ", ");
        sb.append("RamdiskId: " + this.ramdiskId + ", ");
        sb.append("BlockDeviceMappings: " + this.blockDeviceMappings + ", ");
        sb.append("MonitoringEnabled: " + this.monitoringEnabled + ", ");
        sb.append("SubnetId: " + this.subnetId + ", ");
        sb.append("}");
        return sb.toString();
    }
}

