/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.rds.model.ModifyDBParameterGroupRequest;
import com.amazonaws.services.rds.model.Parameter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDBParameterGroupRequestMarshaller
implements Marshaller<Request<ModifyDBParameterGroupRequest>, ModifyDBParameterGroupRequest> {
    @Override
    public Request<ModifyDBParameterGroupRequest> marshall(ModifyDBParameterGroupRequest modifyDBParameterGroupRequest) {
        DefaultRequest<ModifyDBParameterGroupRequest> request = new DefaultRequest<ModifyDBParameterGroupRequest>(modifyDBParameterGroupRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBParameterGroup");
        request.addParameter("Version", "2010-01-01");
        if (modifyDBParameterGroupRequest != null && modifyDBParameterGroupRequest.getDBParameterGroupName() != null) {
            request.addParameter("DBParameterGroupName", StringUtils.fromString(modifyDBParameterGroupRequest.getDBParameterGroupName()));
        }
        if (modifyDBParameterGroupRequest != null) {
            List<Parameter> parametersList = modifyDBParameterGroupRequest.getParameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue != null && parametersListValue.getParameterName() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterName", StringUtils.fromString(parametersListValue.getParameterName()));
                }
                if (parametersListValue != null && parametersListValue.getParameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString(parametersListValue.getParameterValue()));
                }
                if (parametersListValue != null && parametersListValue.getDescription() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".Description", StringUtils.fromString(parametersListValue.getDescription()));
                }
                if (parametersListValue != null && parametersListValue.getSource() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".Source", StringUtils.fromString(parametersListValue.getSource()));
                }
                if (parametersListValue != null && parametersListValue.getApplyType() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ApplyType", StringUtils.fromString(parametersListValue.getApplyType()));
                }
                if (parametersListValue != null && parametersListValue.getDataType() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".DataType", StringUtils.fromString(parametersListValue.getDataType()));
                }
                if (parametersListValue != null && parametersListValue.getAllowedValues() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".AllowedValues", StringUtils.fromString(parametersListValue.getAllowedValues()));
                }
                if (parametersListValue != null && parametersListValue.isIsModifiable() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean(parametersListValue.isIsModifiable()));
                }
                if (parametersListValue != null && parametersListValue.getApplyMethod() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ApplyMethod", StringUtils.fromString(parametersListValue.getApplyMethod()));
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

