/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.transform.MapEntry;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStaxUnmarshaller
implements Unmarshaller<Message, StaxUnmarshallerContext> {
    private static MessageStaxUnmarshaller instance;

    @Override
    public Message unmarshall(StaxUnmarshallerContext context) throws Exception {
        Message message = new Message();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 2;
        }
        while (true) {
            XMLEvent event;
            if ((event = context.nextEvent()).isEndDocument()) {
                return message;
            }
            if (event.isAttribute() || event.isStartElement()) {
                if (context.testExpression("MessageId", targetDepth)) {
                    message.setMessageId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReceiptHandle", targetDepth)) {
                    message.setReceiptHandle(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MD5OfBody", targetDepth)) {
                    message.setMD5OfBody(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Body", targetDepth)) {
                    message.setBody(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Attribute", targetDepth)) continue;
                Map.Entry<String, String> entry = AttributesMapEntryUnmarshaller.getInstance().unmarshall(context);
                message.getAttributes().put(entry.getKey(), entry.getValue());
                continue;
            }
            if (event.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return message;
    }

    public static MessageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MessageStaxUnmarshaller();
        }
        return instance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AttributesMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {
        private static AttributesMapEntryUnmarshaller instance;

        private AttributesMapEntryUnmarshaller() {
        }

        @Override
        public Map.Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry<String, String> entry = new MapEntry<String, String>();
            while (true) {
                XMLEvent event;
                if ((event = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (event.isAttribute() || event.isStartElement()) {
                    if (context.testExpression("Name", targetDepth)) {
                        entry.setKey(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("Value", targetDepth)) continue;
                    entry.setValue(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (event.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static AttributesMapEntryUnmarshaller getInstance() {
            if (instance == null) {
                instance = new AttributesMapEntryUnmarshaller();
            }
            return instance;
        }
    }
}

