/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.RestoreDBInstanceToPointInTimeRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreDBInstanceToPointInTimeRequestUnmarshaller
implements Unmarshaller<RestoreDBInstanceToPointInTimeRequest, Node> {
    @Override
    public RestoreDBInstanceToPointInTimeRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        RestoreDBInstanceToPointInTimeRequest restoreDBInstanceToPointInTimeRequest = new RestoreDBInstanceToPointInTimeRequest();
        Node sourceDBInstanceIdentifierNode = XpathUtils.asNode("SourceDBInstanceIdentifier", node);
        restoreDBInstanceToPointInTimeRequest.setSourceDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(sourceDBInstanceIdentifierNode));
        Node targetDBInstanceIdentifierNode = XpathUtils.asNode("TargetDBInstanceIdentifier", node);
        restoreDBInstanceToPointInTimeRequest.setTargetDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(targetDBInstanceIdentifierNode));
        Node restoreTimeNode = XpathUtils.asNode("RestoreTime", node);
        restoreDBInstanceToPointInTimeRequest.setRestoreTime(new SimpleTypeUnmarshallers.DateUnmarshaller().unmarshall(restoreTimeNode));
        Node useLatestRestorableTimeNode = XpathUtils.asNode("UseLatestRestorableTime", node);
        restoreDBInstanceToPointInTimeRequest.setUseLatestRestorableTime(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(useLatestRestorableTimeNode));
        Node dBInstanceClassNode = XpathUtils.asNode("DBInstanceClass", node);
        restoreDBInstanceToPointInTimeRequest.setDBInstanceClass(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceClassNode));
        Node portNode = XpathUtils.asNode("Port", node);
        restoreDBInstanceToPointInTimeRequest.setPort(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(portNode));
        Node availabilityZoneNode = XpathUtils.asNode("AvailabilityZone", node);
        restoreDBInstanceToPointInTimeRequest.setAvailabilityZone(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZoneNode));
        Node multiAZNode = XpathUtils.asNode("MultiAZ", node);
        restoreDBInstanceToPointInTimeRequest.setMultiAZ(new SimpleTypeUnmarshallers.BooleanUnmarshaller().unmarshall(multiAZNode));
        return restoreDBInstanceToPointInTimeRequest;
    }
}

