/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.transform.IpPermissionStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityGroupStaxUnmarshaller
implements Unmarshaller<SecurityGroup, StaxUnmarshallerContext> {
    private static SecurityGroupStaxUnmarshaller instance;

    @Override
    public SecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        SecurityGroup securityGroup = new SecurityGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent event;
            if ((event = context.nextEvent()).isEndDocument()) {
                return securityGroup;
            }
            if (event.isAttribute() || event.isStartElement()) {
                if (context.testExpression("ownerId", targetDepth)) {
                    securityGroup.setOwnerId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupName", targetDepth)) {
                    securityGroup.setGroupName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupDescription", targetDepth)) {
                    securityGroup.setDescription(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ipPermissions/item", targetDepth)) continue;
                securityGroup.getIpPermissions().add(IpPermissionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (event.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return securityGroup;
    }

    public static SecurityGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SecurityGroupStaxUnmarshaller();
        }
        return instance;
    }
}

