/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    @Override
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        DefaultRequest<ModifySnapshotAttributeRequest> request = new DefaultRequest<ModifySnapshotAttributeRequest>(modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2009-11-30");
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString(modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest != null && modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifySnapshotAttributeRequest.getOperationType()));
        }
        if (modifySnapshotAttributeRequest != null) {
            List<String> userIdsList = modifySnapshotAttributeRequest.getUserIds();
            int userIdsListIndex = 1;
            for (String userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString(userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (modifySnapshotAttributeRequest != null) {
            List<String> groupNamesList = modifySnapshotAttributeRequest.getGroupNames();
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("Group." + groupNamesListIndex, StringUtils.fromString(groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        return request;
    }
}

