/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDhcpOptionsRequestMarshaller
implements Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {
    @Override
    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        DefaultRequest<CreateDhcpOptionsRequest> request = new DefaultRequest<CreateDhcpOptionsRequest>(createDhcpOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2009-11-30");
        if (createDhcpOptionsRequest != null) {
            DhcpConfiguration dhcpConfiguration = createDhcpOptionsRequest.getDhcpConfiguration();
            if (dhcpConfiguration != null && dhcpConfiguration.getKey() != null) {
                request.addParameter("DhcpConfiguration.Key", StringUtils.fromString(dhcpConfiguration.getKey()));
            }
            if (dhcpConfiguration != null) {
                List<String> valuesList = dhcpConfiguration.getValues();
                int valuesListIndex = 1;
                for (String valuesListValue : valuesList) {
                    if (valuesListValue != null) {
                        request.addParameter("DhcpConfiguration.Value." + valuesListIndex, StringUtils.fromString(valuesListValue));
                    }
                    ++valuesListIndex;
                }
            }
        }
        return request;
    }
}

