/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model.transform;

import com.amazonaws.services.rds.model.CreateDBInstanceRequest;
import com.amazonaws.transform.SimpleTypeUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.XpathUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDBInstanceRequestUnmarshaller
implements Unmarshaller<CreateDBInstanceRequest, Node> {
    @Override
    public CreateDBInstanceRequest unmarshall(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        CreateDBInstanceRequest createDBInstanceRequest = new CreateDBInstanceRequest();
        Node dBNameNode = XpathUtils.asNode("DBName", node);
        createDBInstanceRequest.setDBName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBNameNode));
        Node dBInstanceIdentifierNode = XpathUtils.asNode("DBInstanceIdentifier", node);
        createDBInstanceRequest.setDBInstanceIdentifier(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceIdentifierNode));
        Node allocatedStorageNode = XpathUtils.asNode("AllocatedStorage", node);
        createDBInstanceRequest.setAllocatedStorage(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(allocatedStorageNode));
        Node dBInstanceClassNode = XpathUtils.asNode("DBInstanceClass", node);
        createDBInstanceRequest.setDBInstanceClass(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBInstanceClassNode));
        Node engineNode = XpathUtils.asNode("Engine", node);
        createDBInstanceRequest.setEngine(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(engineNode));
        Node masterUsernameNode = XpathUtils.asNode("MasterUsername", node);
        createDBInstanceRequest.setMasterUsername(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(masterUsernameNode));
        Node masterUserPasswordNode = XpathUtils.asNode("MasterUserPassword", node);
        createDBInstanceRequest.setMasterUserPassword(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(masterUserPasswordNode));
        NodeList dBSecurityGroupsNodes = XpathUtils.asNodeList("DBSecurityGroups/DBSecurityGroupName", node);
        for (int dBSecurityGroupsIndex = 0; dBSecurityGroupsIndex < XpathUtils.nodeLength(dBSecurityGroupsNodes); ++dBSecurityGroupsIndex) {
            Node dBSecurityGroupsNode = dBSecurityGroupsNodes.item(dBSecurityGroupsIndex);
            createDBInstanceRequest.getDBSecurityGroups().add(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBSecurityGroupsNode));
            dBSecurityGroupsNode.getParentNode().removeChild(dBSecurityGroupsNode);
        }
        Node availabilityZoneNode = XpathUtils.asNode("AvailabilityZone", node);
        createDBInstanceRequest.setAvailabilityZone(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(availabilityZoneNode));
        Node preferredMaintenanceWindowNode = XpathUtils.asNode("PreferredMaintenanceWindow", node);
        createDBInstanceRequest.setPreferredMaintenanceWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredMaintenanceWindowNode));
        Node dBParameterGroupNameNode = XpathUtils.asNode("DBParameterGroupName", node);
        createDBInstanceRequest.setDBParameterGroupName(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(dBParameterGroupNameNode));
        Node backupRetentionPeriodNode = XpathUtils.asNode("BackupRetentionPeriod", node);
        createDBInstanceRequest.setBackupRetentionPeriod(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(backupRetentionPeriodNode));
        Node preferredBackupWindowNode = XpathUtils.asNode("PreferredBackupWindow", node);
        createDBInstanceRequest.setPreferredBackupWindow(new SimpleTypeUnmarshallers.StringUnmarshaller().unmarshall(preferredBackupWindowNode));
        Node portNode = XpathUtils.asNode("Port", node);
        createDBInstanceRequest.setPort(new SimpleTypeUnmarshallers.IntegerUnmarshaller().unmarshall(portNode));
        return createDBInstanceRequest;
    }
}

