/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    @Override
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        DefaultRequest<DescribeImagesRequest> request = new DefaultRequest<DescribeImagesRequest>(describeImagesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2009-11-30");
        if (describeImagesRequest != null) {
            List<String> imageIdsList = describeImagesRequest.getImageIds();
            int imageIdsListIndex = 1;
            for (String imageIdsListValue : imageIdsList) {
                if (imageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString(imageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (describeImagesRequest != null) {
            List<String> ownersList = describeImagesRequest.getOwners();
            int ownersListIndex = 1;
            for (String ownersListValue : ownersList) {
                if (ownersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString(ownersListValue));
                }
                ++ownersListIndex;
            }
        }
        if (describeImagesRequest != null) {
            List<String> executableUsersList = describeImagesRequest.getExecutableUsers();
            int executableUsersListIndex = 1;
            for (String executableUsersListValue : executableUsersList) {
                if (executableUsersListValue != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString(executableUsersListValue));
                }
                ++executableUsersListIndex;
            }
        }
        return request;
    }
}

